; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi < %s --force-dwarf-frame-section -frame-pointer=none                          | FileCheck %s --check-prefix=R7
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi < %s --force-dwarf-frame-section -frame-pointer=reserved                      | FileCheck %s --check-prefix=R7-RES
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi < %s --force-dwarf-frame-section -frame-pointer=all                           | FileCheck %s --check-prefix=R7-ABI
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi < %s --force-dwarf-frame-section -frame-pointer=none     -mattr=+aapcs-frame-chain | FileCheck %s --check-prefix=R11
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi < %s --force-dwarf-frame-section -frame-pointer=reserved -mattr=+aapcs-frame-chain | FileCheck %s --check-prefix=R11-RES
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi < %s --force-dwarf-frame-section -frame-pointer=all      -mattr=+aapcs-frame-chain | FileCheck %s --check-prefix=R11-ABI

; int test1() {
;     return 0;
; }
define i32 @test1() "sign-return-address"="non-leaf" {
; R7-LABEL: test1:
; R7:         .cfi_sections .debug_frame
; R7-NEXT:    .cfi_startproc
; R7-NEXT:  @ %bb.0: @ %entry
; R7-NEXT:    movs r0, #0
; R7-NEXT:    bx lr
;
; R7-RES-LABEL: test1:
; R7-RES:         .cfi_sections .debug_frame
; R7-RES-NEXT:    .cfi_startproc
; R7-RES-NEXT:  @ %bb.0: @ %entry
; R7-RES-NEXT:    movs r0, #0
; R7-RES-NEXT:    bx lr
;
; R7-ABI-LABEL: test1:
; R7-ABI:         .cfi_sections .debug_frame
; R7-ABI-NEXT:    .cfi_startproc
; R7-ABI-NEXT:  @ %bb.0: @ %entry
; R7-ABI-NEXT:    pac r12, lr, sp
; R7-ABI-NEXT:    .save {r7, lr}
; R7-ABI-NEXT:    push {r7, lr}
; R7-ABI-NEXT:    .cfi_def_cfa_offset 8
; R7-ABI-NEXT:    .cfi_offset lr, -4
; R7-ABI-NEXT:    .cfi_offset r7, -8
; R7-ABI-NEXT:    .setfp r7, sp
; R7-ABI-NEXT:    mov r7, sp
; R7-ABI-NEXT:    .cfi_def_cfa_register r7
; R7-ABI-NEXT:    .save {ra_auth_code}
; R7-ABI-NEXT:    str r12, [sp, #-4]!
; R7-ABI-NEXT:    .cfi_offset ra_auth_code, -12
; R7-ABI-NEXT:    movs r0, #0
; R7-ABI-NEXT:    ldr r12, [sp], #4
; R7-ABI-NEXT:    pop.w {r7, lr}
; R7-ABI-NEXT:    aut r12, lr, sp
; R7-ABI-NEXT:    bx lr
;
; R11-LABEL: test1:
; R11:         .cfi_sections .debug_frame
; R11-NEXT:    .cfi_startproc
; R11-NEXT:  @ %bb.0: @ %entry
; R11-NEXT:    movs r0, #0
; R11-NEXT:    bx lr
;
; R11-RES-LABEL: test1:
; R11-RES:         .cfi_sections .debug_frame
; R11-RES-NEXT:    .cfi_startproc
; R11-RES-NEXT:  @ %bb.0: @ %entry
; R11-RES-NEXT:    movs r0, #0
; R11-RES-NEXT:    bx lr
;
; R11-ABI-LABEL: test1:
; R11-ABI:         .cfi_sections .debug_frame
; R11-ABI-NEXT:    .cfi_startproc
; R11-ABI-NEXT:  @ %bb.0: @ %entry
; R11-ABI-NEXT:    pac r12, lr, sp
; R11-ABI-NEXT:    .save {ra_auth_code}
; R11-ABI-NEXT:    str r12, [sp, #-4]!
; R11-ABI-NEXT:    .cfi_def_cfa_offset 4
; R11-ABI-NEXT:    .cfi_offset ra_auth_code, -4
; R11-ABI-NEXT:    .save {r11, lr}
; R11-ABI-NEXT:    push.w {r11, lr}
; R11-ABI-NEXT:    .cfi_def_cfa_offset 12
; R11-ABI-NEXT:    .cfi_offset lr, -8
; R11-ABI-NEXT:    .cfi_offset r11, -12
; R11-ABI-NEXT:    .setfp r11, sp
; R11-ABI-NEXT:    mov r11, sp
; R11-ABI-NEXT:    .cfi_def_cfa_register r11
; R11-ABI-NEXT:    movs r0, #0
; R11-ABI-NEXT:    pop.w {r11, lr}
; R11-ABI-NEXT:    ldr r12, [sp], #4
; R11-ABI-NEXT:    aut r12, lr, sp
; R11-ABI-NEXT:    bx lr
entry:
    ret i32 0
}

; void foo(int n) {
;   int a[n];
;   bar(a);
; }
define dso_local void @test2(i32 noundef %n) "sign-return-address"="non-leaf" {
; R7-LABEL: test2:
; R7:         .cfi_startproc
; R7-NEXT:  @ %bb.0: @ %entry
; R7-NEXT:    pac r12, lr, sp
; R7-NEXT:    .save {r4, r6, r7, ra_auth_code, lr}
; R7-NEXT:    push.w {r4, r6, r7, r12, lr}
; R7-NEXT:    .cfi_def_cfa_offset 20
; R7-NEXT:    .cfi_offset lr, -4
; R7-NEXT:    .cfi_offset ra_auth_code, -8
; R7-NEXT:    .cfi_offset r7, -12
; R7-NEXT:    .cfi_offset r6, -16
; R7-NEXT:    .cfi_offset r4, -20
; R7-NEXT:    .setfp r7, sp, #8
; R7-NEXT:    add r7, sp, #8
; R7-NEXT:    .cfi_def_cfa r7, 12
; R7-NEXT:    .pad #4
; R7-NEXT:    sub sp, #4
; R7-NEXT:    movs r1, #7
; R7-NEXT:    add.w r0, r1, r0, lsl #2
; R7-NEXT:    bic r0, r0, #7
; R7-NEXT:    sub.w r0, sp, r0
; R7-NEXT:    mov sp, r0
; R7-NEXT:    bl take_ptr
; R7-NEXT:    sub.w r4, r7, #8
; R7-NEXT:    mov sp, r4
; R7-NEXT:    pop.w {r4, r6, r7, r12, lr}
; R7-NEXT:    aut r12, lr, sp
; R7-NEXT:    bx lr
;
; R7-RES-LABEL: test2:
; R7-RES:         .cfi_startproc
; R7-RES-NEXT:  @ %bb.0: @ %entry
; R7-RES-NEXT:    pac r12, lr, sp
; R7-RES-NEXT:    .save {r4, r6, r7, lr}
; R7-RES-NEXT:    push {r4, r6, r7, lr}
; R7-RES-NEXT:    .cfi_def_cfa_offset 16
; R7-RES-NEXT:    .cfi_offset lr, -4
; R7-RES-NEXT:    .cfi_offset r7, -8
; R7-RES-NEXT:    .cfi_offset r6, -12
; R7-RES-NEXT:    .cfi_offset r4, -16
; R7-RES-NEXT:    .setfp r7, sp, #8
; R7-RES-NEXT:    add r7, sp, #8
; R7-RES-NEXT:    .cfi_def_cfa r7, 8
; R7-RES-NEXT:    .save {ra_auth_code}
; R7-RES-NEXT:    str r12, [sp, #-4]!
; R7-RES-NEXT:    .cfi_offset ra_auth_code, -20
; R7-RES-NEXT:    .pad #4
; R7-RES-NEXT:    sub sp, #4
; R7-RES-NEXT:    movs r1, #7
; R7-RES-NEXT:    add.w r0, r1, r0, lsl #2
; R7-RES-NEXT:    bic r0, r0, #7
; R7-RES-NEXT:    sub.w r0, sp, r0
; R7-RES-NEXT:    mov sp, r0
; R7-RES-NEXT:    bl take_ptr
; R7-RES-NEXT:    sub.w r4, r7, #12
; R7-RES-NEXT:    mov sp, r4
; R7-RES-NEXT:    ldr r12, [sp], #4
; R7-RES-NEXT:    pop.w {r4, r6, r7, lr}
; R7-RES-NEXT:    aut r12, lr, sp
; R7-RES-NEXT:    bx lr
;
; R7-ABI-LABEL: test2:
; R7-ABI:         .cfi_startproc
; R7-ABI-NEXT:  @ %bb.0: @ %entry
; R7-ABI-NEXT:    pac r12, lr, sp
; R7-ABI-NEXT:    .save {r4, r6, r7, lr}
; R7-ABI-NEXT:    push {r4, r6, r7, lr}
; R7-ABI-NEXT:    .cfi_def_cfa_offset 16
; R7-ABI-NEXT:    .cfi_offset lr, -4
; R7-ABI-NEXT:    .cfi_offset r7, -8
; R7-ABI-NEXT:    .cfi_offset r6, -12
; R7-ABI-NEXT:    .cfi_offset r4, -16
; R7-ABI-NEXT:    .setfp r7, sp, #8
; R7-ABI-NEXT:    add r7, sp, #8
; R7-ABI-NEXT:    .cfi_def_cfa r7, 8
; R7-ABI-NEXT:    .save {ra_auth_code}
; R7-ABI-NEXT:    str r12, [sp, #-4]!
; R7-ABI-NEXT:    .cfi_offset ra_auth_code, -20
; R7-ABI-NEXT:    .pad #4
; R7-ABI-NEXT:    sub sp, #4
; R7-ABI-NEXT:    movs r1, #7
; R7-ABI-NEXT:    add.w r0, r1, r0, lsl #2
; R7-ABI-NEXT:    bic r0, r0, #7
; R7-ABI-NEXT:    sub.w r0, sp, r0
; R7-ABI-NEXT:    mov sp, r0
; R7-ABI-NEXT:    bl take_ptr
; R7-ABI-NEXT:    sub.w r4, r7, #12
; R7-ABI-NEXT:    mov sp, r4
; R7-ABI-NEXT:    ldr r12, [sp], #4
; R7-ABI-NEXT:    pop.w {r4, r6, r7, lr}
; R7-ABI-NEXT:    aut r12, lr, sp
; R7-ABI-NEXT:    bx lr
;
; R11-LABEL: test2:
; R11:         .cfi_startproc
; R11-NEXT:  @ %bb.0: @ %entry
; R11-NEXT:    pac r12, lr, sp
; R11-NEXT:    .save {r4, r7, r11, ra_auth_code, lr}
; R11-NEXT:    push.w {r4, r7, r11, r12, lr}
; R11-NEXT:    .cfi_def_cfa_offset 20
; R11-NEXT:    .cfi_offset lr, -4
; R11-NEXT:    .cfi_offset ra_auth_code, -8
; R11-NEXT:    .cfi_offset r11, -12
; R11-NEXT:    .cfi_offset r7, -16
; R11-NEXT:    .cfi_offset r4, -20
; R11-NEXT:    .setfp r11, sp, #8
; R11-NEXT:    add.w r11, sp, #8
; R11-NEXT:    .cfi_def_cfa r11, 12
; R11-NEXT:    .pad #4
; R11-NEXT:    sub sp, #4
; R11-NEXT:    movs r1, #7
; R11-NEXT:    add.w r0, r1, r0, lsl #2
; R11-NEXT:    bic r0, r0, #7
; R11-NEXT:    sub.w r0, sp, r0
; R11-NEXT:    mov sp, r0
; R11-NEXT:    bl take_ptr
; R11-NEXT:    sub.w r4, r11, #8
; R11-NEXT:    mov sp, r4
; R11-NEXT:    pop.w {r4, r7, r11, r12, lr}
; R11-NEXT:    aut r12, lr, sp
; R11-NEXT:    bx lr
;
; R11-RES-LABEL: test2:
; R11-RES:         .cfi_startproc
; R11-RES-NEXT:  @ %bb.0: @ %entry
; R11-RES-NEXT:    pac r12, lr, sp
; R11-RES-NEXT:    .save {r4, r7, ra_auth_code}
; R11-RES-NEXT:    push.w {r4, r7, r12}
; R11-RES-NEXT:    .cfi_def_cfa_offset 12
; R11-RES-NEXT:    .cfi_offset ra_auth_code, -4
; R11-RES-NEXT:    .cfi_offset r7, -8
; R11-RES-NEXT:    .cfi_offset r4, -12
; R11-RES-NEXT:    .save {r11, lr}
; R11-RES-NEXT:    push.w {r11, lr}
; R11-RES-NEXT:    .cfi_def_cfa_offset 20
; R11-RES-NEXT:    .cfi_offset lr, -16
; R11-RES-NEXT:    .cfi_offset r11, -20
; R11-RES-NEXT:    .setfp r11, sp
; R11-RES-NEXT:    mov r11, sp
; R11-RES-NEXT:    .cfi_def_cfa_register r11
; R11-RES-NEXT:    .pad #4
; R11-RES-NEXT:    sub sp, #4
; R11-RES-NEXT:    movs r1, #7
; R11-RES-NEXT:    add.w r0, r1, r0, lsl #2
; R11-RES-NEXT:    bic r0, r0, #7
; R11-RES-NEXT:    sub.w r0, sp, r0
; R11-RES-NEXT:    mov sp, r0
; R11-RES-NEXT:    bl take_ptr
; R11-RES-NEXT:    mov sp, r11
; R11-RES-NEXT:    pop.w {r11, lr}
; R11-RES-NEXT:    pop.w {r4, r7, r12}
; R11-RES-NEXT:    aut r12, lr, sp
; R11-RES-NEXT:    bx lr
;
; R11-ABI-LABEL: test2:
; R11-ABI:         .cfi_startproc
; R11-ABI-NEXT:  @ %bb.0: @ %entry
; R11-ABI-NEXT:    pac r12, lr, sp
; R11-ABI-NEXT:    .save {r4, r7, ra_auth_code}
; R11-ABI-NEXT:    push.w {r4, r7, r12}
; R11-ABI-NEXT:    .cfi_def_cfa_offset 12
; R11-ABI-NEXT:    .cfi_offset ra_auth_code, -4
; R11-ABI-NEXT:    .cfi_offset r7, -8
; R11-ABI-NEXT:    .cfi_offset r4, -12
; R11-ABI-NEXT:    .save {r11, lr}
; R11-ABI-NEXT:    push.w {r11, lr}
; R11-ABI-NEXT:    .cfi_def_cfa_offset 20
; R11-ABI-NEXT:    .cfi_offset lr, -16
; R11-ABI-NEXT:    .cfi_offset r11, -20
; R11-ABI-NEXT:    .setfp r11, sp
; R11-ABI-NEXT:    mov r11, sp
; R11-ABI-NEXT:    .cfi_def_cfa_register r11
; R11-ABI-NEXT:    .pad #4
; R11-ABI-NEXT:    sub sp, #4
; R11-ABI-NEXT:    movs r1, #7
; R11-ABI-NEXT:    add.w r0, r1, r0, lsl #2
; R11-ABI-NEXT:    bic r0, r0, #7
; R11-ABI-NEXT:    sub.w r0, sp, r0
; R11-ABI-NEXT:    mov sp, r0
; R11-ABI-NEXT:    bl take_ptr
; R11-ABI-NEXT:    mov sp, r11
; R11-ABI-NEXT:    pop.w {r11, lr}
; R11-ABI-NEXT:    pop.w {r4, r7, r12}
; R11-ABI-NEXT:    aut r12, lr, sp
; R11-ABI-NEXT:    bx lr
entry:
  %vla = alloca i32, i32 %n, align 4
  call void @take_ptr(ptr noundef nonnull %vla)
  ret void
}

; void test3(int c, float e, int z) {
;   if (c)
;     knr();
;   take_ptr(alloca(z));
;   if (e)
;     knr();
; }
define void @test3(i32 noundef %c, float noundef %e, i32 noundef %z) "sign-return-address"="non-leaf" {
; R7-LABEL: test3:
; R7:         .cfi_startproc
; R7-NEXT:  @ %bb.0: @ %entry
; R7-NEXT:    pac r12, lr, sp
; R7-NEXT:    .save {r4, r5, r6, r7, r8, ra_auth_code, lr}
; R7-NEXT:    push.w {r4, r5, r6, r7, r8, r12, lr}
; R7-NEXT:    .cfi_def_cfa_offset 28
; R7-NEXT:    .cfi_offset lr, -4
; R7-NEXT:    .cfi_offset ra_auth_code, -8
; R7-NEXT:    .cfi_offset r8, -12
; R7-NEXT:    .cfi_offset r7, -16
; R7-NEXT:    .cfi_offset r6, -20
; R7-NEXT:    .cfi_offset r5, -24
; R7-NEXT:    .cfi_offset r4, -28
; R7-NEXT:    .setfp r7, sp, #12
; R7-NEXT:    add r7, sp, #12
; R7-NEXT:    .cfi_def_cfa r7, 16
; R7-NEXT:    .pad #4
; R7-NEXT:    sub sp, #4
; R7-NEXT:    cmp r0, #0
; R7-NEXT:    mov r5, r2
; R7-NEXT:    mov r4, r1
; R7-NEXT:    it ne
; R7-NEXT:    blne knr
; R7-NEXT:    adds r0, r5, #7
; R7-NEXT:    bic r0, r0, #7
; R7-NEXT:    sub.w r0, sp, r0
; R7-NEXT:    mov sp, r0
; R7-NEXT:    bl take_ptr
; R7-NEXT:    mov r0, r4
; R7-NEXT:    movs r1, #0
; R7-NEXT:    bl __aeabi_fcmpeq
; R7-NEXT:    cmp r0, #0
; R7-NEXT:    it eq
; R7-NEXT:    bleq knr
; R7-NEXT:    sub.w r4, r7, #12
; R7-NEXT:    mov sp, r4
; R7-NEXT:    pop.w {r4, r5, r6, r7, r8, r12, lr}
; R7-NEXT:    aut r12, lr, sp
; R7-NEXT:    bx lr
;
; R7-RES-LABEL: test3:
; R7-RES:         .cfi_startproc
; R7-RES-NEXT:  @ %bb.0: @ %entry
; R7-RES-NEXT:    pac r12, lr, sp
; R7-RES-NEXT:    .save {r4, r5, r6, r7, lr}
; R7-RES-NEXT:    push {r4, r5, r6, r7, lr}
; R7-RES-NEXT:    .cfi_def_cfa_offset 20
; R7-RES-NEXT:    .cfi_offset lr, -4
; R7-RES-NEXT:    .cfi_offset r7, -8
; R7-RES-NEXT:    .cfi_offset r6, -12
; R7-RES-NEXT:    .cfi_offset r5, -16
; R7-RES-NEXT:    .cfi_offset r4, -20
; R7-RES-NEXT:    .setfp r7, sp, #12
; R7-RES-NEXT:    add r7, sp, #12
; R7-RES-NEXT:    .cfi_def_cfa r7, 8
; R7-RES-NEXT:    .save {r8, ra_auth_code}
; R7-RES-NEXT:    push.w {r8, r12}
; R7-RES-NEXT:    .cfi_offset ra_auth_code, -24
; R7-RES-NEXT:    .cfi_offset r8, -28
; R7-RES-NEXT:    .pad #4
; R7-RES-NEXT:    sub sp, #4
; R7-RES-NEXT:    cmp r0, #0
; R7-RES-NEXT:    mov r5, r2
; R7-RES-NEXT:    mov r4, r1
; R7-RES-NEXT:    it ne
; R7-RES-NEXT:    blne knr
; R7-RES-NEXT:    adds r0, r5, #7
; R7-RES-NEXT:    bic r0, r0, #7
; R7-RES-NEXT:    sub.w r0, sp, r0
; R7-RES-NEXT:    mov sp, r0
; R7-RES-NEXT:    bl take_ptr
; R7-RES-NEXT:    mov r0, r4
; R7-RES-NEXT:    movs r1, #0
; R7-RES-NEXT:    bl __aeabi_fcmpeq
; R7-RES-NEXT:    cmp r0, #0
; R7-RES-NEXT:    it eq
; R7-RES-NEXT:    bleq knr
; R7-RES-NEXT:    sub.w r4, r7, #20
; R7-RES-NEXT:    mov sp, r4
; R7-RES-NEXT:    pop.w {r8, r12}
; R7-RES-NEXT:    pop.w {r4, r5, r6, r7, lr}
; R7-RES-NEXT:    aut r12, lr, sp
; R7-RES-NEXT:    bx lr
;
; R7-ABI-LABEL: test3:
; R7-ABI:         .cfi_startproc
; R7-ABI-NEXT:  @ %bb.0: @ %entry
; R7-ABI-NEXT:    pac r12, lr, sp
; R7-ABI-NEXT:    .save {r4, r5, r6, r7, lr}
; R7-ABI-NEXT:    push {r4, r5, r6, r7, lr}
; R7-ABI-NEXT:    .cfi_def_cfa_offset 20
; R7-ABI-NEXT:    .cfi_offset lr, -4
; R7-ABI-NEXT:    .cfi_offset r7, -8
; R7-ABI-NEXT:    .cfi_offset r6, -12
; R7-ABI-NEXT:    .cfi_offset r5, -16
; R7-ABI-NEXT:    .cfi_offset r4, -20
; R7-ABI-NEXT:    .setfp r7, sp, #12
; R7-ABI-NEXT:    add r7, sp, #12
; R7-ABI-NEXT:    .cfi_def_cfa r7, 8
; R7-ABI-NEXT:    .save {r8, ra_auth_code}
; R7-ABI-NEXT:    push.w {r8, r12}
; R7-ABI-NEXT:    .cfi_offset ra_auth_code, -24
; R7-ABI-NEXT:    .cfi_offset r8, -28
; R7-ABI-NEXT:    .pad #4
; R7-ABI-NEXT:    sub sp, #4
; R7-ABI-NEXT:    cmp r0, #0
; R7-ABI-NEXT:    mov r5, r2
; R7-ABI-NEXT:    mov r4, r1
; R7-ABI-NEXT:    it ne
; R7-ABI-NEXT:    blne knr
; R7-ABI-NEXT:    adds r0, r5, #7
; R7-ABI-NEXT:    bic r0, r0, #7
; R7-ABI-NEXT:    sub.w r0, sp, r0
; R7-ABI-NEXT:    mov sp, r0
; R7-ABI-NEXT:    bl take_ptr
; R7-ABI-NEXT:    mov r0, r4
; R7-ABI-NEXT:    movs r1, #0
; R7-ABI-NEXT:    bl __aeabi_fcmpeq
; R7-ABI-NEXT:    cmp r0, #0
; R7-ABI-NEXT:    it eq
; R7-ABI-NEXT:    bleq knr
; R7-ABI-NEXT:    sub.w r4, r7, #20
; R7-ABI-NEXT:    mov sp, r4
; R7-ABI-NEXT:    pop.w {r8, r12}
; R7-ABI-NEXT:    pop.w {r4, r5, r6, r7, lr}
; R7-ABI-NEXT:    aut r12, lr, sp
; R7-ABI-NEXT:    bx lr
;
; R11-LABEL: test3:
; R11:         .cfi_startproc
; R11-NEXT:  @ %bb.0: @ %entry
; R11-NEXT:    pac r12, lr, sp
; R11-NEXT:    .save {r4, r5, r6, r7, r11, ra_auth_code, lr}
; R11-NEXT:    push.w {r4, r5, r6, r7, r11, r12, lr}
; R11-NEXT:    .cfi_def_cfa_offset 28
; R11-NEXT:    .cfi_offset lr, -4
; R11-NEXT:    .cfi_offset ra_auth_code, -8
; R11-NEXT:    .cfi_offset r11, -12
; R11-NEXT:    .cfi_offset r7, -16
; R11-NEXT:    .cfi_offset r6, -20
; R11-NEXT:    .cfi_offset r5, -24
; R11-NEXT:    .cfi_offset r4, -28
; R11-NEXT:    .setfp r11, sp, #16
; R11-NEXT:    add.w r11, sp, #16
; R11-NEXT:    .cfi_def_cfa r11, 12
; R11-NEXT:    .pad #4
; R11-NEXT:    sub sp, #4
; R11-NEXT:    cmp r0, #0
; R11-NEXT:    mov r5, r2
; R11-NEXT:    mov r4, r1
; R11-NEXT:    it ne
; R11-NEXT:    blne knr
; R11-NEXT:    adds r0, r5, #7
; R11-NEXT:    bic r0, r0, #7
; R11-NEXT:    sub.w r0, sp, r0
; R11-NEXT:    mov sp, r0
; R11-NEXT:    bl take_ptr
; R11-NEXT:    mov r0, r4
; R11-NEXT:    movs r1, #0
; R11-NEXT:    bl __aeabi_fcmpeq
; R11-NEXT:    cmp r0, #0
; R11-NEXT:    it eq
; R11-NEXT:    bleq knr
; R11-NEXT:    sub.w r4, r11, #16
; R11-NEXT:    mov sp, r4
; R11-NEXT:    pop.w {r4, r5, r6, r7, r11, r12, lr}
; R11-NEXT:    aut r12, lr, sp
; R11-NEXT:    bx lr
;
; R11-RES-LABEL: test3:
; R11-RES:         .cfi_startproc
; R11-RES-NEXT:  @ %bb.0: @ %entry
; R11-RES-NEXT:    pac r12, lr, sp
; R11-RES-NEXT:    .save {r4, r5, r6, r7, ra_auth_code}
; R11-RES-NEXT:    push.w {r4, r5, r6, r7, r12}
; R11-RES-NEXT:    .cfi_def_cfa_offset 20
; R11-RES-NEXT:    .cfi_offset ra_auth_code, -4
; R11-RES-NEXT:    .cfi_offset r7, -8
; R11-RES-NEXT:    .cfi_offset r6, -12
; R11-RES-NEXT:    .cfi_offset r5, -16
; R11-RES-NEXT:    .cfi_offset r4, -20
; R11-RES-NEXT:    .save {r11, lr}
; R11-RES-NEXT:    push.w {r11, lr}
; R11-RES-NEXT:    .cfi_def_cfa_offset 28
; R11-RES-NEXT:    .cfi_offset lr, -24
; R11-RES-NEXT:    .cfi_offset r11, -28
; R11-RES-NEXT:    .setfp r11, sp
; R11-RES-NEXT:    mov r11, sp
; R11-RES-NEXT:    .cfi_def_cfa_register r11
; R11-RES-NEXT:    .pad #4
; R11-RES-NEXT:    sub sp, #4
; R11-RES-NEXT:    cmp r0, #0
; R11-RES-NEXT:    mov r5, r2
; R11-RES-NEXT:    mov r4, r1
; R11-RES-NEXT:    it ne
; R11-RES-NEXT:    blne knr
; R11-RES-NEXT:    adds r0, r5, #7
; R11-RES-NEXT:    bic r0, r0, #7
; R11-RES-NEXT:    sub.w r0, sp, r0
; R11-RES-NEXT:    mov sp, r0
; R11-RES-NEXT:    bl take_ptr
; R11-RES-NEXT:    mov r0, r4
; R11-RES-NEXT:    movs r1, #0
; R11-RES-NEXT:    bl __aeabi_fcmpeq
; R11-RES-NEXT:    cmp r0, #0
; R11-RES-NEXT:    it eq
; R11-RES-NEXT:    bleq knr
; R11-RES-NEXT:    mov sp, r11
; R11-RES-NEXT:    pop.w {r11, lr}
; R11-RES-NEXT:    pop.w {r4, r5, r6, r7, r12}
; R11-RES-NEXT:    aut r12, lr, sp
; R11-RES-NEXT:    bx lr
;
; R11-ABI-LABEL: test3:
; R11-ABI:         .cfi_startproc
; R11-ABI-NEXT:  @ %bb.0: @ %entry
; R11-ABI-NEXT:    pac r12, lr, sp
; R11-ABI-NEXT:    .save {r4, r5, r6, r7, ra_auth_code}
; R11-ABI-NEXT:    push.w {r4, r5, r6, r7, r12}
; R11-ABI-NEXT:    .cfi_def_cfa_offset 20
; R11-ABI-NEXT:    .cfi_offset ra_auth_code, -4
; R11-ABI-NEXT:    .cfi_offset r7, -8
; R11-ABI-NEXT:    .cfi_offset r6, -12
; R11-ABI-NEXT:    .cfi_offset r5, -16
; R11-ABI-NEXT:    .cfi_offset r4, -20
; R11-ABI-NEXT:    .save {r11, lr}
; R11-ABI-NEXT:    push.w {r11, lr}
; R11-ABI-NEXT:    .cfi_def_cfa_offset 28
; R11-ABI-NEXT:    .cfi_offset lr, -24
; R11-ABI-NEXT:    .cfi_offset r11, -28
; R11-ABI-NEXT:    .setfp r11, sp
; R11-ABI-NEXT:    mov r11, sp
; R11-ABI-NEXT:    .cfi_def_cfa_register r11
; R11-ABI-NEXT:    .pad #4
; R11-ABI-NEXT:    sub sp, #4
; R11-ABI-NEXT:    cmp r0, #0
; R11-ABI-NEXT:    mov r5, r2
; R11-ABI-NEXT:    mov r4, r1
; R11-ABI-NEXT:    it ne
; R11-ABI-NEXT:    blne knr
; R11-ABI-NEXT:    adds r0, r5, #7
; R11-ABI-NEXT:    bic r0, r0, #7
; R11-ABI-NEXT:    sub.w r0, sp, r0
; R11-ABI-NEXT:    mov sp, r0
; R11-ABI-NEXT:    bl take_ptr
; R11-ABI-NEXT:    mov r0, r4
; R11-ABI-NEXT:    movs r1, #0
; R11-ABI-NEXT:    bl __aeabi_fcmpeq
; R11-ABI-NEXT:    cmp r0, #0
; R11-ABI-NEXT:    it eq
; R11-ABI-NEXT:    bleq knr
; R11-ABI-NEXT:    mov sp, r11
; R11-ABI-NEXT:    pop.w {r11, lr}
; R11-ABI-NEXT:    pop.w {r4, r5, r6, r7, r12}
; R11-ABI-NEXT:    aut r12, lr, sp
; R11-ABI-NEXT:    bx lr
entry:
  %tobool.not = icmp eq i32 %c, 0
  br i1 %tobool.not, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  tail call void @knr()
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %0 = alloca i8, i32 %z, align 8
  call void @take_ptr(ptr noundef nonnull %0)
  %tobool1 = fcmp une float %e, 0.000000e+00
  br i1 %tobool1, label %if.then2, label %if.end3

if.then2:                                         ; preds = %if.end
  call void @knr()
  br label %if.end3

if.end3:                                          ; preds = %if.then2, %if.end
  ret void
}

declare void @knr(...)
declare void @take_ptr(ptr noundef)
