﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.CodeAnalysis.CSharp.Snippets;

/// <summary>
/// Contains C#-specific snippet identifiers.
/// These either are C# keywords, contain C# keywords or represent C#-only language constructs
/// </summary>
internal static class CSharpSnippetIdentifiers
{
    public const string Class = "class";
    public const string Do = "do";
    public const string Else = "else";
    public const string Enum = "enum";
    public const string For = "for";
    public const string ReversedFor = "forr";
    public const string ForEach = "foreach";
    public const string InitOnlyProperty = "propi";
    public const string RequiredProperty = "propr";
    public const string If = "if";
    public const string Interface = "interface";
    public const string Lock = "lock";
    public const string StaticIntMain = "sim";
    public const string Struct = "struct";
    public const string StaticVoidMain = "svm";
    public const string Using = "using";
    public const string While = "while";
}
