/*
 * Copyright (c) 2018, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jdi/Event/_itself_/event002.
 * VM Testbase keywords: [jpda, jdi]
 * VM Testbase readme:
 * DESCRIPTION
 *     The test checks up on the JDI interface
 *     com.sun.jdi.event.Event.
 *     A debugger part of the test creates several AccessWatchpointRequests,
 *     and then it verifies that appropriate events will be generated
 *     by a target VM. After that, the debugger removes the list of
 *     the event requests via deleteEventRequests() call. Finally,
 *     the test checks that the events which corresponding requests
 *     have been deleted, are not generated by the target VM.
 * COMMENTS
 *     The test was updated due to the bug 4455653.
 *     --------------------------------------------
 *     To fix the bug 4509034,
 *     the check if
 *                  vm.canWatchFieldAccess() == true
 *     is added to the beginning of the test.
 *     --------------------------------------------
 *     To fix the bug 4615225,
 *     the test suite was moved here.
 *     --------------------------------------------
 *     Test updated to prevent possible VMDisconnectedException on VMDeathEvent:
 *     - quit on VMDeathEvent added to events handling loop
 *     Fixed according to 6290118 bug.
 *
 * @library /vmTestbase
 *          /test/lib
 * @build nsk.jdi.Event._itself_.event002
 *        nsk.jdi.Event._itself_.event002t
 * @run driver
 *      nsk.jdi.Event._itself_.event002
 *      -verbose
 *      -arch=${os.family}-${os.simpleArch}
 *      -waittime=5
 *      -debugee.vmkind=java
 *      -transport.address=dynamic
 *      -debugee.vmkeys="${test.vm.opts} ${test.java.opts}"
 */

