/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#include <istream>
#include "fit_mesg_broadcaster.hpp"
#include <algorithm>

namespace fit
{

MesgBroadcaster::MesgBroadcaster(void)
{
}

FIT_BOOL MesgBroadcaster::Run(std::istream& file)
{
    Decode decode;
    FIT_BOOL status = FIT_TRUE;
    FIT_UINT32 fileSize = 0;

    // We can't guarantee that the file stream was reset
    file.seekg(0, file.beg);
    file.clear();
    // Read out the size of the file
    file.seekg(0, file.end);
    fileSize = (FIT_UINT32)file.tellg();
    // Ensure the read starts at the beginning of the file
    file.seekg(0, file.beg);
    file.clear();

    status = decode.Read(file, *this, *this);

    return status;
}

void MesgBroadcaster::AddListener(MesgDefinitionListener& mesgDefinitionListener)
{
    mesgDefinitionListeners.push_back(&mesgDefinitionListener);
}

void MesgBroadcaster::RemoveListener(MesgDefinitionListener& mesgDefinitionListener)
{
    mesgDefinitionListeners.erase(std::find(mesgDefinitionListeners.begin(), mesgDefinitionListeners.end(), &mesgDefinitionListener));
}

void MesgBroadcaster::AddListener(MesgListener& mesgListener)
{
    mesgListeners.push_back(&mesgListener);
}

void MesgBroadcaster::RemoveListener(MesgListener& mesgListener)
{
    mesgListeners.erase(std::find(mesgListeners.begin(), mesgListeners.end(), &mesgListener));
}

void MesgBroadcaster::AddListener(MesgWithEventListener& mesgListener)
{
    mesgWithEventBroadcaster.AddListener(mesgListener);
}

void MesgBroadcaster::RemoveListener(MesgWithEventListener& mesgListener)
{
    mesgWithEventBroadcaster.RemoveListener(mesgListener);
}

void MesgBroadcaster::AddListener(BufferedRecordMesgListener& bufferedRecordMesgListener)
{
    bufferedRecordMesgBroadcaster.AddListener(bufferedRecordMesgListener);
}

void MesgBroadcaster::RemoveListener(BufferedRecordMesgListener& bufferedRecordMesgListener)
{
    bufferedRecordMesgBroadcaster.RemoveListener(bufferedRecordMesgListener);
}

void MesgBroadcaster::AddListener(FileIdMesgListener& fileIdMesgListener)
{
   fileIdMesgListeners.push_back(&fileIdMesgListener);
}

void MesgBroadcaster::RemoveListener(FileIdMesgListener& fileIdMesgListener)
{
    std::vector<FileIdMesgListener *>::iterator it = std::find(fileIdMesgListeners.begin(), fileIdMesgListeners.end(), &fileIdMesgListener);
    if (fileIdMesgListeners.end() != it)
    fileIdMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(FileCreatorMesgListener& fileCreatorMesgListener)
{
   fileCreatorMesgListeners.push_back(&fileCreatorMesgListener);
}

void MesgBroadcaster::RemoveListener(FileCreatorMesgListener& fileCreatorMesgListener)
{
    std::vector<FileCreatorMesgListener *>::iterator it = std::find(fileCreatorMesgListeners.begin(), fileCreatorMesgListeners.end(), &fileCreatorMesgListener);
    if (fileCreatorMesgListeners.end() != it)
    fileCreatorMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(TimestampCorrelationMesgListener& timestampCorrelationMesgListener)
{
   timestampCorrelationMesgListeners.push_back(&timestampCorrelationMesgListener);
}

void MesgBroadcaster::RemoveListener(TimestampCorrelationMesgListener& timestampCorrelationMesgListener)
{
    std::vector<TimestampCorrelationMesgListener *>::iterator it = std::find(timestampCorrelationMesgListeners.begin(), timestampCorrelationMesgListeners.end(), &timestampCorrelationMesgListener);
    if (timestampCorrelationMesgListeners.end() != it)
    timestampCorrelationMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SoftwareMesgListener& softwareMesgListener)
{
   softwareMesgListeners.push_back(&softwareMesgListener);
}

void MesgBroadcaster::RemoveListener(SoftwareMesgListener& softwareMesgListener)
{
    std::vector<SoftwareMesgListener *>::iterator it = std::find(softwareMesgListeners.begin(), softwareMesgListeners.end(), &softwareMesgListener);
    if (softwareMesgListeners.end() != it)
    softwareMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SlaveDeviceMesgListener& slaveDeviceMesgListener)
{
   slaveDeviceMesgListeners.push_back(&slaveDeviceMesgListener);
}

void MesgBroadcaster::RemoveListener(SlaveDeviceMesgListener& slaveDeviceMesgListener)
{
    std::vector<SlaveDeviceMesgListener *>::iterator it = std::find(slaveDeviceMesgListeners.begin(), slaveDeviceMesgListeners.end(), &slaveDeviceMesgListener);
    if (slaveDeviceMesgListeners.end() != it)
    slaveDeviceMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(CapabilitiesMesgListener& capabilitiesMesgListener)
{
   capabilitiesMesgListeners.push_back(&capabilitiesMesgListener);
}

void MesgBroadcaster::RemoveListener(CapabilitiesMesgListener& capabilitiesMesgListener)
{
    std::vector<CapabilitiesMesgListener *>::iterator it = std::find(capabilitiesMesgListeners.begin(), capabilitiesMesgListeners.end(), &capabilitiesMesgListener);
    if (capabilitiesMesgListeners.end() != it)
    capabilitiesMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(FileCapabilitiesMesgListener& fileCapabilitiesMesgListener)
{
   fileCapabilitiesMesgListeners.push_back(&fileCapabilitiesMesgListener);
}

void MesgBroadcaster::RemoveListener(FileCapabilitiesMesgListener& fileCapabilitiesMesgListener)
{
    std::vector<FileCapabilitiesMesgListener *>::iterator it = std::find(fileCapabilitiesMesgListeners.begin(), fileCapabilitiesMesgListeners.end(), &fileCapabilitiesMesgListener);
    if (fileCapabilitiesMesgListeners.end() != it)
    fileCapabilitiesMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MesgCapabilitiesMesgListener& mesgCapabilitiesMesgListener)
{
   mesgCapabilitiesMesgListeners.push_back(&mesgCapabilitiesMesgListener);
}

void MesgBroadcaster::RemoveListener(MesgCapabilitiesMesgListener& mesgCapabilitiesMesgListener)
{
    std::vector<MesgCapabilitiesMesgListener *>::iterator it = std::find(mesgCapabilitiesMesgListeners.begin(), mesgCapabilitiesMesgListeners.end(), &mesgCapabilitiesMesgListener);
    if (mesgCapabilitiesMesgListeners.end() != it)
    mesgCapabilitiesMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(FieldCapabilitiesMesgListener& fieldCapabilitiesMesgListener)
{
   fieldCapabilitiesMesgListeners.push_back(&fieldCapabilitiesMesgListener);
}

void MesgBroadcaster::RemoveListener(FieldCapabilitiesMesgListener& fieldCapabilitiesMesgListener)
{
    std::vector<FieldCapabilitiesMesgListener *>::iterator it = std::find(fieldCapabilitiesMesgListeners.begin(), fieldCapabilitiesMesgListeners.end(), &fieldCapabilitiesMesgListener);
    if (fieldCapabilitiesMesgListeners.end() != it)
    fieldCapabilitiesMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DeviceSettingsMesgListener& deviceSettingsMesgListener)
{
   deviceSettingsMesgListeners.push_back(&deviceSettingsMesgListener);
}

void MesgBroadcaster::RemoveListener(DeviceSettingsMesgListener& deviceSettingsMesgListener)
{
    std::vector<DeviceSettingsMesgListener *>::iterator it = std::find(deviceSettingsMesgListeners.begin(), deviceSettingsMesgListeners.end(), &deviceSettingsMesgListener);
    if (deviceSettingsMesgListeners.end() != it)
    deviceSettingsMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(UserProfileMesgListener& userProfileMesgListener)
{
   userProfileMesgListeners.push_back(&userProfileMesgListener);
}

void MesgBroadcaster::RemoveListener(UserProfileMesgListener& userProfileMesgListener)
{
    std::vector<UserProfileMesgListener *>::iterator it = std::find(userProfileMesgListeners.begin(), userProfileMesgListeners.end(), &userProfileMesgListener);
    if (userProfileMesgListeners.end() != it)
    userProfileMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HrmProfileMesgListener& hrmProfileMesgListener)
{
   hrmProfileMesgListeners.push_back(&hrmProfileMesgListener);
}

void MesgBroadcaster::RemoveListener(HrmProfileMesgListener& hrmProfileMesgListener)
{
    std::vector<HrmProfileMesgListener *>::iterator it = std::find(hrmProfileMesgListeners.begin(), hrmProfileMesgListeners.end(), &hrmProfileMesgListener);
    if (hrmProfileMesgListeners.end() != it)
    hrmProfileMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SdmProfileMesgListener& sdmProfileMesgListener)
{
   sdmProfileMesgListeners.push_back(&sdmProfileMesgListener);
}

void MesgBroadcaster::RemoveListener(SdmProfileMesgListener& sdmProfileMesgListener)
{
    std::vector<SdmProfileMesgListener *>::iterator it = std::find(sdmProfileMesgListeners.begin(), sdmProfileMesgListeners.end(), &sdmProfileMesgListener);
    if (sdmProfileMesgListeners.end() != it)
    sdmProfileMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(BikeProfileMesgListener& bikeProfileMesgListener)
{
   bikeProfileMesgListeners.push_back(&bikeProfileMesgListener);
}

void MesgBroadcaster::RemoveListener(BikeProfileMesgListener& bikeProfileMesgListener)
{
    std::vector<BikeProfileMesgListener *>::iterator it = std::find(bikeProfileMesgListeners.begin(), bikeProfileMesgListeners.end(), &bikeProfileMesgListener);
    if (bikeProfileMesgListeners.end() != it)
    bikeProfileMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ConnectivityMesgListener& connectivityMesgListener)
{
   connectivityMesgListeners.push_back(&connectivityMesgListener);
}

void MesgBroadcaster::RemoveListener(ConnectivityMesgListener& connectivityMesgListener)
{
    std::vector<ConnectivityMesgListener *>::iterator it = std::find(connectivityMesgListeners.begin(), connectivityMesgListeners.end(), &connectivityMesgListener);
    if (connectivityMesgListeners.end() != it)
    connectivityMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(WatchfaceSettingsMesgListener& watchfaceSettingsMesgListener)
{
   watchfaceSettingsMesgListeners.push_back(&watchfaceSettingsMesgListener);
}

void MesgBroadcaster::RemoveListener(WatchfaceSettingsMesgListener& watchfaceSettingsMesgListener)
{
    std::vector<WatchfaceSettingsMesgListener *>::iterator it = std::find(watchfaceSettingsMesgListeners.begin(), watchfaceSettingsMesgListeners.end(), &watchfaceSettingsMesgListener);
    if (watchfaceSettingsMesgListeners.end() != it)
    watchfaceSettingsMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(OhrSettingsMesgListener& ohrSettingsMesgListener)
{
   ohrSettingsMesgListeners.push_back(&ohrSettingsMesgListener);
}

void MesgBroadcaster::RemoveListener(OhrSettingsMesgListener& ohrSettingsMesgListener)
{
    std::vector<OhrSettingsMesgListener *>::iterator it = std::find(ohrSettingsMesgListeners.begin(), ohrSettingsMesgListeners.end(), &ohrSettingsMesgListener);
    if (ohrSettingsMesgListeners.end() != it)
    ohrSettingsMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(TimeInZoneMesgListener& timeInZoneMesgListener)
{
   timeInZoneMesgListeners.push_back(&timeInZoneMesgListener);
}

void MesgBroadcaster::RemoveListener(TimeInZoneMesgListener& timeInZoneMesgListener)
{
    std::vector<TimeInZoneMesgListener *>::iterator it = std::find(timeInZoneMesgListeners.begin(), timeInZoneMesgListeners.end(), &timeInZoneMesgListener);
    if (timeInZoneMesgListeners.end() != it)
    timeInZoneMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ZonesTargetMesgListener& zonesTargetMesgListener)
{
   zonesTargetMesgListeners.push_back(&zonesTargetMesgListener);
}

void MesgBroadcaster::RemoveListener(ZonesTargetMesgListener& zonesTargetMesgListener)
{
    std::vector<ZonesTargetMesgListener *>::iterator it = std::find(zonesTargetMesgListeners.begin(), zonesTargetMesgListeners.end(), &zonesTargetMesgListener);
    if (zonesTargetMesgListeners.end() != it)
    zonesTargetMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SportMesgListener& sportMesgListener)
{
   sportMesgListeners.push_back(&sportMesgListener);
}

void MesgBroadcaster::RemoveListener(SportMesgListener& sportMesgListener)
{
    std::vector<SportMesgListener *>::iterator it = std::find(sportMesgListeners.begin(), sportMesgListeners.end(), &sportMesgListener);
    if (sportMesgListeners.end() != it)
    sportMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HrZoneMesgListener& hrZoneMesgListener)
{
   hrZoneMesgListeners.push_back(&hrZoneMesgListener);
}

void MesgBroadcaster::RemoveListener(HrZoneMesgListener& hrZoneMesgListener)
{
    std::vector<HrZoneMesgListener *>::iterator it = std::find(hrZoneMesgListeners.begin(), hrZoneMesgListeners.end(), &hrZoneMesgListener);
    if (hrZoneMesgListeners.end() != it)
    hrZoneMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SpeedZoneMesgListener& speedZoneMesgListener)
{
   speedZoneMesgListeners.push_back(&speedZoneMesgListener);
}

void MesgBroadcaster::RemoveListener(SpeedZoneMesgListener& speedZoneMesgListener)
{
    std::vector<SpeedZoneMesgListener *>::iterator it = std::find(speedZoneMesgListeners.begin(), speedZoneMesgListeners.end(), &speedZoneMesgListener);
    if (speedZoneMesgListeners.end() != it)
    speedZoneMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(CadenceZoneMesgListener& cadenceZoneMesgListener)
{
   cadenceZoneMesgListeners.push_back(&cadenceZoneMesgListener);
}

void MesgBroadcaster::RemoveListener(CadenceZoneMesgListener& cadenceZoneMesgListener)
{
    std::vector<CadenceZoneMesgListener *>::iterator it = std::find(cadenceZoneMesgListeners.begin(), cadenceZoneMesgListeners.end(), &cadenceZoneMesgListener);
    if (cadenceZoneMesgListeners.end() != it)
    cadenceZoneMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(PowerZoneMesgListener& powerZoneMesgListener)
{
   powerZoneMesgListeners.push_back(&powerZoneMesgListener);
}

void MesgBroadcaster::RemoveListener(PowerZoneMesgListener& powerZoneMesgListener)
{
    std::vector<PowerZoneMesgListener *>::iterator it = std::find(powerZoneMesgListeners.begin(), powerZoneMesgListeners.end(), &powerZoneMesgListener);
    if (powerZoneMesgListeners.end() != it)
    powerZoneMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MetZoneMesgListener& metZoneMesgListener)
{
   metZoneMesgListeners.push_back(&metZoneMesgListener);
}

void MesgBroadcaster::RemoveListener(MetZoneMesgListener& metZoneMesgListener)
{
    std::vector<MetZoneMesgListener *>::iterator it = std::find(metZoneMesgListeners.begin(), metZoneMesgListeners.end(), &metZoneMesgListener);
    if (metZoneMesgListeners.end() != it)
    metZoneMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DiveSettingsMesgListener& diveSettingsMesgListener)
{
   diveSettingsMesgListeners.push_back(&diveSettingsMesgListener);
}

void MesgBroadcaster::RemoveListener(DiveSettingsMesgListener& diveSettingsMesgListener)
{
    std::vector<DiveSettingsMesgListener *>::iterator it = std::find(diveSettingsMesgListeners.begin(), diveSettingsMesgListeners.end(), &diveSettingsMesgListener);
    if (diveSettingsMesgListeners.end() != it)
    diveSettingsMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DiveAlarmMesgListener& diveAlarmMesgListener)
{
   diveAlarmMesgListeners.push_back(&diveAlarmMesgListener);
}

void MesgBroadcaster::RemoveListener(DiveAlarmMesgListener& diveAlarmMesgListener)
{
    std::vector<DiveAlarmMesgListener *>::iterator it = std::find(diveAlarmMesgListeners.begin(), diveAlarmMesgListeners.end(), &diveAlarmMesgListener);
    if (diveAlarmMesgListeners.end() != it)
    diveAlarmMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DiveApneaAlarmMesgListener& diveApneaAlarmMesgListener)
{
   diveApneaAlarmMesgListeners.push_back(&diveApneaAlarmMesgListener);
}

void MesgBroadcaster::RemoveListener(DiveApneaAlarmMesgListener& diveApneaAlarmMesgListener)
{
    std::vector<DiveApneaAlarmMesgListener *>::iterator it = std::find(diveApneaAlarmMesgListeners.begin(), diveApneaAlarmMesgListeners.end(), &diveApneaAlarmMesgListener);
    if (diveApneaAlarmMesgListeners.end() != it)
    diveApneaAlarmMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DiveGasMesgListener& diveGasMesgListener)
{
   diveGasMesgListeners.push_back(&diveGasMesgListener);
}

void MesgBroadcaster::RemoveListener(DiveGasMesgListener& diveGasMesgListener)
{
    std::vector<DiveGasMesgListener *>::iterator it = std::find(diveGasMesgListeners.begin(), diveGasMesgListeners.end(), &diveGasMesgListener);
    if (diveGasMesgListeners.end() != it)
    diveGasMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(GoalMesgListener& goalMesgListener)
{
   goalMesgListeners.push_back(&goalMesgListener);
}

void MesgBroadcaster::RemoveListener(GoalMesgListener& goalMesgListener)
{
    std::vector<GoalMesgListener *>::iterator it = std::find(goalMesgListeners.begin(), goalMesgListeners.end(), &goalMesgListener);
    if (goalMesgListeners.end() != it)
    goalMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ActivityMesgListener& activityMesgListener)
{
   activityMesgListeners.push_back(&activityMesgListener);
}

void MesgBroadcaster::RemoveListener(ActivityMesgListener& activityMesgListener)
{
    std::vector<ActivityMesgListener *>::iterator it = std::find(activityMesgListeners.begin(), activityMesgListeners.end(), &activityMesgListener);
    if (activityMesgListeners.end() != it)
    activityMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SessionMesgListener& sessionMesgListener)
{
   sessionMesgListeners.push_back(&sessionMesgListener);
}

void MesgBroadcaster::RemoveListener(SessionMesgListener& sessionMesgListener)
{
    std::vector<SessionMesgListener *>::iterator it = std::find(sessionMesgListeners.begin(), sessionMesgListeners.end(), &sessionMesgListener);
    if (sessionMesgListeners.end() != it)
    sessionMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(LapMesgListener& lapMesgListener)
{
   lapMesgListeners.push_back(&lapMesgListener);
}

void MesgBroadcaster::RemoveListener(LapMesgListener& lapMesgListener)
{
    std::vector<LapMesgListener *>::iterator it = std::find(lapMesgListeners.begin(), lapMesgListeners.end(), &lapMesgListener);
    if (lapMesgListeners.end() != it)
    lapMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(LengthMesgListener& lengthMesgListener)
{
   lengthMesgListeners.push_back(&lengthMesgListener);
}

void MesgBroadcaster::RemoveListener(LengthMesgListener& lengthMesgListener)
{
    std::vector<LengthMesgListener *>::iterator it = std::find(lengthMesgListeners.begin(), lengthMesgListeners.end(), &lengthMesgListener);
    if (lengthMesgListeners.end() != it)
    lengthMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(RecordMesgListener& recordMesgListener)
{
   recordMesgListeners.push_back(&recordMesgListener);
}

void MesgBroadcaster::RemoveListener(RecordMesgListener& recordMesgListener)
{
    std::vector<RecordMesgListener *>::iterator it = std::find(recordMesgListeners.begin(), recordMesgListeners.end(), &recordMesgListener);
    if (recordMesgListeners.end() != it)
    recordMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(EventMesgListener& eventMesgListener)
{
   eventMesgListeners.push_back(&eventMesgListener);
}

void MesgBroadcaster::RemoveListener(EventMesgListener& eventMesgListener)
{
    std::vector<EventMesgListener *>::iterator it = std::find(eventMesgListeners.begin(), eventMesgListeners.end(), &eventMesgListener);
    if (eventMesgListeners.end() != it)
    eventMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DeviceInfoMesgListener& deviceInfoMesgListener)
{
   deviceInfoMesgListeners.push_back(&deviceInfoMesgListener);
}

void MesgBroadcaster::RemoveListener(DeviceInfoMesgListener& deviceInfoMesgListener)
{
    std::vector<DeviceInfoMesgListener *>::iterator it = std::find(deviceInfoMesgListeners.begin(), deviceInfoMesgListeners.end(), &deviceInfoMesgListener);
    if (deviceInfoMesgListeners.end() != it)
    deviceInfoMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DeviceAuxBatteryInfoMesgListener& deviceAuxBatteryInfoMesgListener)
{
   deviceAuxBatteryInfoMesgListeners.push_back(&deviceAuxBatteryInfoMesgListener);
}

void MesgBroadcaster::RemoveListener(DeviceAuxBatteryInfoMesgListener& deviceAuxBatteryInfoMesgListener)
{
    std::vector<DeviceAuxBatteryInfoMesgListener *>::iterator it = std::find(deviceAuxBatteryInfoMesgListeners.begin(), deviceAuxBatteryInfoMesgListeners.end(), &deviceAuxBatteryInfoMesgListener);
    if (deviceAuxBatteryInfoMesgListeners.end() != it)
    deviceAuxBatteryInfoMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(TrainingFileMesgListener& trainingFileMesgListener)
{
   trainingFileMesgListeners.push_back(&trainingFileMesgListener);
}

void MesgBroadcaster::RemoveListener(TrainingFileMesgListener& trainingFileMesgListener)
{
    std::vector<TrainingFileMesgListener *>::iterator it = std::find(trainingFileMesgListeners.begin(), trainingFileMesgListeners.end(), &trainingFileMesgListener);
    if (trainingFileMesgListeners.end() != it)
    trainingFileMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(WeatherConditionsMesgListener& weatherConditionsMesgListener)
{
   weatherConditionsMesgListeners.push_back(&weatherConditionsMesgListener);
}

void MesgBroadcaster::RemoveListener(WeatherConditionsMesgListener& weatherConditionsMesgListener)
{
    std::vector<WeatherConditionsMesgListener *>::iterator it = std::find(weatherConditionsMesgListeners.begin(), weatherConditionsMesgListeners.end(), &weatherConditionsMesgListener);
    if (weatherConditionsMesgListeners.end() != it)
    weatherConditionsMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(WeatherAlertMesgListener& weatherAlertMesgListener)
{
   weatherAlertMesgListeners.push_back(&weatherAlertMesgListener);
}

void MesgBroadcaster::RemoveListener(WeatherAlertMesgListener& weatherAlertMesgListener)
{
    std::vector<WeatherAlertMesgListener *>::iterator it = std::find(weatherAlertMesgListeners.begin(), weatherAlertMesgListeners.end(), &weatherAlertMesgListener);
    if (weatherAlertMesgListeners.end() != it)
    weatherAlertMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(GpsMetadataMesgListener& gpsMetadataMesgListener)
{
   gpsMetadataMesgListeners.push_back(&gpsMetadataMesgListener);
}

void MesgBroadcaster::RemoveListener(GpsMetadataMesgListener& gpsMetadataMesgListener)
{
    std::vector<GpsMetadataMesgListener *>::iterator it = std::find(gpsMetadataMesgListeners.begin(), gpsMetadataMesgListeners.end(), &gpsMetadataMesgListener);
    if (gpsMetadataMesgListeners.end() != it)
    gpsMetadataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(CameraEventMesgListener& cameraEventMesgListener)
{
   cameraEventMesgListeners.push_back(&cameraEventMesgListener);
}

void MesgBroadcaster::RemoveListener(CameraEventMesgListener& cameraEventMesgListener)
{
    std::vector<CameraEventMesgListener *>::iterator it = std::find(cameraEventMesgListeners.begin(), cameraEventMesgListeners.end(), &cameraEventMesgListener);
    if (cameraEventMesgListeners.end() != it)
    cameraEventMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(GyroscopeDataMesgListener& gyroscopeDataMesgListener)
{
   gyroscopeDataMesgListeners.push_back(&gyroscopeDataMesgListener);
}

void MesgBroadcaster::RemoveListener(GyroscopeDataMesgListener& gyroscopeDataMesgListener)
{
    std::vector<GyroscopeDataMesgListener *>::iterator it = std::find(gyroscopeDataMesgListeners.begin(), gyroscopeDataMesgListeners.end(), &gyroscopeDataMesgListener);
    if (gyroscopeDataMesgListeners.end() != it)
    gyroscopeDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(AccelerometerDataMesgListener& accelerometerDataMesgListener)
{
   accelerometerDataMesgListeners.push_back(&accelerometerDataMesgListener);
}

void MesgBroadcaster::RemoveListener(AccelerometerDataMesgListener& accelerometerDataMesgListener)
{
    std::vector<AccelerometerDataMesgListener *>::iterator it = std::find(accelerometerDataMesgListeners.begin(), accelerometerDataMesgListeners.end(), &accelerometerDataMesgListener);
    if (accelerometerDataMesgListeners.end() != it)
    accelerometerDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MagnetometerDataMesgListener& magnetometerDataMesgListener)
{
   magnetometerDataMesgListeners.push_back(&magnetometerDataMesgListener);
}

void MesgBroadcaster::RemoveListener(MagnetometerDataMesgListener& magnetometerDataMesgListener)
{
    std::vector<MagnetometerDataMesgListener *>::iterator it = std::find(magnetometerDataMesgListeners.begin(), magnetometerDataMesgListeners.end(), &magnetometerDataMesgListener);
    if (magnetometerDataMesgListeners.end() != it)
    magnetometerDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(BarometerDataMesgListener& barometerDataMesgListener)
{
   barometerDataMesgListeners.push_back(&barometerDataMesgListener);
}

void MesgBroadcaster::RemoveListener(BarometerDataMesgListener& barometerDataMesgListener)
{
    std::vector<BarometerDataMesgListener *>::iterator it = std::find(barometerDataMesgListeners.begin(), barometerDataMesgListeners.end(), &barometerDataMesgListener);
    if (barometerDataMesgListeners.end() != it)
    barometerDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ThreeDSensorCalibrationMesgListener& threeDSensorCalibrationMesgListener)
{
   threeDSensorCalibrationMesgListeners.push_back(&threeDSensorCalibrationMesgListener);
}

void MesgBroadcaster::RemoveListener(ThreeDSensorCalibrationMesgListener& threeDSensorCalibrationMesgListener)
{
    std::vector<ThreeDSensorCalibrationMesgListener *>::iterator it = std::find(threeDSensorCalibrationMesgListeners.begin(), threeDSensorCalibrationMesgListeners.end(), &threeDSensorCalibrationMesgListener);
    if (threeDSensorCalibrationMesgListeners.end() != it)
    threeDSensorCalibrationMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(OneDSensorCalibrationMesgListener& oneDSensorCalibrationMesgListener)
{
   oneDSensorCalibrationMesgListeners.push_back(&oneDSensorCalibrationMesgListener);
}

void MesgBroadcaster::RemoveListener(OneDSensorCalibrationMesgListener& oneDSensorCalibrationMesgListener)
{
    std::vector<OneDSensorCalibrationMesgListener *>::iterator it = std::find(oneDSensorCalibrationMesgListeners.begin(), oneDSensorCalibrationMesgListeners.end(), &oneDSensorCalibrationMesgListener);
    if (oneDSensorCalibrationMesgListeners.end() != it)
    oneDSensorCalibrationMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(VideoFrameMesgListener& videoFrameMesgListener)
{
   videoFrameMesgListeners.push_back(&videoFrameMesgListener);
}

void MesgBroadcaster::RemoveListener(VideoFrameMesgListener& videoFrameMesgListener)
{
    std::vector<VideoFrameMesgListener *>::iterator it = std::find(videoFrameMesgListeners.begin(), videoFrameMesgListeners.end(), &videoFrameMesgListener);
    if (videoFrameMesgListeners.end() != it)
    videoFrameMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ObdiiDataMesgListener& obdiiDataMesgListener)
{
   obdiiDataMesgListeners.push_back(&obdiiDataMesgListener);
}

void MesgBroadcaster::RemoveListener(ObdiiDataMesgListener& obdiiDataMesgListener)
{
    std::vector<ObdiiDataMesgListener *>::iterator it = std::find(obdiiDataMesgListeners.begin(), obdiiDataMesgListeners.end(), &obdiiDataMesgListener);
    if (obdiiDataMesgListeners.end() != it)
    obdiiDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(NmeaSentenceMesgListener& nmeaSentenceMesgListener)
{
   nmeaSentenceMesgListeners.push_back(&nmeaSentenceMesgListener);
}

void MesgBroadcaster::RemoveListener(NmeaSentenceMesgListener& nmeaSentenceMesgListener)
{
    std::vector<NmeaSentenceMesgListener *>::iterator it = std::find(nmeaSentenceMesgListeners.begin(), nmeaSentenceMesgListeners.end(), &nmeaSentenceMesgListener);
    if (nmeaSentenceMesgListeners.end() != it)
    nmeaSentenceMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(AviationAttitudeMesgListener& aviationAttitudeMesgListener)
{
   aviationAttitudeMesgListeners.push_back(&aviationAttitudeMesgListener);
}

void MesgBroadcaster::RemoveListener(AviationAttitudeMesgListener& aviationAttitudeMesgListener)
{
    std::vector<AviationAttitudeMesgListener *>::iterator it = std::find(aviationAttitudeMesgListeners.begin(), aviationAttitudeMesgListeners.end(), &aviationAttitudeMesgListener);
    if (aviationAttitudeMesgListeners.end() != it)
    aviationAttitudeMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(VideoMesgListener& videoMesgListener)
{
   videoMesgListeners.push_back(&videoMesgListener);
}

void MesgBroadcaster::RemoveListener(VideoMesgListener& videoMesgListener)
{
    std::vector<VideoMesgListener *>::iterator it = std::find(videoMesgListeners.begin(), videoMesgListeners.end(), &videoMesgListener);
    if (videoMesgListeners.end() != it)
    videoMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(VideoTitleMesgListener& videoTitleMesgListener)
{
   videoTitleMesgListeners.push_back(&videoTitleMesgListener);
}

void MesgBroadcaster::RemoveListener(VideoTitleMesgListener& videoTitleMesgListener)
{
    std::vector<VideoTitleMesgListener *>::iterator it = std::find(videoTitleMesgListeners.begin(), videoTitleMesgListeners.end(), &videoTitleMesgListener);
    if (videoTitleMesgListeners.end() != it)
    videoTitleMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(VideoDescriptionMesgListener& videoDescriptionMesgListener)
{
   videoDescriptionMesgListeners.push_back(&videoDescriptionMesgListener);
}

void MesgBroadcaster::RemoveListener(VideoDescriptionMesgListener& videoDescriptionMesgListener)
{
    std::vector<VideoDescriptionMesgListener *>::iterator it = std::find(videoDescriptionMesgListeners.begin(), videoDescriptionMesgListeners.end(), &videoDescriptionMesgListener);
    if (videoDescriptionMesgListeners.end() != it)
    videoDescriptionMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(VideoClipMesgListener& videoClipMesgListener)
{
   videoClipMesgListeners.push_back(&videoClipMesgListener);
}

void MesgBroadcaster::RemoveListener(VideoClipMesgListener& videoClipMesgListener)
{
    std::vector<VideoClipMesgListener *>::iterator it = std::find(videoClipMesgListeners.begin(), videoClipMesgListeners.end(), &videoClipMesgListener);
    if (videoClipMesgListeners.end() != it)
    videoClipMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SetMesgListener& setMesgListener)
{
   setMesgListeners.push_back(&setMesgListener);
}

void MesgBroadcaster::RemoveListener(SetMesgListener& setMesgListener)
{
    std::vector<SetMesgListener *>::iterator it = std::find(setMesgListeners.begin(), setMesgListeners.end(), &setMesgListener);
    if (setMesgListeners.end() != it)
    setMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(JumpMesgListener& jumpMesgListener)
{
   jumpMesgListeners.push_back(&jumpMesgListener);
}

void MesgBroadcaster::RemoveListener(JumpMesgListener& jumpMesgListener)
{
    std::vector<JumpMesgListener *>::iterator it = std::find(jumpMesgListeners.begin(), jumpMesgListeners.end(), &jumpMesgListener);
    if (jumpMesgListeners.end() != it)
    jumpMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SplitMesgListener& splitMesgListener)
{
   splitMesgListeners.push_back(&splitMesgListener);
}

void MesgBroadcaster::RemoveListener(SplitMesgListener& splitMesgListener)
{
    std::vector<SplitMesgListener *>::iterator it = std::find(splitMesgListeners.begin(), splitMesgListeners.end(), &splitMesgListener);
    if (splitMesgListeners.end() != it)
    splitMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SplitSummaryMesgListener& splitSummaryMesgListener)
{
   splitSummaryMesgListeners.push_back(&splitSummaryMesgListener);
}

void MesgBroadcaster::RemoveListener(SplitSummaryMesgListener& splitSummaryMesgListener)
{
    std::vector<SplitSummaryMesgListener *>::iterator it = std::find(splitSummaryMesgListeners.begin(), splitSummaryMesgListeners.end(), &splitSummaryMesgListener);
    if (splitSummaryMesgListeners.end() != it)
    splitSummaryMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ClimbProMesgListener& climbProMesgListener)
{
   climbProMesgListeners.push_back(&climbProMesgListener);
}

void MesgBroadcaster::RemoveListener(ClimbProMesgListener& climbProMesgListener)
{
    std::vector<ClimbProMesgListener *>::iterator it = std::find(climbProMesgListeners.begin(), climbProMesgListeners.end(), &climbProMesgListener);
    if (climbProMesgListeners.end() != it)
    climbProMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(FieldDescriptionMesgListener& fieldDescriptionMesgListener)
{
   fieldDescriptionMesgListeners.push_back(&fieldDescriptionMesgListener);
}

void MesgBroadcaster::RemoveListener(FieldDescriptionMesgListener& fieldDescriptionMesgListener)
{
    std::vector<FieldDescriptionMesgListener *>::iterator it = std::find(fieldDescriptionMesgListeners.begin(), fieldDescriptionMesgListeners.end(), &fieldDescriptionMesgListener);
    if (fieldDescriptionMesgListeners.end() != it)
    fieldDescriptionMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DeveloperDataIdMesgListener& developerDataIdMesgListener)
{
   developerDataIdMesgListeners.push_back(&developerDataIdMesgListener);
}

void MesgBroadcaster::RemoveListener(DeveloperDataIdMesgListener& developerDataIdMesgListener)
{
    std::vector<DeveloperDataIdMesgListener *>::iterator it = std::find(developerDataIdMesgListeners.begin(), developerDataIdMesgListeners.end(), &developerDataIdMesgListener);
    if (developerDataIdMesgListeners.end() != it)
    developerDataIdMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(CourseMesgListener& courseMesgListener)
{
   courseMesgListeners.push_back(&courseMesgListener);
}

void MesgBroadcaster::RemoveListener(CourseMesgListener& courseMesgListener)
{
    std::vector<CourseMesgListener *>::iterator it = std::find(courseMesgListeners.begin(), courseMesgListeners.end(), &courseMesgListener);
    if (courseMesgListeners.end() != it)
    courseMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(CoursePointMesgListener& coursePointMesgListener)
{
   coursePointMesgListeners.push_back(&coursePointMesgListener);
}

void MesgBroadcaster::RemoveListener(CoursePointMesgListener& coursePointMesgListener)
{
    std::vector<CoursePointMesgListener *>::iterator it = std::find(coursePointMesgListeners.begin(), coursePointMesgListeners.end(), &coursePointMesgListener);
    if (coursePointMesgListeners.end() != it)
    coursePointMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SegmentIdMesgListener& segmentIdMesgListener)
{
   segmentIdMesgListeners.push_back(&segmentIdMesgListener);
}

void MesgBroadcaster::RemoveListener(SegmentIdMesgListener& segmentIdMesgListener)
{
    std::vector<SegmentIdMesgListener *>::iterator it = std::find(segmentIdMesgListeners.begin(), segmentIdMesgListeners.end(), &segmentIdMesgListener);
    if (segmentIdMesgListeners.end() != it)
    segmentIdMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SegmentLeaderboardEntryMesgListener& segmentLeaderboardEntryMesgListener)
{
   segmentLeaderboardEntryMesgListeners.push_back(&segmentLeaderboardEntryMesgListener);
}

void MesgBroadcaster::RemoveListener(SegmentLeaderboardEntryMesgListener& segmentLeaderboardEntryMesgListener)
{
    std::vector<SegmentLeaderboardEntryMesgListener *>::iterator it = std::find(segmentLeaderboardEntryMesgListeners.begin(), segmentLeaderboardEntryMesgListeners.end(), &segmentLeaderboardEntryMesgListener);
    if (segmentLeaderboardEntryMesgListeners.end() != it)
    segmentLeaderboardEntryMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SegmentPointMesgListener& segmentPointMesgListener)
{
   segmentPointMesgListeners.push_back(&segmentPointMesgListener);
}

void MesgBroadcaster::RemoveListener(SegmentPointMesgListener& segmentPointMesgListener)
{
    std::vector<SegmentPointMesgListener *>::iterator it = std::find(segmentPointMesgListeners.begin(), segmentPointMesgListeners.end(), &segmentPointMesgListener);
    if (segmentPointMesgListeners.end() != it)
    segmentPointMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SegmentLapMesgListener& segmentLapMesgListener)
{
   segmentLapMesgListeners.push_back(&segmentLapMesgListener);
}

void MesgBroadcaster::RemoveListener(SegmentLapMesgListener& segmentLapMesgListener)
{
    std::vector<SegmentLapMesgListener *>::iterator it = std::find(segmentLapMesgListeners.begin(), segmentLapMesgListeners.end(), &segmentLapMesgListener);
    if (segmentLapMesgListeners.end() != it)
    segmentLapMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SegmentFileMesgListener& segmentFileMesgListener)
{
   segmentFileMesgListeners.push_back(&segmentFileMesgListener);
}

void MesgBroadcaster::RemoveListener(SegmentFileMesgListener& segmentFileMesgListener)
{
    std::vector<SegmentFileMesgListener *>::iterator it = std::find(segmentFileMesgListeners.begin(), segmentFileMesgListeners.end(), &segmentFileMesgListener);
    if (segmentFileMesgListeners.end() != it)
    segmentFileMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(WorkoutMesgListener& workoutMesgListener)
{
   workoutMesgListeners.push_back(&workoutMesgListener);
}

void MesgBroadcaster::RemoveListener(WorkoutMesgListener& workoutMesgListener)
{
    std::vector<WorkoutMesgListener *>::iterator it = std::find(workoutMesgListeners.begin(), workoutMesgListeners.end(), &workoutMesgListener);
    if (workoutMesgListeners.end() != it)
    workoutMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(WorkoutSessionMesgListener& workoutSessionMesgListener)
{
   workoutSessionMesgListeners.push_back(&workoutSessionMesgListener);
}

void MesgBroadcaster::RemoveListener(WorkoutSessionMesgListener& workoutSessionMesgListener)
{
    std::vector<WorkoutSessionMesgListener *>::iterator it = std::find(workoutSessionMesgListeners.begin(), workoutSessionMesgListeners.end(), &workoutSessionMesgListener);
    if (workoutSessionMesgListeners.end() != it)
    workoutSessionMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(WorkoutStepMesgListener& workoutStepMesgListener)
{
   workoutStepMesgListeners.push_back(&workoutStepMesgListener);
}

void MesgBroadcaster::RemoveListener(WorkoutStepMesgListener& workoutStepMesgListener)
{
    std::vector<WorkoutStepMesgListener *>::iterator it = std::find(workoutStepMesgListeners.begin(), workoutStepMesgListeners.end(), &workoutStepMesgListener);
    if (workoutStepMesgListeners.end() != it)
    workoutStepMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ExerciseTitleMesgListener& exerciseTitleMesgListener)
{
   exerciseTitleMesgListeners.push_back(&exerciseTitleMesgListener);
}

void MesgBroadcaster::RemoveListener(ExerciseTitleMesgListener& exerciseTitleMesgListener)
{
    std::vector<ExerciseTitleMesgListener *>::iterator it = std::find(exerciseTitleMesgListeners.begin(), exerciseTitleMesgListeners.end(), &exerciseTitleMesgListener);
    if (exerciseTitleMesgListeners.end() != it)
    exerciseTitleMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ScheduleMesgListener& scheduleMesgListener)
{
   scheduleMesgListeners.push_back(&scheduleMesgListener);
}

void MesgBroadcaster::RemoveListener(ScheduleMesgListener& scheduleMesgListener)
{
    std::vector<ScheduleMesgListener *>::iterator it = std::find(scheduleMesgListeners.begin(), scheduleMesgListeners.end(), &scheduleMesgListener);
    if (scheduleMesgListeners.end() != it)
    scheduleMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(TotalsMesgListener& totalsMesgListener)
{
   totalsMesgListeners.push_back(&totalsMesgListener);
}

void MesgBroadcaster::RemoveListener(TotalsMesgListener& totalsMesgListener)
{
    std::vector<TotalsMesgListener *>::iterator it = std::find(totalsMesgListeners.begin(), totalsMesgListeners.end(), &totalsMesgListener);
    if (totalsMesgListeners.end() != it)
    totalsMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(WeightScaleMesgListener& weightScaleMesgListener)
{
   weightScaleMesgListeners.push_back(&weightScaleMesgListener);
}

void MesgBroadcaster::RemoveListener(WeightScaleMesgListener& weightScaleMesgListener)
{
    std::vector<WeightScaleMesgListener *>::iterator it = std::find(weightScaleMesgListeners.begin(), weightScaleMesgListeners.end(), &weightScaleMesgListener);
    if (weightScaleMesgListeners.end() != it)
    weightScaleMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(BloodPressureMesgListener& bloodPressureMesgListener)
{
   bloodPressureMesgListeners.push_back(&bloodPressureMesgListener);
}

void MesgBroadcaster::RemoveListener(BloodPressureMesgListener& bloodPressureMesgListener)
{
    std::vector<BloodPressureMesgListener *>::iterator it = std::find(bloodPressureMesgListeners.begin(), bloodPressureMesgListeners.end(), &bloodPressureMesgListener);
    if (bloodPressureMesgListeners.end() != it)
    bloodPressureMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MonitoringInfoMesgListener& monitoringInfoMesgListener)
{
   monitoringInfoMesgListeners.push_back(&monitoringInfoMesgListener);
}

void MesgBroadcaster::RemoveListener(MonitoringInfoMesgListener& monitoringInfoMesgListener)
{
    std::vector<MonitoringInfoMesgListener *>::iterator it = std::find(monitoringInfoMesgListeners.begin(), monitoringInfoMesgListeners.end(), &monitoringInfoMesgListener);
    if (monitoringInfoMesgListeners.end() != it)
    monitoringInfoMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MonitoringMesgListener& monitoringMesgListener)
{
   monitoringMesgListeners.push_back(&monitoringMesgListener);
}

void MesgBroadcaster::RemoveListener(MonitoringMesgListener& monitoringMesgListener)
{
    std::vector<MonitoringMesgListener *>::iterator it = std::find(monitoringMesgListeners.begin(), monitoringMesgListeners.end(), &monitoringMesgListener);
    if (monitoringMesgListeners.end() != it)
    monitoringMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MonitoringHrDataMesgListener& monitoringHrDataMesgListener)
{
   monitoringHrDataMesgListeners.push_back(&monitoringHrDataMesgListener);
}

void MesgBroadcaster::RemoveListener(MonitoringHrDataMesgListener& monitoringHrDataMesgListener)
{
    std::vector<MonitoringHrDataMesgListener *>::iterator it = std::find(monitoringHrDataMesgListeners.begin(), monitoringHrDataMesgListeners.end(), &monitoringHrDataMesgListener);
    if (monitoringHrDataMesgListeners.end() != it)
    monitoringHrDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(Spo2DataMesgListener& spo2DataMesgListener)
{
   spo2DataMesgListeners.push_back(&spo2DataMesgListener);
}

void MesgBroadcaster::RemoveListener(Spo2DataMesgListener& spo2DataMesgListener)
{
    std::vector<Spo2DataMesgListener *>::iterator it = std::find(spo2DataMesgListeners.begin(), spo2DataMesgListeners.end(), &spo2DataMesgListener);
    if (spo2DataMesgListeners.end() != it)
    spo2DataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HrMesgListener& hrMesgListener)
{
   hrMesgListeners.push_back(&hrMesgListener);
}

void MesgBroadcaster::RemoveListener(HrMesgListener& hrMesgListener)
{
    std::vector<HrMesgListener *>::iterator it = std::find(hrMesgListeners.begin(), hrMesgListeners.end(), &hrMesgListener);
    if (hrMesgListeners.end() != it)
    hrMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(StressLevelMesgListener& stressLevelMesgListener)
{
   stressLevelMesgListeners.push_back(&stressLevelMesgListener);
}

void MesgBroadcaster::RemoveListener(StressLevelMesgListener& stressLevelMesgListener)
{
    std::vector<StressLevelMesgListener *>::iterator it = std::find(stressLevelMesgListeners.begin(), stressLevelMesgListeners.end(), &stressLevelMesgListener);
    if (stressLevelMesgListeners.end() != it)
    stressLevelMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MaxMetDataMesgListener& maxMetDataMesgListener)
{
   maxMetDataMesgListeners.push_back(&maxMetDataMesgListener);
}

void MesgBroadcaster::RemoveListener(MaxMetDataMesgListener& maxMetDataMesgListener)
{
    std::vector<MaxMetDataMesgListener *>::iterator it = std::find(maxMetDataMesgListeners.begin(), maxMetDataMesgListeners.end(), &maxMetDataMesgListener);
    if (maxMetDataMesgListeners.end() != it)
    maxMetDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaBodyBatteryDataMesgListener& hsaBodyBatteryDataMesgListener)
{
   hsaBodyBatteryDataMesgListeners.push_back(&hsaBodyBatteryDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaBodyBatteryDataMesgListener& hsaBodyBatteryDataMesgListener)
{
    std::vector<HsaBodyBatteryDataMesgListener *>::iterator it = std::find(hsaBodyBatteryDataMesgListeners.begin(), hsaBodyBatteryDataMesgListeners.end(), &hsaBodyBatteryDataMesgListener);
    if (hsaBodyBatteryDataMesgListeners.end() != it)
    hsaBodyBatteryDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaEventMesgListener& hsaEventMesgListener)
{
   hsaEventMesgListeners.push_back(&hsaEventMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaEventMesgListener& hsaEventMesgListener)
{
    std::vector<HsaEventMesgListener *>::iterator it = std::find(hsaEventMesgListeners.begin(), hsaEventMesgListeners.end(), &hsaEventMesgListener);
    if (hsaEventMesgListeners.end() != it)
    hsaEventMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaAccelerometerDataMesgListener& hsaAccelerometerDataMesgListener)
{
   hsaAccelerometerDataMesgListeners.push_back(&hsaAccelerometerDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaAccelerometerDataMesgListener& hsaAccelerometerDataMesgListener)
{
    std::vector<HsaAccelerometerDataMesgListener *>::iterator it = std::find(hsaAccelerometerDataMesgListeners.begin(), hsaAccelerometerDataMesgListeners.end(), &hsaAccelerometerDataMesgListener);
    if (hsaAccelerometerDataMesgListeners.end() != it)
    hsaAccelerometerDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaGyroscopeDataMesgListener& hsaGyroscopeDataMesgListener)
{
   hsaGyroscopeDataMesgListeners.push_back(&hsaGyroscopeDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaGyroscopeDataMesgListener& hsaGyroscopeDataMesgListener)
{
    std::vector<HsaGyroscopeDataMesgListener *>::iterator it = std::find(hsaGyroscopeDataMesgListeners.begin(), hsaGyroscopeDataMesgListeners.end(), &hsaGyroscopeDataMesgListener);
    if (hsaGyroscopeDataMesgListeners.end() != it)
    hsaGyroscopeDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaStepDataMesgListener& hsaStepDataMesgListener)
{
   hsaStepDataMesgListeners.push_back(&hsaStepDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaStepDataMesgListener& hsaStepDataMesgListener)
{
    std::vector<HsaStepDataMesgListener *>::iterator it = std::find(hsaStepDataMesgListeners.begin(), hsaStepDataMesgListeners.end(), &hsaStepDataMesgListener);
    if (hsaStepDataMesgListeners.end() != it)
    hsaStepDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaSpo2DataMesgListener& hsaSpo2DataMesgListener)
{
   hsaSpo2DataMesgListeners.push_back(&hsaSpo2DataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaSpo2DataMesgListener& hsaSpo2DataMesgListener)
{
    std::vector<HsaSpo2DataMesgListener *>::iterator it = std::find(hsaSpo2DataMesgListeners.begin(), hsaSpo2DataMesgListeners.end(), &hsaSpo2DataMesgListener);
    if (hsaSpo2DataMesgListeners.end() != it)
    hsaSpo2DataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaStressDataMesgListener& hsaStressDataMesgListener)
{
   hsaStressDataMesgListeners.push_back(&hsaStressDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaStressDataMesgListener& hsaStressDataMesgListener)
{
    std::vector<HsaStressDataMesgListener *>::iterator it = std::find(hsaStressDataMesgListeners.begin(), hsaStressDataMesgListeners.end(), &hsaStressDataMesgListener);
    if (hsaStressDataMesgListeners.end() != it)
    hsaStressDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaRespirationDataMesgListener& hsaRespirationDataMesgListener)
{
   hsaRespirationDataMesgListeners.push_back(&hsaRespirationDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaRespirationDataMesgListener& hsaRespirationDataMesgListener)
{
    std::vector<HsaRespirationDataMesgListener *>::iterator it = std::find(hsaRespirationDataMesgListeners.begin(), hsaRespirationDataMesgListeners.end(), &hsaRespirationDataMesgListener);
    if (hsaRespirationDataMesgListeners.end() != it)
    hsaRespirationDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaHeartRateDataMesgListener& hsaHeartRateDataMesgListener)
{
   hsaHeartRateDataMesgListeners.push_back(&hsaHeartRateDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaHeartRateDataMesgListener& hsaHeartRateDataMesgListener)
{
    std::vector<HsaHeartRateDataMesgListener *>::iterator it = std::find(hsaHeartRateDataMesgListeners.begin(), hsaHeartRateDataMesgListeners.end(), &hsaHeartRateDataMesgListener);
    if (hsaHeartRateDataMesgListeners.end() != it)
    hsaHeartRateDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaConfigurationDataMesgListener& hsaConfigurationDataMesgListener)
{
   hsaConfigurationDataMesgListeners.push_back(&hsaConfigurationDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaConfigurationDataMesgListener& hsaConfigurationDataMesgListener)
{
    std::vector<HsaConfigurationDataMesgListener *>::iterator it = std::find(hsaConfigurationDataMesgListeners.begin(), hsaConfigurationDataMesgListeners.end(), &hsaConfigurationDataMesgListener);
    if (hsaConfigurationDataMesgListeners.end() != it)
    hsaConfigurationDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HsaWristTemperatureDataMesgListener& hsaWristTemperatureDataMesgListener)
{
   hsaWristTemperatureDataMesgListeners.push_back(&hsaWristTemperatureDataMesgListener);
}

void MesgBroadcaster::RemoveListener(HsaWristTemperatureDataMesgListener& hsaWristTemperatureDataMesgListener)
{
    std::vector<HsaWristTemperatureDataMesgListener *>::iterator it = std::find(hsaWristTemperatureDataMesgListeners.begin(), hsaWristTemperatureDataMesgListeners.end(), &hsaWristTemperatureDataMesgListener);
    if (hsaWristTemperatureDataMesgListeners.end() != it)
    hsaWristTemperatureDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(MemoGlobMesgListener& memoGlobMesgListener)
{
   memoGlobMesgListeners.push_back(&memoGlobMesgListener);
}

void MesgBroadcaster::RemoveListener(MemoGlobMesgListener& memoGlobMesgListener)
{
    std::vector<MemoGlobMesgListener *>::iterator it = std::find(memoGlobMesgListeners.begin(), memoGlobMesgListeners.end(), &memoGlobMesgListener);
    if (memoGlobMesgListeners.end() != it)
    memoGlobMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SleepLevelMesgListener& sleepLevelMesgListener)
{
   sleepLevelMesgListeners.push_back(&sleepLevelMesgListener);
}

void MesgBroadcaster::RemoveListener(SleepLevelMesgListener& sleepLevelMesgListener)
{
    std::vector<SleepLevelMesgListener *>::iterator it = std::find(sleepLevelMesgListeners.begin(), sleepLevelMesgListeners.end(), &sleepLevelMesgListener);
    if (sleepLevelMesgListeners.end() != it)
    sleepLevelMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(AntChannelIdMesgListener& antChannelIdMesgListener)
{
   antChannelIdMesgListeners.push_back(&antChannelIdMesgListener);
}

void MesgBroadcaster::RemoveListener(AntChannelIdMesgListener& antChannelIdMesgListener)
{
    std::vector<AntChannelIdMesgListener *>::iterator it = std::find(antChannelIdMesgListeners.begin(), antChannelIdMesgListeners.end(), &antChannelIdMesgListener);
    if (antChannelIdMesgListeners.end() != it)
    antChannelIdMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(AntRxMesgListener& antRxMesgListener)
{
   antRxMesgListeners.push_back(&antRxMesgListener);
}

void MesgBroadcaster::RemoveListener(AntRxMesgListener& antRxMesgListener)
{
    std::vector<AntRxMesgListener *>::iterator it = std::find(antRxMesgListeners.begin(), antRxMesgListeners.end(), &antRxMesgListener);
    if (antRxMesgListeners.end() != it)
    antRxMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(AntTxMesgListener& antTxMesgListener)
{
   antTxMesgListeners.push_back(&antTxMesgListener);
}

void MesgBroadcaster::RemoveListener(AntTxMesgListener& antTxMesgListener)
{
    std::vector<AntTxMesgListener *>::iterator it = std::find(antTxMesgListeners.begin(), antTxMesgListeners.end(), &antTxMesgListener);
    if (antTxMesgListeners.end() != it)
    antTxMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ExdScreenConfigurationMesgListener& exdScreenConfigurationMesgListener)
{
   exdScreenConfigurationMesgListeners.push_back(&exdScreenConfigurationMesgListener);
}

void MesgBroadcaster::RemoveListener(ExdScreenConfigurationMesgListener& exdScreenConfigurationMesgListener)
{
    std::vector<ExdScreenConfigurationMesgListener *>::iterator it = std::find(exdScreenConfigurationMesgListeners.begin(), exdScreenConfigurationMesgListeners.end(), &exdScreenConfigurationMesgListener);
    if (exdScreenConfigurationMesgListeners.end() != it)
    exdScreenConfigurationMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ExdDataFieldConfigurationMesgListener& exdDataFieldConfigurationMesgListener)
{
   exdDataFieldConfigurationMesgListeners.push_back(&exdDataFieldConfigurationMesgListener);
}

void MesgBroadcaster::RemoveListener(ExdDataFieldConfigurationMesgListener& exdDataFieldConfigurationMesgListener)
{
    std::vector<ExdDataFieldConfigurationMesgListener *>::iterator it = std::find(exdDataFieldConfigurationMesgListeners.begin(), exdDataFieldConfigurationMesgListeners.end(), &exdDataFieldConfigurationMesgListener);
    if (exdDataFieldConfigurationMesgListeners.end() != it)
    exdDataFieldConfigurationMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ExdDataConceptConfigurationMesgListener& exdDataConceptConfigurationMesgListener)
{
   exdDataConceptConfigurationMesgListeners.push_back(&exdDataConceptConfigurationMesgListener);
}

void MesgBroadcaster::RemoveListener(ExdDataConceptConfigurationMesgListener& exdDataConceptConfigurationMesgListener)
{
    std::vector<ExdDataConceptConfigurationMesgListener *>::iterator it = std::find(exdDataConceptConfigurationMesgListeners.begin(), exdDataConceptConfigurationMesgListeners.end(), &exdDataConceptConfigurationMesgListener);
    if (exdDataConceptConfigurationMesgListeners.end() != it)
    exdDataConceptConfigurationMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(DiveSummaryMesgListener& diveSummaryMesgListener)
{
   diveSummaryMesgListeners.push_back(&diveSummaryMesgListener);
}

void MesgBroadcaster::RemoveListener(DiveSummaryMesgListener& diveSummaryMesgListener)
{
    std::vector<DiveSummaryMesgListener *>::iterator it = std::find(diveSummaryMesgListeners.begin(), diveSummaryMesgListeners.end(), &diveSummaryMesgListener);
    if (diveSummaryMesgListeners.end() != it)
    diveSummaryMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(AadAccelFeaturesMesgListener& aadAccelFeaturesMesgListener)
{
   aadAccelFeaturesMesgListeners.push_back(&aadAccelFeaturesMesgListener);
}

void MesgBroadcaster::RemoveListener(AadAccelFeaturesMesgListener& aadAccelFeaturesMesgListener)
{
    std::vector<AadAccelFeaturesMesgListener *>::iterator it = std::find(aadAccelFeaturesMesgListeners.begin(), aadAccelFeaturesMesgListeners.end(), &aadAccelFeaturesMesgListener);
    if (aadAccelFeaturesMesgListeners.end() != it)
    aadAccelFeaturesMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HrvMesgListener& hrvMesgListener)
{
   hrvMesgListeners.push_back(&hrvMesgListener);
}

void MesgBroadcaster::RemoveListener(HrvMesgListener& hrvMesgListener)
{
    std::vector<HrvMesgListener *>::iterator it = std::find(hrvMesgListeners.begin(), hrvMesgListeners.end(), &hrvMesgListener);
    if (hrvMesgListeners.end() != it)
    hrvMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(BeatIntervalsMesgListener& beatIntervalsMesgListener)
{
   beatIntervalsMesgListeners.push_back(&beatIntervalsMesgListener);
}

void MesgBroadcaster::RemoveListener(BeatIntervalsMesgListener& beatIntervalsMesgListener)
{
    std::vector<BeatIntervalsMesgListener *>::iterator it = std::find(beatIntervalsMesgListeners.begin(), beatIntervalsMesgListeners.end(), &beatIntervalsMesgListener);
    if (beatIntervalsMesgListeners.end() != it)
    beatIntervalsMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HrvStatusSummaryMesgListener& hrvStatusSummaryMesgListener)
{
   hrvStatusSummaryMesgListeners.push_back(&hrvStatusSummaryMesgListener);
}

void MesgBroadcaster::RemoveListener(HrvStatusSummaryMesgListener& hrvStatusSummaryMesgListener)
{
    std::vector<HrvStatusSummaryMesgListener *>::iterator it = std::find(hrvStatusSummaryMesgListeners.begin(), hrvStatusSummaryMesgListeners.end(), &hrvStatusSummaryMesgListener);
    if (hrvStatusSummaryMesgListeners.end() != it)
    hrvStatusSummaryMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(HrvValueMesgListener& hrvValueMesgListener)
{
   hrvValueMesgListeners.push_back(&hrvValueMesgListener);
}

void MesgBroadcaster::RemoveListener(HrvValueMesgListener& hrvValueMesgListener)
{
    std::vector<HrvValueMesgListener *>::iterator it = std::find(hrvValueMesgListeners.begin(), hrvValueMesgListeners.end(), &hrvValueMesgListener);
    if (hrvValueMesgListeners.end() != it)
    hrvValueMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(RawBbiMesgListener& rawBbiMesgListener)
{
   rawBbiMesgListeners.push_back(&rawBbiMesgListener);
}

void MesgBroadcaster::RemoveListener(RawBbiMesgListener& rawBbiMesgListener)
{
    std::vector<RawBbiMesgListener *>::iterator it = std::find(rawBbiMesgListeners.begin(), rawBbiMesgListeners.end(), &rawBbiMesgListener);
    if (rawBbiMesgListeners.end() != it)
    rawBbiMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(RespirationRateMesgListener& respirationRateMesgListener)
{
   respirationRateMesgListeners.push_back(&respirationRateMesgListener);
}

void MesgBroadcaster::RemoveListener(RespirationRateMesgListener& respirationRateMesgListener)
{
    std::vector<RespirationRateMesgListener *>::iterator it = std::find(respirationRateMesgListeners.begin(), respirationRateMesgListeners.end(), &respirationRateMesgListener);
    if (respirationRateMesgListeners.end() != it)
    respirationRateMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ChronoShotSessionMesgListener& chronoShotSessionMesgListener)
{
   chronoShotSessionMesgListeners.push_back(&chronoShotSessionMesgListener);
}

void MesgBroadcaster::RemoveListener(ChronoShotSessionMesgListener& chronoShotSessionMesgListener)
{
    std::vector<ChronoShotSessionMesgListener *>::iterator it = std::find(chronoShotSessionMesgListeners.begin(), chronoShotSessionMesgListeners.end(), &chronoShotSessionMesgListener);
    if (chronoShotSessionMesgListeners.end() != it)
    chronoShotSessionMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(ChronoShotDataMesgListener& chronoShotDataMesgListener)
{
   chronoShotDataMesgListeners.push_back(&chronoShotDataMesgListener);
}

void MesgBroadcaster::RemoveListener(ChronoShotDataMesgListener& chronoShotDataMesgListener)
{
    std::vector<ChronoShotDataMesgListener *>::iterator it = std::find(chronoShotDataMesgListeners.begin(), chronoShotDataMesgListeners.end(), &chronoShotDataMesgListener);
    if (chronoShotDataMesgListeners.end() != it)
    chronoShotDataMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(TankUpdateMesgListener& tankUpdateMesgListener)
{
   tankUpdateMesgListeners.push_back(&tankUpdateMesgListener);
}

void MesgBroadcaster::RemoveListener(TankUpdateMesgListener& tankUpdateMesgListener)
{
    std::vector<TankUpdateMesgListener *>::iterator it = std::find(tankUpdateMesgListeners.begin(), tankUpdateMesgListeners.end(), &tankUpdateMesgListener);
    if (tankUpdateMesgListeners.end() != it)
    tankUpdateMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(TankSummaryMesgListener& tankSummaryMesgListener)
{
   tankSummaryMesgListeners.push_back(&tankSummaryMesgListener);
}

void MesgBroadcaster::RemoveListener(TankSummaryMesgListener& tankSummaryMesgListener)
{
    std::vector<TankSummaryMesgListener *>::iterator it = std::find(tankSummaryMesgListeners.begin(), tankSummaryMesgListeners.end(), &tankSummaryMesgListener);
    if (tankSummaryMesgListeners.end() != it)
    tankSummaryMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SleepAssessmentMesgListener& sleepAssessmentMesgListener)
{
   sleepAssessmentMesgListeners.push_back(&sleepAssessmentMesgListener);
}

void MesgBroadcaster::RemoveListener(SleepAssessmentMesgListener& sleepAssessmentMesgListener)
{
    std::vector<SleepAssessmentMesgListener *>::iterator it = std::find(sleepAssessmentMesgListeners.begin(), sleepAssessmentMesgListeners.end(), &sleepAssessmentMesgListener);
    if (sleepAssessmentMesgListeners.end() != it)
    sleepAssessmentMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(SkinTempOvernightMesgListener& skinTempOvernightMesgListener)
{
   skinTempOvernightMesgListeners.push_back(&skinTempOvernightMesgListener);
}

void MesgBroadcaster::RemoveListener(SkinTempOvernightMesgListener& skinTempOvernightMesgListener)
{
    std::vector<SkinTempOvernightMesgListener *>::iterator it = std::find(skinTempOvernightMesgListeners.begin(), skinTempOvernightMesgListeners.end(), &skinTempOvernightMesgListener);
    if (skinTempOvernightMesgListeners.end() != it)
    skinTempOvernightMesgListeners.erase(it);
}


void MesgBroadcaster::AddListener(PadMesgListener& padMesgListener)
{
   padMesgListeners.push_back(&padMesgListener);
}

void MesgBroadcaster::RemoveListener(PadMesgListener& padMesgListener)
{
    std::vector<PadMesgListener *>::iterator it = std::find(padMesgListeners.begin(), padMesgListeners.end(), &padMesgListener);
    if (padMesgListeners.end() != it)
    padMesgListeners.erase(it);
}



void MesgBroadcaster::OnMesg(Mesg& mesg)
{
    for (int i=0; i < (int)mesgListeners.size(); i++)
        mesgListeners[i]->OnMesg(mesg);

    switch (mesg.GetNum())
    {
        case FIT_MESG_NUM_FILE_ID:
        {
            FileIdMesg fileIdMesg(mesg);
            for (int i=0; i < (int)fileIdMesgListeners.size(); i++)
            fileIdMesgListeners[i]->OnMesg(fileIdMesg);
            break;
        }
        case FIT_MESG_NUM_FILE_CREATOR:
        {
            FileCreatorMesg fileCreatorMesg(mesg);
            for (int i=0; i < (int)fileCreatorMesgListeners.size(); i++)
            fileCreatorMesgListeners[i]->OnMesg(fileCreatorMesg);
            break;
        }
        case FIT_MESG_NUM_TIMESTAMP_CORRELATION:
        {
            TimestampCorrelationMesg timestampCorrelationMesg(mesg);
            for (int i=0; i < (int)timestampCorrelationMesgListeners.size(); i++)
            timestampCorrelationMesgListeners[i]->OnMesg(timestampCorrelationMesg);
            break;
        }
        case FIT_MESG_NUM_SOFTWARE:
        {
            SoftwareMesg softwareMesg(mesg);
            for (int i=0; i < (int)softwareMesgListeners.size(); i++)
            softwareMesgListeners[i]->OnMesg(softwareMesg);
            break;
        }
        case FIT_MESG_NUM_SLAVE_DEVICE:
        {
            SlaveDeviceMesg slaveDeviceMesg(mesg);
            for (int i=0; i < (int)slaveDeviceMesgListeners.size(); i++)
            slaveDeviceMesgListeners[i]->OnMesg(slaveDeviceMesg);
            break;
        }
        case FIT_MESG_NUM_CAPABILITIES:
        {
            CapabilitiesMesg capabilitiesMesg(mesg);
            for (int i=0; i < (int)capabilitiesMesgListeners.size(); i++)
            capabilitiesMesgListeners[i]->OnMesg(capabilitiesMesg);
            break;
        }
        case FIT_MESG_NUM_FILE_CAPABILITIES:
        {
            FileCapabilitiesMesg fileCapabilitiesMesg(mesg);
            for (int i=0; i < (int)fileCapabilitiesMesgListeners.size(); i++)
            fileCapabilitiesMesgListeners[i]->OnMesg(fileCapabilitiesMesg);
            break;
        }
        case FIT_MESG_NUM_MESG_CAPABILITIES:
        {
            MesgCapabilitiesMesg mesgCapabilitiesMesg(mesg);
            for (int i=0; i < (int)mesgCapabilitiesMesgListeners.size(); i++)
            mesgCapabilitiesMesgListeners[i]->OnMesg(mesgCapabilitiesMesg);
            break;
        }
        case FIT_MESG_NUM_FIELD_CAPABILITIES:
        {
            FieldCapabilitiesMesg fieldCapabilitiesMesg(mesg);
            for (int i=0; i < (int)fieldCapabilitiesMesgListeners.size(); i++)
            fieldCapabilitiesMesgListeners[i]->OnMesg(fieldCapabilitiesMesg);
            break;
        }
        case FIT_MESG_NUM_DEVICE_SETTINGS:
        {
            DeviceSettingsMesg deviceSettingsMesg(mesg);
            for (int i=0; i < (int)deviceSettingsMesgListeners.size(); i++)
            deviceSettingsMesgListeners[i]->OnMesg(deviceSettingsMesg);
            break;
        }
        case FIT_MESG_NUM_USER_PROFILE:
        {
            UserProfileMesg userProfileMesg(mesg);
            for (int i=0; i < (int)userProfileMesgListeners.size(); i++)
            userProfileMesgListeners[i]->OnMesg(userProfileMesg);
            break;
        }
        case FIT_MESG_NUM_HRM_PROFILE:
        {
            HrmProfileMesg hrmProfileMesg(mesg);
            for (int i=0; i < (int)hrmProfileMesgListeners.size(); i++)
            hrmProfileMesgListeners[i]->OnMesg(hrmProfileMesg);
            break;
        }
        case FIT_MESG_NUM_SDM_PROFILE:
        {
            SdmProfileMesg sdmProfileMesg(mesg);
            for (int i=0; i < (int)sdmProfileMesgListeners.size(); i++)
            sdmProfileMesgListeners[i]->OnMesg(sdmProfileMesg);
            break;
        }
        case FIT_MESG_NUM_BIKE_PROFILE:
        {
            BikeProfileMesg bikeProfileMesg(mesg);
            for (int i=0; i < (int)bikeProfileMesgListeners.size(); i++)
            bikeProfileMesgListeners[i]->OnMesg(bikeProfileMesg);
            break;
        }
        case FIT_MESG_NUM_CONNECTIVITY:
        {
            ConnectivityMesg connectivityMesg(mesg);
            for (int i=0; i < (int)connectivityMesgListeners.size(); i++)
            connectivityMesgListeners[i]->OnMesg(connectivityMesg);
            break;
        }
        case FIT_MESG_NUM_WATCHFACE_SETTINGS:
        {
            WatchfaceSettingsMesg watchfaceSettingsMesg(mesg);
            for (int i=0; i < (int)watchfaceSettingsMesgListeners.size(); i++)
            watchfaceSettingsMesgListeners[i]->OnMesg(watchfaceSettingsMesg);
            break;
        }
        case FIT_MESG_NUM_OHR_SETTINGS:
        {
            OhrSettingsMesg ohrSettingsMesg(mesg);
            for (int i=0; i < (int)ohrSettingsMesgListeners.size(); i++)
            ohrSettingsMesgListeners[i]->OnMesg(ohrSettingsMesg);
            break;
        }
        case FIT_MESG_NUM_TIME_IN_ZONE:
        {
            TimeInZoneMesg timeInZoneMesg(mesg);
            for (int i=0; i < (int)timeInZoneMesgListeners.size(); i++)
            timeInZoneMesgListeners[i]->OnMesg(timeInZoneMesg);
            break;
        }
        case FIT_MESG_NUM_ZONES_TARGET:
        {
            ZonesTargetMesg zonesTargetMesg(mesg);
            for (int i=0; i < (int)zonesTargetMesgListeners.size(); i++)
            zonesTargetMesgListeners[i]->OnMesg(zonesTargetMesg);
            break;
        }
        case FIT_MESG_NUM_SPORT:
        {
            SportMesg sportMesg(mesg);
            for (int i=0; i < (int)sportMesgListeners.size(); i++)
            sportMesgListeners[i]->OnMesg(sportMesg);
            break;
        }
        case FIT_MESG_NUM_HR_ZONE:
        {
            HrZoneMesg hrZoneMesg(mesg);
            for (int i=0; i < (int)hrZoneMesgListeners.size(); i++)
            hrZoneMesgListeners[i]->OnMesg(hrZoneMesg);
            break;
        }
        case FIT_MESG_NUM_SPEED_ZONE:
        {
            SpeedZoneMesg speedZoneMesg(mesg);
            for (int i=0; i < (int)speedZoneMesgListeners.size(); i++)
            speedZoneMesgListeners[i]->OnMesg(speedZoneMesg);
            break;
        }
        case FIT_MESG_NUM_CADENCE_ZONE:
        {
            CadenceZoneMesg cadenceZoneMesg(mesg);
            for (int i=0; i < (int)cadenceZoneMesgListeners.size(); i++)
            cadenceZoneMesgListeners[i]->OnMesg(cadenceZoneMesg);
            break;
        }
        case FIT_MESG_NUM_POWER_ZONE:
        {
            PowerZoneMesg powerZoneMesg(mesg);
            for (int i=0; i < (int)powerZoneMesgListeners.size(); i++)
            powerZoneMesgListeners[i]->OnMesg(powerZoneMesg);
            break;
        }
        case FIT_MESG_NUM_MET_ZONE:
        {
            MetZoneMesg metZoneMesg(mesg);
            for (int i=0; i < (int)metZoneMesgListeners.size(); i++)
            metZoneMesgListeners[i]->OnMesg(metZoneMesg);
            break;
        }
        case FIT_MESG_NUM_DIVE_SETTINGS:
        {
            DiveSettingsMesg diveSettingsMesg(mesg);
            for (int i=0; i < (int)diveSettingsMesgListeners.size(); i++)
            diveSettingsMesgListeners[i]->OnMesg(diveSettingsMesg);
            break;
        }
        case FIT_MESG_NUM_DIVE_ALARM:
        {
            DiveAlarmMesg diveAlarmMesg(mesg);
            for (int i=0; i < (int)diveAlarmMesgListeners.size(); i++)
            diveAlarmMesgListeners[i]->OnMesg(diveAlarmMesg);
            break;
        }
        case FIT_MESG_NUM_DIVE_APNEA_ALARM:
        {
            DiveApneaAlarmMesg diveApneaAlarmMesg(mesg);
            for (int i=0; i < (int)diveApneaAlarmMesgListeners.size(); i++)
            diveApneaAlarmMesgListeners[i]->OnMesg(diveApneaAlarmMesg);
            break;
        }
        case FIT_MESG_NUM_DIVE_GAS:
        {
            DiveGasMesg diveGasMesg(mesg);
            for (int i=0; i < (int)diveGasMesgListeners.size(); i++)
            diveGasMesgListeners[i]->OnMesg(diveGasMesg);
            break;
        }
        case FIT_MESG_NUM_GOAL:
        {
            GoalMesg goalMesg(mesg);
            for (int i=0; i < (int)goalMesgListeners.size(); i++)
            goalMesgListeners[i]->OnMesg(goalMesg);
            break;
        }
        case FIT_MESG_NUM_ACTIVITY:
        {
            ActivityMesg activityMesg(mesg);
            for (int i=0; i < (int)activityMesgListeners.size(); i++)
            activityMesgListeners[i]->OnMesg(activityMesg);
            mesgWithEventBroadcaster.OnMesg(activityMesg);
            break;
        }
        case FIT_MESG_NUM_SESSION:
        {
            SessionMesg sessionMesg(mesg);
            for (int i=0; i < (int)sessionMesgListeners.size(); i++)
            sessionMesgListeners[i]->OnMesg(sessionMesg);
            mesgWithEventBroadcaster.OnMesg(sessionMesg);
            break;
        }
        case FIT_MESG_NUM_LAP:
        {
            LapMesg lapMesg(mesg);
            for (int i=0; i < (int)lapMesgListeners.size(); i++)
            lapMesgListeners[i]->OnMesg(lapMesg);
            mesgWithEventBroadcaster.OnMesg(lapMesg);
            break;
        }
        case FIT_MESG_NUM_LENGTH:
        {
            LengthMesg lengthMesg(mesg);
            for (int i=0; i < (int)lengthMesgListeners.size(); i++)
            lengthMesgListeners[i]->OnMesg(lengthMesg);
            mesgWithEventBroadcaster.OnMesg(lengthMesg);
            break;
        }
        case FIT_MESG_NUM_RECORD:
        {
            RecordMesg recordMesg(mesg);
            for (int i=0; i < (int)recordMesgListeners.size(); i++)
            recordMesgListeners[i]->OnMesg(recordMesg);
            bufferedRecordMesgBroadcaster.OnMesg(recordMesg);
            break;
        }
        case FIT_MESG_NUM_EVENT:
        {
            EventMesg eventMesg(mesg);
            for (int i=0; i < (int)eventMesgListeners.size(); i++)
            eventMesgListeners[i]->OnMesg(eventMesg);
            mesgWithEventBroadcaster.OnMesg(eventMesg);
            break;
        }
        case FIT_MESG_NUM_DEVICE_INFO:
        {
            DeviceInfoMesg deviceInfoMesg(mesg);
            for (int i=0; i < (int)deviceInfoMesgListeners.size(); i++)
            deviceInfoMesgListeners[i]->OnMesg(deviceInfoMesg);
            break;
        }
        case FIT_MESG_NUM_DEVICE_AUX_BATTERY_INFO:
        {
            DeviceAuxBatteryInfoMesg deviceAuxBatteryInfoMesg(mesg);
            for (int i=0; i < (int)deviceAuxBatteryInfoMesgListeners.size(); i++)
            deviceAuxBatteryInfoMesgListeners[i]->OnMesg(deviceAuxBatteryInfoMesg);
            break;
        }
        case FIT_MESG_NUM_TRAINING_FILE:
        {
            TrainingFileMesg trainingFileMesg(mesg);
            for (int i=0; i < (int)trainingFileMesgListeners.size(); i++)
            trainingFileMesgListeners[i]->OnMesg(trainingFileMesg);
            break;
        }
        case FIT_MESG_NUM_WEATHER_CONDITIONS:
        {
            WeatherConditionsMesg weatherConditionsMesg(mesg);
            for (int i=0; i < (int)weatherConditionsMesgListeners.size(); i++)
            weatherConditionsMesgListeners[i]->OnMesg(weatherConditionsMesg);
            break;
        }
        case FIT_MESG_NUM_WEATHER_ALERT:
        {
            WeatherAlertMesg weatherAlertMesg(mesg);
            for (int i=0; i < (int)weatherAlertMesgListeners.size(); i++)
            weatherAlertMesgListeners[i]->OnMesg(weatherAlertMesg);
            break;
        }
        case FIT_MESG_NUM_GPS_METADATA:
        {
            GpsMetadataMesg gpsMetadataMesg(mesg);
            for (int i=0; i < (int)gpsMetadataMesgListeners.size(); i++)
            gpsMetadataMesgListeners[i]->OnMesg(gpsMetadataMesg);
            break;
        }
        case FIT_MESG_NUM_CAMERA_EVENT:
        {
            CameraEventMesg cameraEventMesg(mesg);
            for (int i=0; i < (int)cameraEventMesgListeners.size(); i++)
            cameraEventMesgListeners[i]->OnMesg(cameraEventMesg);
            break;
        }
        case FIT_MESG_NUM_GYROSCOPE_DATA:
        {
            GyroscopeDataMesg gyroscopeDataMesg(mesg);
            for (int i=0; i < (int)gyroscopeDataMesgListeners.size(); i++)
            gyroscopeDataMesgListeners[i]->OnMesg(gyroscopeDataMesg);
            break;
        }
        case FIT_MESG_NUM_ACCELEROMETER_DATA:
        {
            AccelerometerDataMesg accelerometerDataMesg(mesg);
            for (int i=0; i < (int)accelerometerDataMesgListeners.size(); i++)
            accelerometerDataMesgListeners[i]->OnMesg(accelerometerDataMesg);
            break;
        }
        case FIT_MESG_NUM_MAGNETOMETER_DATA:
        {
            MagnetometerDataMesg magnetometerDataMesg(mesg);
            for (int i=0; i < (int)magnetometerDataMesgListeners.size(); i++)
            magnetometerDataMesgListeners[i]->OnMesg(magnetometerDataMesg);
            break;
        }
        case FIT_MESG_NUM_BAROMETER_DATA:
        {
            BarometerDataMesg barometerDataMesg(mesg);
            for (int i=0; i < (int)barometerDataMesgListeners.size(); i++)
            barometerDataMesgListeners[i]->OnMesg(barometerDataMesg);
            break;
        }
        case FIT_MESG_NUM_THREE_D_SENSOR_CALIBRATION:
        {
            ThreeDSensorCalibrationMesg threeDSensorCalibrationMesg(mesg);
            for (int i=0; i < (int)threeDSensorCalibrationMesgListeners.size(); i++)
            threeDSensorCalibrationMesgListeners[i]->OnMesg(threeDSensorCalibrationMesg);
            break;
        }
        case FIT_MESG_NUM_ONE_D_SENSOR_CALIBRATION:
        {
            OneDSensorCalibrationMesg oneDSensorCalibrationMesg(mesg);
            for (int i=0; i < (int)oneDSensorCalibrationMesgListeners.size(); i++)
            oneDSensorCalibrationMesgListeners[i]->OnMesg(oneDSensorCalibrationMesg);
            break;
        }
        case FIT_MESG_NUM_VIDEO_FRAME:
        {
            VideoFrameMesg videoFrameMesg(mesg);
            for (int i=0; i < (int)videoFrameMesgListeners.size(); i++)
            videoFrameMesgListeners[i]->OnMesg(videoFrameMesg);
            break;
        }
        case FIT_MESG_NUM_OBDII_DATA:
        {
            ObdiiDataMesg obdiiDataMesg(mesg);
            for (int i=0; i < (int)obdiiDataMesgListeners.size(); i++)
            obdiiDataMesgListeners[i]->OnMesg(obdiiDataMesg);
            break;
        }
        case FIT_MESG_NUM_NMEA_SENTENCE:
        {
            NmeaSentenceMesg nmeaSentenceMesg(mesg);
            for (int i=0; i < (int)nmeaSentenceMesgListeners.size(); i++)
            nmeaSentenceMesgListeners[i]->OnMesg(nmeaSentenceMesg);
            break;
        }
        case FIT_MESG_NUM_AVIATION_ATTITUDE:
        {
            AviationAttitudeMesg aviationAttitudeMesg(mesg);
            for (int i=0; i < (int)aviationAttitudeMesgListeners.size(); i++)
            aviationAttitudeMesgListeners[i]->OnMesg(aviationAttitudeMesg);
            break;
        }
        case FIT_MESG_NUM_VIDEO:
        {
            VideoMesg videoMesg(mesg);
            for (int i=0; i < (int)videoMesgListeners.size(); i++)
            videoMesgListeners[i]->OnMesg(videoMesg);
            break;
        }
        case FIT_MESG_NUM_VIDEO_TITLE:
        {
            VideoTitleMesg videoTitleMesg(mesg);
            for (int i=0; i < (int)videoTitleMesgListeners.size(); i++)
            videoTitleMesgListeners[i]->OnMesg(videoTitleMesg);
            break;
        }
        case FIT_MESG_NUM_VIDEO_DESCRIPTION:
        {
            VideoDescriptionMesg videoDescriptionMesg(mesg);
            for (int i=0; i < (int)videoDescriptionMesgListeners.size(); i++)
            videoDescriptionMesgListeners[i]->OnMesg(videoDescriptionMesg);
            break;
        }
        case FIT_MESG_NUM_VIDEO_CLIP:
        {
            VideoClipMesg videoClipMesg(mesg);
            for (int i=0; i < (int)videoClipMesgListeners.size(); i++)
            videoClipMesgListeners[i]->OnMesg(videoClipMesg);
            break;
        }
        case FIT_MESG_NUM_SET:
        {
            SetMesg setMesg(mesg);
            for (int i=0; i < (int)setMesgListeners.size(); i++)
            setMesgListeners[i]->OnMesg(setMesg);
            break;
        }
        case FIT_MESG_NUM_JUMP:
        {
            JumpMesg jumpMesg(mesg);
            for (int i=0; i < (int)jumpMesgListeners.size(); i++)
            jumpMesgListeners[i]->OnMesg(jumpMesg);
            break;
        }
        case FIT_MESG_NUM_SPLIT:
        {
            SplitMesg splitMesg(mesg);
            for (int i=0; i < (int)splitMesgListeners.size(); i++)
            splitMesgListeners[i]->OnMesg(splitMesg);
            break;
        }
        case FIT_MESG_NUM_SPLIT_SUMMARY:
        {
            SplitSummaryMesg splitSummaryMesg(mesg);
            for (int i=0; i < (int)splitSummaryMesgListeners.size(); i++)
            splitSummaryMesgListeners[i]->OnMesg(splitSummaryMesg);
            break;
        }
        case FIT_MESG_NUM_CLIMB_PRO:
        {
            ClimbProMesg climbProMesg(mesg);
            for (int i=0; i < (int)climbProMesgListeners.size(); i++)
            climbProMesgListeners[i]->OnMesg(climbProMesg);
            break;
        }
        case FIT_MESG_NUM_FIELD_DESCRIPTION:
        {
            FieldDescriptionMesg fieldDescriptionMesg(mesg);
            for (int i=0; i < (int)fieldDescriptionMesgListeners.size(); i++)
            fieldDescriptionMesgListeners[i]->OnMesg(fieldDescriptionMesg);
            break;
        }
        case FIT_MESG_NUM_DEVELOPER_DATA_ID:
        {
            DeveloperDataIdMesg developerDataIdMesg(mesg);
            for (int i=0; i < (int)developerDataIdMesgListeners.size(); i++)
            developerDataIdMesgListeners[i]->OnMesg(developerDataIdMesg);
            break;
        }
        case FIT_MESG_NUM_COURSE:
        {
            CourseMesg courseMesg(mesg);
            for (int i=0; i < (int)courseMesgListeners.size(); i++)
            courseMesgListeners[i]->OnMesg(courseMesg);
            break;
        }
        case FIT_MESG_NUM_COURSE_POINT:
        {
            CoursePointMesg coursePointMesg(mesg);
            for (int i=0; i < (int)coursePointMesgListeners.size(); i++)
            coursePointMesgListeners[i]->OnMesg(coursePointMesg);
            break;
        }
        case FIT_MESG_NUM_SEGMENT_ID:
        {
            SegmentIdMesg segmentIdMesg(mesg);
            for (int i=0; i < (int)segmentIdMesgListeners.size(); i++)
            segmentIdMesgListeners[i]->OnMesg(segmentIdMesg);
            break;
        }
        case FIT_MESG_NUM_SEGMENT_LEADERBOARD_ENTRY:
        {
            SegmentLeaderboardEntryMesg segmentLeaderboardEntryMesg(mesg);
            for (int i=0; i < (int)segmentLeaderboardEntryMesgListeners.size(); i++)
            segmentLeaderboardEntryMesgListeners[i]->OnMesg(segmentLeaderboardEntryMesg);
            break;
        }
        case FIT_MESG_NUM_SEGMENT_POINT:
        {
            SegmentPointMesg segmentPointMesg(mesg);
            for (int i=0; i < (int)segmentPointMesgListeners.size(); i++)
            segmentPointMesgListeners[i]->OnMesg(segmentPointMesg);
            break;
        }
        case FIT_MESG_NUM_SEGMENT_LAP:
        {
            SegmentLapMesg segmentLapMesg(mesg);
            for (int i=0; i < (int)segmentLapMesgListeners.size(); i++)
            segmentLapMesgListeners[i]->OnMesg(segmentLapMesg);
            mesgWithEventBroadcaster.OnMesg(segmentLapMesg);
            break;
        }
        case FIT_MESG_NUM_SEGMENT_FILE:
        {
            SegmentFileMesg segmentFileMesg(mesg);
            for (int i=0; i < (int)segmentFileMesgListeners.size(); i++)
            segmentFileMesgListeners[i]->OnMesg(segmentFileMesg);
            break;
        }
        case FIT_MESG_NUM_WORKOUT:
        {
            WorkoutMesg workoutMesg(mesg);
            for (int i=0; i < (int)workoutMesgListeners.size(); i++)
            workoutMesgListeners[i]->OnMesg(workoutMesg);
            break;
        }
        case FIT_MESG_NUM_WORKOUT_SESSION:
        {
            WorkoutSessionMesg workoutSessionMesg(mesg);
            for (int i=0; i < (int)workoutSessionMesgListeners.size(); i++)
            workoutSessionMesgListeners[i]->OnMesg(workoutSessionMesg);
            break;
        }
        case FIT_MESG_NUM_WORKOUT_STEP:
        {
            WorkoutStepMesg workoutStepMesg(mesg);
            for (int i=0; i < (int)workoutStepMesgListeners.size(); i++)
            workoutStepMesgListeners[i]->OnMesg(workoutStepMesg);
            break;
        }
        case FIT_MESG_NUM_EXERCISE_TITLE:
        {
            ExerciseTitleMesg exerciseTitleMesg(mesg);
            for (int i=0; i < (int)exerciseTitleMesgListeners.size(); i++)
            exerciseTitleMesgListeners[i]->OnMesg(exerciseTitleMesg);
            break;
        }
        case FIT_MESG_NUM_SCHEDULE:
        {
            ScheduleMesg scheduleMesg(mesg);
            for (int i=0; i < (int)scheduleMesgListeners.size(); i++)
            scheduleMesgListeners[i]->OnMesg(scheduleMesg);
            break;
        }
        case FIT_MESG_NUM_TOTALS:
        {
            TotalsMesg totalsMesg(mesg);
            for (int i=0; i < (int)totalsMesgListeners.size(); i++)
            totalsMesgListeners[i]->OnMesg(totalsMesg);
            break;
        }
        case FIT_MESG_NUM_WEIGHT_SCALE:
        {
            WeightScaleMesg weightScaleMesg(mesg);
            for (int i=0; i < (int)weightScaleMesgListeners.size(); i++)
            weightScaleMesgListeners[i]->OnMesg(weightScaleMesg);
            break;
        }
        case FIT_MESG_NUM_BLOOD_PRESSURE:
        {
            BloodPressureMesg bloodPressureMesg(mesg);
            for (int i=0; i < (int)bloodPressureMesgListeners.size(); i++)
            bloodPressureMesgListeners[i]->OnMesg(bloodPressureMesg);
            break;
        }
        case FIT_MESG_NUM_MONITORING_INFO:
        {
            MonitoringInfoMesg monitoringInfoMesg(mesg);
            for (int i=0; i < (int)monitoringInfoMesgListeners.size(); i++)
            monitoringInfoMesgListeners[i]->OnMesg(monitoringInfoMesg);
            break;
        }
        case FIT_MESG_NUM_MONITORING:
        {
            MonitoringMesg monitoringMesg(mesg);
            for (int i=0; i < (int)monitoringMesgListeners.size(); i++)
            monitoringMesgListeners[i]->OnMesg(monitoringMesg);
            break;
        }
        case FIT_MESG_NUM_MONITORING_HR_DATA:
        {
            MonitoringHrDataMesg monitoringHrDataMesg(mesg);
            for (int i=0; i < (int)monitoringHrDataMesgListeners.size(); i++)
            monitoringHrDataMesgListeners[i]->OnMesg(monitoringHrDataMesg);
            break;
        }
        case FIT_MESG_NUM_SPO2_DATA:
        {
            Spo2DataMesg spo2DataMesg(mesg);
            for (int i=0; i < (int)spo2DataMesgListeners.size(); i++)
            spo2DataMesgListeners[i]->OnMesg(spo2DataMesg);
            break;
        }
        case FIT_MESG_NUM_HR:
        {
            HrMesg hrMesg(mesg);
            for (int i=0; i < (int)hrMesgListeners.size(); i++)
            hrMesgListeners[i]->OnMesg(hrMesg);
            break;
        }
        case FIT_MESG_NUM_STRESS_LEVEL:
        {
            StressLevelMesg stressLevelMesg(mesg);
            for (int i=0; i < (int)stressLevelMesgListeners.size(); i++)
            stressLevelMesgListeners[i]->OnMesg(stressLevelMesg);
            break;
        }
        case FIT_MESG_NUM_MAX_MET_DATA:
        {
            MaxMetDataMesg maxMetDataMesg(mesg);
            for (int i=0; i < (int)maxMetDataMesgListeners.size(); i++)
            maxMetDataMesgListeners[i]->OnMesg(maxMetDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_BODY_BATTERY_DATA:
        {
            HsaBodyBatteryDataMesg hsaBodyBatteryDataMesg(mesg);
            for (int i=0; i < (int)hsaBodyBatteryDataMesgListeners.size(); i++)
            hsaBodyBatteryDataMesgListeners[i]->OnMesg(hsaBodyBatteryDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_EVENT:
        {
            HsaEventMesg hsaEventMesg(mesg);
            for (int i=0; i < (int)hsaEventMesgListeners.size(); i++)
            hsaEventMesgListeners[i]->OnMesg(hsaEventMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_ACCELEROMETER_DATA:
        {
            HsaAccelerometerDataMesg hsaAccelerometerDataMesg(mesg);
            for (int i=0; i < (int)hsaAccelerometerDataMesgListeners.size(); i++)
            hsaAccelerometerDataMesgListeners[i]->OnMesg(hsaAccelerometerDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_GYROSCOPE_DATA:
        {
            HsaGyroscopeDataMesg hsaGyroscopeDataMesg(mesg);
            for (int i=0; i < (int)hsaGyroscopeDataMesgListeners.size(); i++)
            hsaGyroscopeDataMesgListeners[i]->OnMesg(hsaGyroscopeDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_STEP_DATA:
        {
            HsaStepDataMesg hsaStepDataMesg(mesg);
            for (int i=0; i < (int)hsaStepDataMesgListeners.size(); i++)
            hsaStepDataMesgListeners[i]->OnMesg(hsaStepDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_SPO2_DATA:
        {
            HsaSpo2DataMesg hsaSpo2DataMesg(mesg);
            for (int i=0; i < (int)hsaSpo2DataMesgListeners.size(); i++)
            hsaSpo2DataMesgListeners[i]->OnMesg(hsaSpo2DataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_STRESS_DATA:
        {
            HsaStressDataMesg hsaStressDataMesg(mesg);
            for (int i=0; i < (int)hsaStressDataMesgListeners.size(); i++)
            hsaStressDataMesgListeners[i]->OnMesg(hsaStressDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_RESPIRATION_DATA:
        {
            HsaRespirationDataMesg hsaRespirationDataMesg(mesg);
            for (int i=0; i < (int)hsaRespirationDataMesgListeners.size(); i++)
            hsaRespirationDataMesgListeners[i]->OnMesg(hsaRespirationDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_HEART_RATE_DATA:
        {
            HsaHeartRateDataMesg hsaHeartRateDataMesg(mesg);
            for (int i=0; i < (int)hsaHeartRateDataMesgListeners.size(); i++)
            hsaHeartRateDataMesgListeners[i]->OnMesg(hsaHeartRateDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_CONFIGURATION_DATA:
        {
            HsaConfigurationDataMesg hsaConfigurationDataMesg(mesg);
            for (int i=0; i < (int)hsaConfigurationDataMesgListeners.size(); i++)
            hsaConfigurationDataMesgListeners[i]->OnMesg(hsaConfigurationDataMesg);
            break;
        }
        case FIT_MESG_NUM_HSA_WRIST_TEMPERATURE_DATA:
        {
            HsaWristTemperatureDataMesg hsaWristTemperatureDataMesg(mesg);
            for (int i=0; i < (int)hsaWristTemperatureDataMesgListeners.size(); i++)
            hsaWristTemperatureDataMesgListeners[i]->OnMesg(hsaWristTemperatureDataMesg);
            break;
        }
        case FIT_MESG_NUM_MEMO_GLOB:
        {
            MemoGlobMesg memoGlobMesg(mesg);
            for (int i=0; i < (int)memoGlobMesgListeners.size(); i++)
            memoGlobMesgListeners[i]->OnMesg(memoGlobMesg);
            break;
        }
        case FIT_MESG_NUM_SLEEP_LEVEL:
        {
            SleepLevelMesg sleepLevelMesg(mesg);
            for (int i=0; i < (int)sleepLevelMesgListeners.size(); i++)
            sleepLevelMesgListeners[i]->OnMesg(sleepLevelMesg);
            break;
        }
        case FIT_MESG_NUM_ANT_CHANNEL_ID:
        {
            AntChannelIdMesg antChannelIdMesg(mesg);
            for (int i=0; i < (int)antChannelIdMesgListeners.size(); i++)
            antChannelIdMesgListeners[i]->OnMesg(antChannelIdMesg);
            break;
        }
        case FIT_MESG_NUM_ANT_RX:
        {
            AntRxMesg antRxMesg(mesg);
            for (int i=0; i < (int)antRxMesgListeners.size(); i++)
            antRxMesgListeners[i]->OnMesg(antRxMesg);
            break;
        }
        case FIT_MESG_NUM_ANT_TX:
        {
            AntTxMesg antTxMesg(mesg);
            for (int i=0; i < (int)antTxMesgListeners.size(); i++)
            antTxMesgListeners[i]->OnMesg(antTxMesg);
            break;
        }
        case FIT_MESG_NUM_EXD_SCREEN_CONFIGURATION:
        {
            ExdScreenConfigurationMesg exdScreenConfigurationMesg(mesg);
            for (int i=0; i < (int)exdScreenConfigurationMesgListeners.size(); i++)
            exdScreenConfigurationMesgListeners[i]->OnMesg(exdScreenConfigurationMesg);
            break;
        }
        case FIT_MESG_NUM_EXD_DATA_FIELD_CONFIGURATION:
        {
            ExdDataFieldConfigurationMesg exdDataFieldConfigurationMesg(mesg);
            for (int i=0; i < (int)exdDataFieldConfigurationMesgListeners.size(); i++)
            exdDataFieldConfigurationMesgListeners[i]->OnMesg(exdDataFieldConfigurationMesg);
            break;
        }
        case FIT_MESG_NUM_EXD_DATA_CONCEPT_CONFIGURATION:
        {
            ExdDataConceptConfigurationMesg exdDataConceptConfigurationMesg(mesg);
            for (int i=0; i < (int)exdDataConceptConfigurationMesgListeners.size(); i++)
            exdDataConceptConfigurationMesgListeners[i]->OnMesg(exdDataConceptConfigurationMesg);
            break;
        }
        case FIT_MESG_NUM_DIVE_SUMMARY:
        {
            DiveSummaryMesg diveSummaryMesg(mesg);
            for (int i=0; i < (int)diveSummaryMesgListeners.size(); i++)
            diveSummaryMesgListeners[i]->OnMesg(diveSummaryMesg);
            break;
        }
        case FIT_MESG_NUM_AAD_ACCEL_FEATURES:
        {
            AadAccelFeaturesMesg aadAccelFeaturesMesg(mesg);
            for (int i=0; i < (int)aadAccelFeaturesMesgListeners.size(); i++)
            aadAccelFeaturesMesgListeners[i]->OnMesg(aadAccelFeaturesMesg);
            break;
        }
        case FIT_MESG_NUM_HRV:
        {
            HrvMesg hrvMesg(mesg);
            for (int i=0; i < (int)hrvMesgListeners.size(); i++)
            hrvMesgListeners[i]->OnMesg(hrvMesg);
            break;
        }
        case FIT_MESG_NUM_BEAT_INTERVALS:
        {
            BeatIntervalsMesg beatIntervalsMesg(mesg);
            for (int i=0; i < (int)beatIntervalsMesgListeners.size(); i++)
            beatIntervalsMesgListeners[i]->OnMesg(beatIntervalsMesg);
            break;
        }
        case FIT_MESG_NUM_HRV_STATUS_SUMMARY:
        {
            HrvStatusSummaryMesg hrvStatusSummaryMesg(mesg);
            for (int i=0; i < (int)hrvStatusSummaryMesgListeners.size(); i++)
            hrvStatusSummaryMesgListeners[i]->OnMesg(hrvStatusSummaryMesg);
            break;
        }
        case FIT_MESG_NUM_HRV_VALUE:
        {
            HrvValueMesg hrvValueMesg(mesg);
            for (int i=0; i < (int)hrvValueMesgListeners.size(); i++)
            hrvValueMesgListeners[i]->OnMesg(hrvValueMesg);
            break;
        }
        case FIT_MESG_NUM_RAW_BBI:
        {
            RawBbiMesg rawBbiMesg(mesg);
            for (int i=0; i < (int)rawBbiMesgListeners.size(); i++)
            rawBbiMesgListeners[i]->OnMesg(rawBbiMesg);
            break;
        }
        case FIT_MESG_NUM_RESPIRATION_RATE:
        {
            RespirationRateMesg respirationRateMesg(mesg);
            for (int i=0; i < (int)respirationRateMesgListeners.size(); i++)
            respirationRateMesgListeners[i]->OnMesg(respirationRateMesg);
            break;
        }
        case FIT_MESG_NUM_CHRONO_SHOT_SESSION:
        {
            ChronoShotSessionMesg chronoShotSessionMesg(mesg);
            for (int i=0; i < (int)chronoShotSessionMesgListeners.size(); i++)
            chronoShotSessionMesgListeners[i]->OnMesg(chronoShotSessionMesg);
            break;
        }
        case FIT_MESG_NUM_CHRONO_SHOT_DATA:
        {
            ChronoShotDataMesg chronoShotDataMesg(mesg);
            for (int i=0; i < (int)chronoShotDataMesgListeners.size(); i++)
            chronoShotDataMesgListeners[i]->OnMesg(chronoShotDataMesg);
            break;
        }
        case FIT_MESG_NUM_TANK_UPDATE:
        {
            TankUpdateMesg tankUpdateMesg(mesg);
            for (int i=0; i < (int)tankUpdateMesgListeners.size(); i++)
            tankUpdateMesgListeners[i]->OnMesg(tankUpdateMesg);
            break;
        }
        case FIT_MESG_NUM_TANK_SUMMARY:
        {
            TankSummaryMesg tankSummaryMesg(mesg);
            for (int i=0; i < (int)tankSummaryMesgListeners.size(); i++)
            tankSummaryMesgListeners[i]->OnMesg(tankSummaryMesg);
            break;
        }
        case FIT_MESG_NUM_SLEEP_ASSESSMENT:
        {
            SleepAssessmentMesg sleepAssessmentMesg(mesg);
            for (int i=0; i < (int)sleepAssessmentMesgListeners.size(); i++)
            sleepAssessmentMesgListeners[i]->OnMesg(sleepAssessmentMesg);
            break;
        }
        case FIT_MESG_NUM_SKIN_TEMP_OVERNIGHT:
        {
            SkinTempOvernightMesg skinTempOvernightMesg(mesg);
            for (int i=0; i < (int)skinTempOvernightMesgListeners.size(); i++)
            skinTempOvernightMesgListeners[i]->OnMesg(skinTempOvernightMesg);
            break;
        }
        case FIT_MESG_NUM_PAD:
        {
            PadMesg padMesg(mesg);
            for (int i=0; i < (int)padMesgListeners.size(); i++)
            padMesgListeners[i]->OnMesg(padMesg);
            break;
        }

        default:
            break;
    }
}

void MesgBroadcaster::OnMesgDefinition(MesgDefinition& mesgDef)
{
    for (int i=0; i < (int)mesgDefinitionListeners.size(); i++)
        mesgDefinitionListeners[i]->OnMesgDefinition(mesgDef);
}

} // namespace fit

