/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

#include <rtl/ustring.hxx>

inline constexpr OUString WINDOWSTATE_PROPERTY_LOCKED = u"Locked"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_DOCKED = u"Docked"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_VISIBLE = u"Visible"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_DOCKINGAREA = u"DockingArea"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_DOCKPOS = u"DockPos"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_DOCKSIZE = u"DockSize"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_POS = u"Pos"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_SIZE = u"Size"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_UINAME = u"UIName"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_INTERNALSTATE = u"InternalState"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_STYLE = u"Style"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_CONTEXT = u"ContextSensitive"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_HIDEFROMENU = u"HideFromToolbarMenu"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_NOCLOSE = u"NoClose"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_SOFTCLOSE = u"SoftClose"_ustr;
inline constexpr OUString WINDOWSTATE_PROPERTY_CONTEXTACTIVE = u"ContextActive"_ustr;

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
