/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Sides;
import sun.awt.CharToByteSymbol;
import sun.awt.CharsetString;
import sun.awt.FontConfiguration;
import sun.awt.OSInfo;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.font.FontManager;
import sun.io.CharToByteConverter;
import sun.print.DialogTypeSelection;
import sun.print.PSPathGraphics;
import sun.print.PSStreamPrintService;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.security.action.GetPropertyAction;

public class PSPrinterJob
extends RasterPrinterJob {
    protected static final int FILL_EVEN_ODD = 1;
    protected static final int FILL_WINDING = 2;
    private static final int MAX_PSSTR = 65535;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int LOWNIBBLE_MASK = 15;
    private static final int HINIBBLE_MASK = 240;
    private static final int HINIBBLE_SHIFT = 4;
    private static final byte[] hexDigits;
    private static final int PS_XRES = 300;
    private static final int PS_YRES = 300;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    private static final String ADOBE_PS_STR = "%!PS-Adobe-3.0";
    private static final String EOF_COMMENT = "%%EOF";
    private static final String PAGE_COMMENT = "%%Page: ";
    private static final String READIMAGEPROC = "/imStr 0 def /imageSrc {currentfile /ASCII85Decode filter /RunLengthDecode filter  imStr readstring pop } def";
    private static final String COPIES = "/#copies exch def";
    private static final String PAGE_SAVE = "/pgSave save def";
    private static final String PAGE_RESTORE = "pgSave restore";
    private static final String SHOWPAGE = "showpage";
    private static final String IMAGE_SAVE = "/imSave save def";
    private static final String IMAGE_STR = " string /imStr exch def";
    private static final String IMAGE_RESTORE = "imSave restore";
    private static final String COORD_PREP = " 0 exch translate 1 -1 scale[72 300 div 0 0 72 300 div 0 0]concat";
    private static final String SetFontName = "SF";
    private static final String DrawStringName = "DS";
    private static final String EVEN_ODD_FILL_STR = "eofill";
    private static final String WINDING_FILL_STR = "fill";
    private static final String EVEN_ODD_CLIP_STR = "eoclip";
    private static final String WINDING_CLIP_STR = "clip";
    private static final String MOVETO_STR = " moveto";
    private static final String LINETO_STR = " lineto";
    private static final String CURVETO_STR = " curveto";
    private static final String GRESTORE_STR = "grestore";
    private static final String GSAVE_STR = "gsave";
    private static final String NEWPATH_STR = "newpath";
    private static final String CLOSEPATH_STR = "closepath";
    private static final String SETRGBCOLOR_STR = " setrgbcolor";
    private static final String SETGRAY_STR = " setgray";
    private static final String testString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890";
    private static boolean forcePDL;
    private static boolean forceRaster;
    static boolean shapeTextProp;
    private int mDestType;
    private String mDestination = "lp";
    private boolean mNoJobSheet = false;
    private String mOptions;
    private Font mLastFont;
    private Color mLastColor;
    private Shape mLastClip;
    private AffineTransform mLastTransform;
    private EPSPrinter epsPrinter = null;
    FontMetrics mCurMetrics;
    PrintStream mPSStream;
    File spoolFile;
    private String mFillOpStr = "fill";
    private String mClipOpStr = "clip";
    ArrayList mGStateStack = new ArrayList();
    private float mPenX;
    private float mPenY;
    private float mStartPathX;
    private float mStartPathY;
    private static Properties mFontProps;

    private static Properties initProps() {
        String string = System.getProperty("java.home");
        if (string != null) {
            String string2 = SunToolkit.getStartupLocale().getLanguage();
            try {
                File file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties." + string2);
                if (!(file.canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties." + string2)).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties")).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties")).canRead())) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.attributes.add(new Copies(this.getCopies()));
        this.attributes.add(new JobName(this.getJobName(), null));
        boolean bl = false;
        DialogTypeSelection dialogTypeSelection = (DialogTypeSelection)this.attributes.get(DialogTypeSelection.class);
        if (dialogTypeSelection == DialogTypeSelection.NATIVE) {
            this.attributes.remove(DialogTypeSelection.class);
            bl = this.printDialog(this.attributes);
            this.attributes.add((Attribute)DialogTypeSelection.NATIVE);
        } else {
            bl = this.printDialog(this.attributes);
        }
        if (bl) {
            Destination destination;
            Copies copies;
            JobName jobName = (JobName)this.attributes.get(JobName.class);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)this.attributes.get(Copies.class)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((destination = (Destination)this.attributes.get(Destination.class)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(destination.getURI()).getPath();
                }
                catch (Exception exception) {
                    this.mDestination = "out.ps";
                }
            } else {
                this.mDestType = 0;
                PrintService printService = this.getPrintService();
                if (printService != null) {
                    this.mDestination = printService.getName();
                }
            }
        }
        return bl;
    }

    protected void startDoc() throws PrinterException {
        if (this.epsPrinter == null) {
            OutputStream outputStream;
            Object object;
            if (this.getPrintService() instanceof PSStreamPrintService) {
                object = (StreamPrintService)this.getPrintService();
                this.mDestType = 2;
                if (((StreamPrintService)object).isDisposed()) {
                    throw new PrinterException("service is disposed");
                }
                outputStream = ((StreamPrintService)object).getOutputStream();
                if (outputStream == null) {
                    throw new PrinterException("Null output stream");
                }
            } else {
                this.mNoJobSheet = this.noJobSheet;
                if (this.destinationAttr != null) {
                    this.mDestType = 1;
                    this.mDestination = this.destinationAttr;
                }
                if (this.mDestType == 1) {
                    try {
                        this.spoolFile = new File(this.mDestination);
                        outputStream = new FileOutputStream(this.spoolFile);
                    }
                    catch (IOException iOException) {
                        throw new PrinterIOException(iOException);
                    }
                } else {
                    object = new PrinterOpener(this, null);
                    AccessController.doPrivileged(object);
                    if (((PrinterOpener)object).pex != null) {
                        throw ((PrinterOpener)object).pex;
                    }
                    outputStream = ((PrinterOpener)object).result;
                }
            }
            this.mPSStream = new PrintStream(new BufferedOutputStream(outputStream));
            this.mPSStream.println(ADOBE_PS_STR);
        }
        this.mPSStream.println("%%BeginProlog");
        this.mPSStream.println(READIMAGEPROC);
        this.mPSStream.println("/BD {bind def} bind def");
        this.mPSStream.println("/D {def} BD");
        this.mPSStream.println("/ISOF {");
        this.mPSStream.println("     dup findfont dup length 1 add dict begin {");
        this.mPSStream.println("             1 index /FID eq {pop pop} {D} ifelse");
        this.mPSStream.println("     } forall /Encoding ISOLatin1Encoding D");
        this.mPSStream.println("     currentdict end definefont");
        this.mPSStream.println("} BD");
        this.mPSStream.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.mPSStream.println("/DS {");
        this.mPSStream.println("     moveto 1 index stringwidth pop NZ sub");
        this.mPSStream.println("     1 index length 1 sub NZ div 0");
        this.mPSStream.println("     3 2 roll ashow newpath} BD");
        this.mPSStream.println("/F [");
        if (mFontProps == null) {
            this.mPSStream.println(" /Helvetica ISOF");
            this.mPSStream.println(" /Helvetica-Bold ISOF");
            this.mPSStream.println(" /Helvetica-Oblique ISOF");
            this.mPSStream.println(" /Helvetica-BoldOblique ISOF");
            this.mPSStream.println(" /Times-Roman ISOF");
            this.mPSStream.println(" /Times-Bold ISOF");
            this.mPSStream.println(" /Times-Italic ISOF");
            this.mPSStream.println(" /Times-BoldItalic ISOF");
            this.mPSStream.println(" /Courier ISOF");
            this.mPSStream.println(" /Courier-Bold ISOF");
            this.mPSStream.println(" /Courier-Oblique ISOF");
            this.mPSStream.println(" /Courier-BoldOblique ISOF");
        } else {
            int n = Integer.parseInt(mFontProps.getProperty("font.num", "9"));
            for (int i = 0; i < n; ++i) {
                this.mPSStream.println("    /" + mFontProps.getProperty("font." + String.valueOf(i), "Courier ISOF"));
            }
        }
        this.mPSStream.println("] D");
        this.mPSStream.println("/SF {");
        this.mPSStream.println("     F exch get exch scalefont setfont");
        if (mFontProps == null) {
            this.mPSStream.println(" (abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890) stringwidth pop div");
        } else {
            this.mPSStream.println(" testString stringwidth pop div");
        }
        this.mPSStream.println("     currentfont [1 0 0 -1 0 0]makefont exch scalefont setfont} BD");
        this.mPSStream.println("%%EndProlog");
        this.mPSStream.println("%%BeginSetup");
        if (this.epsPrinter == null) {
            this.mPSStream.println("<< " + (this.isCollated() ? "/Collate true " : "") + "/NumCopies " + this.getCopiesInt() + " >> setpagedevice ");
            if (this.sidesAttr != Sides.ONE_SIDED) {
                this.mPSStream.print("<< ");
                if (this.sidesAttr == Sides.TWO_SIDED_LONG_EDGE) {
                    this.mPSStream.print(" /Duplex true ");
                } else if (this.sidesAttr == Sides.TWO_SIDED_SHORT_EDGE) {
                    this.mPSStream.print(" /Duplex true /Tumble true ");
                }
                this.mPSStream.println(">> setpagedevice ");
            }
        }
        this.mPSStream.println("%%EndSetup");
    }

    protected void abortDoc() {
        if (this.mPSStream != null && this.mDestType != 2) {
            this.mPSStream.close();
        }
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(this){
            final /* synthetic */ PrintService val$pservice;
            {
                this.val$pservice = printService;
            }

            @Override
            public Boolean run() {
                try {
                    Class<?> psClass = Class.forName("sun.print.IPPPrintService");
                    if (psClass.isInstance(this.val$pservice)) {
                        Method isPSMethod = psClass.getMethod("isPostscript", null);
                        return (Boolean)isPSMethod.invoke((Object)this.val$pservice, (Object[])null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return Boolean.TRUE;
            }
        });
    }

    protected void endDoc() throws PrinterException {
        if (this.mPSStream != null) {
            this.mPSStream.println(EOF_COMMENT);
            this.mPSStream.flush();
            if (this.mDestType != 2) {
                this.mPSStream.close();
            }
        }
        if (this.mDestType == 0) {
            if (this.getPrintService() != null) {
                this.mDestination = this.getPrintService().getName();
            }
            PrinterSpooler printerSpooler = new PrinterSpooler(this, null);
            AccessController.doPrivileged(printerSpooler);
            if (printerSpooler.pex != null) {
                throw printerSpooler.pex;
            }
        }
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        double d = pageFormat.getPaper().getHeight();
        int n2 = n + 1;
        this.mGStateStack = new ArrayList();
        this.mGStateStack.add(new GState());
        this.mPSStream.println(PAGE_COMMENT + n2 + " " + n2);
        this.mPSStream.println(PAGE_SAVE);
        this.mPSStream.println(d + COORD_PREP);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        this.mPSStream.println(PAGE_RESTORE);
        this.mPSStream.println(SHOWPAGE);
    }

    protected void drawImageBGR(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2) {
        int n3;
        this.setTransform(new AffineTransform());
        this.prepDrawing(null);
        int n4 = (int)f7;
        int n5 = (int)f8;
        this.mPSStream.println(IMAGE_SAVE);
        for (n3 = 3 * n4; n3 > 65535; n3 /= 2) {
        }
        this.mPSStream.println(n3 + IMAGE_STR);
        this.mPSStream.println("[" + f3 + " 0 " + "0 " + f4 + " " + f + " " + f2 + "]concat");
        this.mPSStream.println(n4 + " " + n5 + " " + 8 + "[" + n4 + " 0 " + "0 " + n5 + " 0 " + 0 + "]" + "/imageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n4 * 3];
        try {
            n6 = (int)f6 * n;
            for (int i = 0; i < n5; ++i) {
                n6 += (int)f5;
                n6 = PSPrinterJob.swapBGRtoRGB(byArray, n6, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    protected void printBand(byte[] byArray, int n, int n2, int n3, int n4) throws PrinterException {
        int n5;
        this.mPSStream.println(IMAGE_SAVE);
        for (n5 = 3 * n3; n5 > 65535; n5 /= 2) {
        }
        this.mPSStream.println(n5 + IMAGE_STR);
        this.mPSStream.println("[" + n3 + " 0 " + "0 " + n4 + " " + n + " " + n2 + "]concat");
        this.mPSStream.println(n3 + " " + n4 + " " + 8 + "[" + n3 + " 0 " + "0 " + -n4 + " 0 " + n4 + "]" + "/imageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n3 * 3];
        try {
            for (int i = 0; i < n4; ++i) {
                n6 = PSPrinterJob.swapBGRtoRGB(byArray, n6, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
            }
        }
        catch (IOException iOException) {
            throw new PrinterIOException(iOException);
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        PSPathGraphics pSPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            pSPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl = !peekGraphics.getAWTDrawingOnly();
            pSPathGraphics = new PSPathGraphics(graphics2D, printerJob, printable, pageFormat, n, bl);
        }
        return pSPathGraphics;
    }

    protected void selectClipPath() {
        this.mPSStream.println(this.mClipOpStr);
    }

    protected void setClip(Shape shape) {
        this.mLastClip = shape;
    }

    protected void setTransform(AffineTransform affineTransform) {
        this.mLastTransform = affineTransform;
    }

    protected boolean setFont(Font font) {
        this.mLastFont = font;
        return true;
    }

    private int[] getPSFontIndexArray(Font font, CharsetString[] charsetStringArray) {
        int[] nArray = null;
        if (mFontProps != null) {
            nArray = new int[charsetStringArray.length];
        }
        for (int i = 0; i < charsetStringArray.length && nArray != null; ++i) {
            CharsetString charsetString = charsetStringArray[i];
            CharToByteConverter charToByteConverter = charsetString.fontDescriptor.fontCharset;
            String string = charToByteConverter instanceof CharToByteSymbol ? "symbol" : (charToByteConverter.toString().equals("WingDingsFontCharset") || charToByteConverter.toString().equals("X11Dingbats") ? "dingbats" : this.makeCharsetName(charToByteConverter.getCharacterEncoding(), charsetString.charsetChars));
            int n = font.getStyle() | FontManager.getFont2D((Font)font).getStyle();
            String string2 = FontConfiguration.getStyleString(n);
            String string3 = font.getFamily().toLowerCase(Locale.ENGLISH);
            String string4 = mFontProps.getProperty(string3 = string3.replace(' ', '_'), "");
            String string5 = mFontProps.getProperty(string4 + "." + string + "." + string2, null);
            if (string5 != null) {
                try {
                    nArray[i] = Integer.parseInt(mFontProps.getProperty(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    nArray = null;
                }
                continue;
            }
            nArray = null;
        }
        return nArray;
    }

    private static String escapeParens(String string) {
        if (string.indexOf(40) == -1 && string.indexOf(41) == -1) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(40, n2)) != -1) {
            ++n;
            ++n2;
        }
        n2 = 0;
        while ((n2 = string.indexOf(41, n2)) != -1) {
            ++n;
            ++n2;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + n];
        n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '(' || cArray[i] == ')') {
                cArray2[n2++] = 92;
            }
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2);
    }

    protected boolean textOut(Graphics graphics, String string, float f, float f2) {
        boolean bl = true;
        if (mFontProps == null) {
            this.prepDrawing(graphics);
            this.mPSStream.println(f + " " + f2 + " moveto(" + PSPrinterJob.escapeParens(string) + ")show");
        } else {
            this.prepDrawing(null);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            CharsetString[] charsetStringArray = ((PlatformFont)this.mLastFont.getPeer()).makeMultiCharsetString(string, false);
            if (charsetStringArray == null) {
                return false;
            }
            int[] nArray = this.getPSFontIndexArray(this.mLastFont, charsetStringArray);
            if (nArray != null) {
                for (int i = 0; i < charsetStringArray.length; ++i) {
                    int n;
                    CharsetString charsetString = charsetStringArray[i];
                    CharToByteConverter charToByteConverter = charsetString.fontDescriptor.fontCharset;
                    StringBuffer stringBuffer = new StringBuffer();
                    byte[] byArray = new byte[charsetString.length * 2];
                    try {
                        n = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                    }
                    catch (CharConversionException charConversionException) {
                        continue;
                    }
                    Rectangle2D rectangle2D = fontMetrics.getStringBounds(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, graphics);
                    float f3 = (float)rectangle2D.getWidth();
                    if (f3 == 0.0f) {
                        return bl;
                    }
                    stringBuffer.append('<');
                    for (int j = 0; j < n; ++j) {
                        byte by = byArray[j];
                        String string2 = Integer.toHexString(by);
                        int n2 = string2.length();
                        if (n2 > 2) {
                            string2 = string2.substring(n2 - 2, n2);
                        } else if (n2 == 1) {
                            string2 = "0" + string2;
                        } else if (n2 == 0) {
                            string2 = "00";
                        }
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append('>');
                    this.mPSStream.println("/testString " + stringBuffer.toString() + " D");
                    this.mPSStream.println("% Font[" + this.mLastFont.getName() + ", " + FontConfiguration.getStyleString(this.mLastFont.getStyle()) + ", " + this.mLastFont.getSize2D() + "]");
                    this.getGState().emitPSFont(nArray[i], this.mLastFont.getSize2D(), f3);
                    this.mPSStream.println(stringBuffer.toString());
                    this.mPSStream.println(" " + f3 + " " + f + " " + f2);
                    this.mPSStream.println(DrawStringName);
                    f += f3;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    protected void setFillMode(int n) {
        switch (n) {
            case 1: {
                this.mFillOpStr = EVEN_ODD_FILL_STR;
                this.mClipOpStr = EVEN_ODD_CLIP_STR;
                break;
            }
            case 2: {
                this.mFillOpStr = WINDING_FILL_STR;
                this.mClipOpStr = WINDING_CLIP_STR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void setColor(Color color) {
        this.mLastColor = color;
    }

    protected void fillPath() {
        this.mPSStream.println(this.mFillOpStr);
    }

    protected void beginPath() {
        this.prepDrawing(null);
        this.mPSStream.println(NEWPATH_STR);
        this.mPenX = 0.0f;
        this.mPenY = 0.0f;
    }

    protected void closeSubpath() {
        this.mPSStream.println(CLOSEPATH_STR);
        this.mPenX = this.mStartPathX;
        this.mPenY = this.mStartPathY;
    }

    protected void moveTo(float f, float f2) {
        this.mPSStream.println(f + " " + f2 + MOVETO_STR);
        this.mStartPathX = f;
        this.mStartPathY = f2;
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void lineTo(float f, float f2) {
        this.mPSStream.println(f + " " + f2 + LINETO_STR);
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void bezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mPSStream.println(f + " " + f2 + " " + f3 + " " + f4 + " " + f5 + " " + f6 + CURVETO_STR);
        this.mPenX = f5;
        this.mPenY = f6;
    }

    protected float getPenX() {
        return this.mPenX;
    }

    protected float getPenY() {
        return this.mPenY;
    }

    protected double getXRes() {
        return 300.0;
    }

    protected double getYRes() {
        return 300.0;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return paper.getImageableWidth();
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return paper.getImageableHeight();
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return paper.getWidth();
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return paper.getHeight();
    }

    protected int getNoncollatedCopies() {
        return 1;
    }

    protected int getCollatedCopies() {
        return 1;
    }

    private String[] printExecCmd(String string, String string2, boolean bl, String string3, int n, String string4) {
        String[] stringArray;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 16;
        int n7 = 0;
        int n8 = 2;
        int n9 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n7 |= n2;
            ++n8;
        }
        if (string2 != null && !string2.equals("")) {
            n7 |= n3;
            ++n8;
        }
        if (string3 != null && !string3.equals("")) {
            n7 |= n4;
            ++n8;
        }
        if (n > 1) {
            n7 |= n5;
            ++n8;
        }
        if (bl) {
            n7 |= n6;
            ++n8;
        }
        if (System.getProperty("os.name").equals("Linux")) {
            stringArray = new String[n8];
            stringArray[n9++] = "/usr/bin/lpr";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = new String("-P" + string);
            }
            if ((n7 & n4) != 0) {
                stringArray[n9++] = new String("-J" + string3);
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = new String("-#" + new Integer(n).toString());
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = new String("-h");
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = new String(string2);
            }
        } else {
            stringArray = new String[++n8];
            stringArray[n9++] = "/usr/bin/lp";
            stringArray[n9++] = "-c";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = new String("-d" + string);
            }
            if ((n7 & n4) != 0) {
                stringArray[n9++] = new String("-t" + string3);
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = new String("-n" + new Integer(n).toString());
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = new String("-o nobanner");
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = new String("-o" + string2);
            }
        }
        stringArray[n9++] = string4;
        return stringArray;
    }

    private static int swapBGRtoRGB(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n < byArray.length - 2 && n2 < byArray2.length - 2) {
            byArray2[n2++] = byArray[n + 2];
            byArray2[n2++] = byArray[n + 1];
            byArray2[n2++] = byArray[n + 0];
            n += 3;
        }
        return n;
    }

    private String makeCharsetName(String string, char[] cArray) {
        if (string.equals("Cp1252") || string.equals("ISO8859_1")) {
            return "latin1";
        }
        if (string.equals("UTF8")) {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] <= '\u00ff') continue;
                return string.toLowerCase();
            }
            return "latin1";
        }
        if (string.startsWith("ISO8859")) {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] <= '\u007f') continue;
                return string.toLowerCase();
            }
            return "latin1";
        }
        return string.toLowerCase();
    }

    private void prepDrawing(Graphics graphics) {
        while (!(this.isOuterGState() || this.getGState().canSetClip(this.mLastClip) && this.getGState().mTransform.equals(this.mLastTransform))) {
            this.grestore();
        }
        this.getGState().emitPSColor(this.mLastColor);
        if (this.isOuterGState()) {
            this.gsave();
            this.getGState().emitTransform(this.mLastTransform);
            this.getGState().emitPSClip(this.mLastClip);
        }
        if (graphics != null) {
            this.getGState().emitPSFont(graphics, this.mLastFont);
        }
    }

    private GState getGState() {
        int n = this.mGStateStack.size();
        return (GState)this.mGStateStack.get(n - 1);
    }

    private void gsave() {
        GState gState = this.getGState();
        this.mGStateStack.add(new GState(gState));
        this.mPSStream.println(GSAVE_STR);
    }

    private void grestore() {
        int n = this.mGStateStack.size();
        this.mGStateStack.remove(n - 1);
        this.mPSStream.println(GRESTORE_STR);
    }

    private boolean isOuterGState() {
        return this.mGStateStack.size() == 1;
    }

    void convertToPSPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        this.beginPath();
        this.setFillMode(n);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    this.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    float f = this.getPenX();
                    float f2 = this.getPenY();
                    float f3 = f + (fArray[0] - f) * 2.0f / 3.0f;
                    float f4 = f2 + (fArray[1] - f2) * 2.0f / 3.0f;
                    float f5 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f6 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    this.bezierTo(f3, f4, f5, f6, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closeSubpath();
                }
            }
            pathIterator.next();
        }
    }

    protected void deviceFill(PathIterator pathIterator, Color color, AffineTransform affineTransform, Shape shape) {
        this.setTransform(affineTransform);
        this.setClip(shape);
        this.setColor(color);
        this.convertToPSPath(pathIterator);
        this.mPSStream.println(GSAVE_STR);
        this.selectClipPath();
        this.fillPath();
        this.mPSStream.println("grestore newpath");
    }

    private byte[] rlEncode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray2 = new byte[byArray.length * 2 + 2];
        while (n < byArray.length) {
            if (n4 == 0) {
                n3 = n++;
                n4 = 1;
            }
            while (n4 < 128 && n < byArray.length && byArray[n] == byArray[n3]) {
                ++n4;
                ++n;
            }
            if (n4 > 1) {
                byArray2[n2++] = (byte)(257 - n4);
                byArray2[n2++] = byArray[n3];
                n4 = 0;
                continue;
            }
            while (n4 < 128 && n < byArray.length && byArray[n] != byArray[n - 1]) {
                ++n4;
                ++n;
            }
            byArray2[n2++] = (byte)(n4 - 1);
            for (int i = n3; i < n3 + n4; ++i) {
                byArray2[n2++] = byArray[i];
            }
            n4 = 0;
        }
        byArray2[n2++] = -128;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    private byte[] ascii85Encode(byte[] byArray) {
        long l;
        long l2;
        byte[] byArray2 = new byte[(byArray.length + 4) * 5 / 4 + 2];
        long l3 = 85L;
        long l4 = l3 * l3;
        long l5 = l3 * l4;
        long l6 = l3 * l5;
        int n = 33;
        int n2 = 0;
        int n3 = 0;
        while (n2 + 3 < byArray.length) {
            if ((l2 = ((long)(byArray[n2++] & 0xFF) << 24) + ((long)(byArray[n2++] & 0xFF) << 16) + ((long)(byArray[n2++] & 0xFF) << 8) + (long)(byArray[n2++] & 0xFF)) == 0L) {
                byArray2[n3++] = 122;
                continue;
            }
            l = l2;
            byArray2[n3++] = (byte)(l / l6 + (long)n);
            byArray2[n3++] = (byte)((l %= l6) / l5 + (long)n);
            byArray2[n3++] = (byte)((l %= l5) / l4 + (long)n);
            byArray2[n3++] = (byte)((l %= l4) / l3 + (long)n);
            byArray2[n3++] = (byte)((l %= l3) + (long)n);
        }
        if (n2 < byArray.length) {
            int n4 = byArray.length - n2;
            l2 = 0L;
            while (n2 < byArray.length) {
                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
            }
            int n5 = 4 - n4;
            while (n5-- > 0) {
                l2 <<= 8;
            }
            byte[] byArray3 = new byte[5];
            l = l2;
            byArray3[0] = (byte)(l / l6 + (long)n);
            byArray3[1] = (byte)((l %= l6) / l5 + (long)n);
            byArray3[2] = (byte)((l %= l5) / l4 + (long)n);
            byArray3[3] = (byte)((l %= l4) / l3 + (long)n);
            byArray3[4] = (byte)((l %= l3) + (long)n);
            for (int i = 0; i < n4 + 1; ++i) {
                byArray2[n3++] = byArray3[i];
            }
        }
        byArray2[n3++] = 126;
        byArray2[n3++] = 62;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray4, 0, n3);
        return byArray4;
    }

    static /* synthetic */ Properties access$002(Properties properties) {
        mFontProps = properties;
        return mFontProps;
    }

    static /* synthetic */ Properties access$100() {
        return PSPrinterJob.initProps();
    }

    static /* synthetic */ String access$300(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mDestination;
    }

    static /* synthetic */ String access$400(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mOptions;
    }

    static /* synthetic */ boolean access$500(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mNoJobSheet;
    }

    static /* synthetic */ String[] access$600(PSPrinterJob pSPrinterJob, String string, String string2, boolean bl, String string3, int n, String string4) {
        return pSPrinterJob.printExecCmd(string, string2, bl, string3, n, string4);
    }

    static /* synthetic */ String access$800(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mFillOpStr;
    }

    static /* synthetic */ String access$900(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mClipOpStr;
    }

    static /* synthetic */ String access$902(PSPrinterJob pSPrinterJob, String string) {
        pSPrinterJob.mClipOpStr = string;
        return pSPrinterJob.mClipOpStr;
    }

    static /* synthetic */ String access$802(PSPrinterJob pSPrinterJob, String string) {
        pSPrinterJob.mFillOpStr = string;
        return pSPrinterJob.mFillOpStr;
    }

    static /* synthetic */ GState access$1000(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.getGState();
    }

    static /* synthetic */ EPSPrinter access$1102(PSPrinterJob pSPrinterJob, EPSPrinter ePSPrinter) {
        pSPrinterJob.epsPrinter = ePSPrinter;
        return pSPrinterJob.epsPrinter;
    }

    static /* synthetic */ int access$1202(PSPrinterJob pSPrinterJob, int n) {
        pSPrinterJob.mDestType = n;
        return pSPrinterJob.mDestType;
    }

    static {
        String string;
        hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        mFontProps = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                mFontProps = PSPrinterJob.initProps();
                isMac = OSInfo.getOSType() == OSInfo.OSType.MACOSX;
                return null;
            }
        });
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        String string2 = AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        if (string2 != null) {
            if (string2.equalsIgnoreCase(FORCE_PDL)) {
                forcePDL = true;
            } else if (string2.equalsIgnoreCase(FORCE_RASTER)) {
                forceRaster = true;
            }
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction(SHAPE_TEXT_PROP))) != null) {
            shapeTextProp = true;
        }
    }

    public static class EPSPrinter
    implements Pageable {
        private PageFormat pf;
        private PSPrinterJob job;
        private int llx;
        private int lly;
        private int urx;
        private int ury;
        private Printable printable;
        private PrintStream stream;
        private String epsTitle;

        public EPSPrinter(Printable printable, String title, PrintStream stream, int x, int y, int wid, int hgt) {
            this.printable = printable;
            this.epsTitle = title;
            this.stream = stream;
            this.llx = x;
            this.lly = y;
            this.urx = this.llx + wid;
            this.ury = this.lly + hgt;
            Paper p = new Paper();
            p.setSize(wid, hgt);
            p.setImageableArea(0.0, 0.0, wid, hgt);
            this.pf = new PageFormat();
            this.pf.setPaper(p);
        }

        public void print() throws PrinterException {
            this.stream.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.stream.println("%%BoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury);
            this.stream.println("%%Title: " + this.epsTitle);
            this.stream.println("%%Creator: Java Printing");
            this.stream.println("%%CreationDate: " + String.valueOf(new Date()));
            this.stream.println("%%EndComments");
            this.stream.println("/pluginSave save def");
            this.stream.println("mark");
            this.job = new PSPrinterJob();
            this.job.epsPrinter = this;
            this.job.mPSStream = this.stream;
            this.job.mDestType = 2;
            this.job.startDoc();
            try {
                this.job.printPage(this, 0);
            }
            catch (Throwable t) {
                if (t instanceof PrinterException) {
                    throw (PrinterException)t;
                }
                throw new PrinterException(t.toString());
            }
            finally {
                this.stream.println("cleartomark");
                this.stream.println("pluginSave restore");
                this.job.endDoc();
            }
            this.stream.flush();
        }

        @Override
        public int getNumberOfPages() {
            return 1;
        }

        @Override
        public PageFormat getPageFormat(int pgIndex) {
            if (pgIndex > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.pf;
        }

        @Override
        public Printable getPrintable(int pgIndex) {
            if (pgIndex > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.printable;
        }
    }

    private class GState {
        Color mColor;
        Shape mClip;
        Font mFont;
        AffineTransform mTransform;

        GState() {
            this.mColor = Color.black;
            this.mClip = null;
            this.mFont = null;
            this.mTransform = new AffineTransform();
        }

        GState(GState copyGState) {
            this.mColor = copyGState.mColor;
            this.mClip = copyGState.mClip;
            this.mFont = copyGState.mFont;
            this.mTransform = copyGState.mTransform;
        }

        boolean canSetClip(Shape clip) {
            return this.mClip == null || this.mClip.equals(clip);
        }

        void emitPSClip(Shape clip) {
            if (!(clip == null || this.mClip != null && this.mClip.equals(clip))) {
                String saveFillOp = PSPrinterJob.this.mFillOpStr;
                String saveClipOp = PSPrinterJob.this.mClipOpStr;
                PSPrinterJob.this.convertToPSPath(clip.getPathIterator(new AffineTransform()));
                PSPrinterJob.this.selectClipPath();
                this.mClip = clip;
                PSPrinterJob.this.mClipOpStr = saveFillOp;
                PSPrinterJob.this.mFillOpStr = saveFillOp;
            }
        }

        void emitTransform(AffineTransform transform) {
            if (transform != null && !transform.equals(this.mTransform)) {
                double[] matrix = new double[6];
                transform.getMatrix(matrix);
                PSPrinterJob.this.mPSStream.println("[" + (float)matrix[0] + " " + (float)matrix[1] + " " + (float)matrix[2] + " " + (float)matrix[3] + " " + (float)matrix[4] + " " + (float)matrix[5] + "] concat");
                this.mTransform = transform;
            }
        }

        void emitPSColor(Color color) {
            if (color != null && !color.equals(this.mColor)) {
                float[] rgb = color.getRGBColorComponents(null);
                if (rgb[0] == rgb[1] && rgb[1] == rgb[2]) {
                    PSPrinterJob.this.mPSStream.println(rgb[0] + " SG");
                } else {
                    PSPrinterJob.this.mPSStream.println(rgb[0] + " " + rgb[1] + " " + rgb[2] + "  SC");
                }
                this.mColor = color;
            }
        }

        void emitPSFont(int psFontIndex, float fontSize) {
            PSPrinterJob.this.mPSStream.println(fontSize + " " + psFontIndex + " F");
        }
    }

    public static class PluginPrinter
    implements Printable {
        private EPSPrinter epsPrinter;
        private Component applet;
        private PrintStream stream;
        private String epsTitle;
        private int bx;
        private int by;
        private int bw;
        private int bh;
        private int width;
        private int height;

        public PluginPrinter(Component applet, PrintStream stream, int x, int y, int w, int h) {
            this.applet = applet;
            this.epsTitle = "Java Plugin Applet";
            this.stream = stream;
            this.bx = x;
            this.by = y;
            this.bw = w;
            this.bh = h;
            this.width = applet.size().width;
            this.height = applet.size().height;
            this.epsPrinter = new EPSPrinter(this, this.epsTitle, stream, 0, 0, this.width, this.height);
        }

        public void printPluginPSHeader() {
            this.stream.println("%%BeginDocument: JavaPluginApplet");
        }

        public void printPluginApplet() {
            try {
                this.epsPrinter.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }

        public void printPluginPSTrailer() {
            this.stream.println("%%EndDocument: JavaPluginApplet");
            this.stream.flush();
        }

        public void printAll() {
            this.printPluginPSHeader();
            this.printPluginApplet();
            this.printPluginPSTrailer();
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pgIndex) {
            if (pgIndex > 0) {
                return 1;
            }
            this.applet.printAll(g);
            return 0;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction<OutputStream> {
        PrinterException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        @Override
        public OutputStream run() {
            try {
                PSPrinterJob.this.spoolFile = Files.createTempFile("javaprint", ".ps", new FileAttribute[0]).toFile();
                PSPrinterJob.this.spoolFile.deleteOnExit();
                this.result = new FileOutputStream(PSPrinterJob.this.spoolFile);
                return this.result;
            }
            catch (IOException ex) {
                this.pex = new PrinterIOException(ex);
                return null;
            }
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction<Object> {
        PrinterException pex;

        private PrinterSpooler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleProcessFailure(Process failedProcess, String[] execCmd, int result) throws IOException {
            StringWriter sw = new StringWriter();
            try {
                PrintWriter pw = new PrintWriter(sw);
                try {
                    pw.append("error=").append(Integer.toString(result));
                    pw.append(" running:");
                    for (String arg : execCmd) {
                        pw.append(" '").append(arg).append("'");
                    }
                    try (InputStream is = failedProcess.getErrorStream();
                         InputStreamReader isr = new InputStreamReader(is);
                         BufferedReader br = new BufferedReader(isr);){
                        while (br.ready()) {
                            pw.println();
                            pw.append("\t\t").append(br.readLine());
                        }
                    }
                    finally {
                        pw.flush();
                    }
                    throw new IOException(sw.toString());
                }
                catch (Throwable throwable) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                try {
                    sw.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() {
            if (PSPrinterJob.this.spoolFile == null || !PSPrinterJob.this.spoolFile.exists()) {
                this.pex = new PrinterException("No spool file");
                return null;
            }
            try {
                String fileName = PSPrinterJob.this.spoolFile.getAbsolutePath();
                String[] execCmd = PSPrinterJob.this.printExecCmd(PSPrinterJob.this.mDestination, PSPrinterJob.this.mOptions, PSPrinterJob.this.mNoJobSheet, PSPrinterJob.this.getJobNameInt(), 1, fileName);
                Process process = Runtime.getRuntime().exec(execCmd);
                process.waitFor();
                int result = process.exitValue();
                if (0 != result) {
                    this.handleProcessFailure(process, execCmd, result);
                }
            }
            catch (IOException ex) {
                this.pex = new PrinterIOException(ex);
            }
            catch (InterruptedException ie) {
                this.pex = new PrinterException(ie.toString());
            }
            finally {
                PSPrinterJob.this.spoolFile.delete();
            }
            return null;
        }
    }
}

