# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementTopicsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_get(self, resource_group):
        response = self.client.topics.get(
            resource_group_name=resource_group.name,
            topic_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_begin_create_or_update(self, resource_group):
        response = self.client.topics.begin_create_or_update(
            resource_group_name=resource_group.name,
            topic_name="str",
            topic_info={
                "location": "str",
                "dataResidencyBoundary": "str",
                "disableLocalAuth": False,
                "endpoint": "str",
                "eventTypeInfo": {
                    "inlineEventTypes": {
                        "str": {
                            "dataSchemaUrl": "str",
                            "description": "str",
                            "displayName": "str",
                            "documentationUrl": "str",
                        }
                    },
                    "kind": "str",
                },
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inboundIpRules": [{"action": "str", "ipMask": "str"}],
                "inputSchema": "str",
                "inputSchemaMapping": "input_schema_mapping",
                "kind": "Azure",
                "metricResourceId": "str",
                "minimumTlsVersionAllowed": "str",
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "groupIds": ["str"],
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "publicNetworkAccess": "str",
                "sku": {"name": "Basic"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_begin_delete(self, resource_group):
        response = self.client.topics.begin_delete(
            resource_group_name=resource_group.name,
            topic_name="str",
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_begin_update(self, resource_group):
        response = self.client.topics.begin_update(
            resource_group_name=resource_group.name,
            topic_name="str",
            topic_update_parameters={
                "dataResidencyBoundary": "str",
                "disableLocalAuth": bool,
                "eventTypeInfo": {
                    "inlineEventTypes": {
                        "str": {
                            "dataSchemaUrl": "str",
                            "description": "str",
                            "displayName": "str",
                            "documentationUrl": "str",
                        }
                    },
                    "kind": "str",
                },
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inboundIpRules": [{"action": "str", "ipMask": "str"}],
                "minimumTlsVersionAllowed": "str",
                "publicNetworkAccess": "str",
                "sku": {"name": "Basic"},
                "tags": {"str": "str"},
            },
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_list_by_subscription(self, resource_group):
        response = self.client.topics.list_by_subscription(
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_list_by_resource_group(self, resource_group):
        response = self.client.topics.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_list_shared_access_keys(self, resource_group):
        response = self.client.topics.list_shared_access_keys(
            resource_group_name=resource_group.name,
            topic_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_begin_regenerate_key(self, resource_group):
        response = self.client.topics.begin_regenerate_key(
            resource_group_name=resource_group.name,
            topic_name="str",
            regenerate_key_request={"keyName": "str"},
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_topics_list_event_types(self, resource_group):
        response = self.client.topics.list_event_types(
            resource_group_name=resource_group.name,
            provider_namespace="str",
            resource_type_name="str",
            resource_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
