% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epsilon.R
\name{epsilon}
\alias{epsilon}
\title{Levi-Civita Symbol}
\usage{
epsilon(n)
}
\arguments{
\item{n}{number of dimensions.}
}
\value{
\code{array} representing the Levi-Civita symbol.
}
\description{
Computes the Levi-Civita totally antisymmetric tensor.
}
\examples{
### Levi-Civita symbol in 2 dimensions
epsilon(2)

### Levi-Civita symbol in 3 dimensions
epsilon(3)

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other tensor algebra: 
\code{\link{contraction}()},
\code{\link{delta}()},
\code{\link{diagonal}()},
\code{\link{einstein}()},
\code{\link{index}()}
}
\concept{tensor algebra}
