% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year-quarter-day-count-between}
\alias{year-quarter-day-count-between}
\alias{calendar_count_between.clock_year_quarter_day}
\title{Counting: year-quarter-day}
\usage{
\method{calendar_count_between}{clock_year_quarter_day}(start, end, precision, ..., n = 1L)
}
\arguments{
\item{start, end}{\verb{[clock_year_quarter_day]}

A pair of year-quarter-day vectors. These will be recycled to their
common size.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"quarter"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
An integer representing the number of \code{precision} units between
\code{start} and \code{end}.
}
\description{
This is a year-quarter-day method for the \code{\link[=calendar_count_between]{calendar_count_between()}} generic.
It counts the number of \code{precision} units between \code{start} and \code{end} (i.e.,
the number of years or quarters).
}
\examples{
# Compute the number of whole quarters between two dates
x <- year_quarter_day(2020, 3, 91)
y <- year_quarter_day(2025, 4, c(90, 92))
calendar_count_between(x, y, "quarter")

# Note that this is not always the same as the number of whole 3 month
# periods between two dates
x <- as_year_month_day(x)
y <- as_year_month_day(y)
calendar_count_between(x, y, "month", n = 3)
}
