/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __LZIP_H__
#define __LZIP_H__
/*
 * LZIP decompressor
 *
 * Copyright (C) 2016-2026 Antonio Diaz Diaz.
 */

/* Return values (< 0 = Error) */
enum {
	LZIP_OOM_INBUF     = -1,
	LZIP_HEADER1_EOF   = -2,
	LZIP_HEADER2_EOF   = -3,
	LZIP_BAD_MAGIC1    = -4,
	LZIP_BAD_MAGIC2    = -5,
	LZIP_BAD_VERSION   = -6,
	LZIP_BAD_DICT_SIZE = -7,
	LZIP_OOM_OUTBUF    = -8,
	LZIP_WRITE_ERROR   = -9,
	LZIP_BAD_DATA      = -10,
	LZIP_DATA_EOF      = -11,
	LZIP_BAD_CRC       = -12,
	LZIP_EMPTY_MEMBER  = -13
};

int lzip_decompress(unsigned char *inbuf, long in_len,
			long (*fill)(void*, unsigned long),
			long (*flush)(void*, unsigned long),
			unsigned char *outbuf, long out_size,
			long *in_posp, long *out_posp);

/* inbuf    - input buffer. If null or in_len <= 0, fill must be non-null
 * in_len   - len of pre-read data in inbuf if inbuf is non-null
 * fill     - if non-null, function to fill inbuf when empty
 * flush    - if non-null, function to write out outbuf when full
 * outbuf   - output buffer. If null or out_size <= 0, flush must be non-null
 * out_size - size of outbuf if outbuf is non-null
 * in_posp  - if non-null, the number of bytes consumed will be returned here
 * out_posp - if non-null, the number of bytes produced will be returned here
 *
 * fill will be called (repeatedly) to read data. in_len bytes will be read
 * per call (or 16384 bytes per call if inbuf is null or in_len <= 0).
 *
 * If flush is null, outbuf must be large enough to buffer all the expected
 * output. Else the flush function will be called to flush the output buffer
 * at the appropriate time (stream dependent).
 * If out_size > 0 but is not large enough to buffer all the expected output,
 * it must be at least as large as the dictionary size of the data.
 *
 * inbuf and outbuf may overlap (in-place decompression).
 */

#endif
