/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2020  Intel Corporation. All rights reserved.
 *
 */

/* MCP Media State */
#define BT_MCS_STATUS_INACTIVE	0x00
#define BT_MCS_STATUS_PLAYING	0x01
#define BT_MCS_STATUS_PAUSED	0x02
#define BT_MCS_STATUS_SEEKING	0x03

/* MCP Control Point Opcodes */
#define BT_MCS_CMD_PLAY			    0x01
#define BT_MCS_CMD_PAUSE		    0x02
#define BT_MCS_CMD_FAST_REWIND	    0x03
#define BT_MCS_CMD_FAST_FORWARD	    0x04
#define BT_MCS_CMD_STOP			    0x05

#define BT_MCS_CMD_MOVE_RELATIVE    0x10

#define BT_MCS_CMD_PREV_SEGMENT     0x20
#define BT_MCS_CMD_NEXT_SEGMENT     0x21
#define BT_MCS_CMD_FIRST_SEGMENT    0x22
#define BT_MCS_CMD_LAST_SEGMENT     0x23
#define BT_MCS_CMD_GOTO_SEGMENT     0x24

#define BT_MCS_CMD_PREV_TRACK       0x30
#define BT_MCS_CMD_NEXT_TRACK       0x31
#define BT_MCS_CMD_FIRST_TRACK      0x32
#define BT_MCS_CMD_LAST_TRACK       0x33
#define BT_MCS_CMD_GOTO_TRACK       0x34

#define BT_MCS_CMD_PREV_GROUP       0x40
#define BT_MCS_CMD_NEXT_GROUP       0x41
#define BT_MCS_CMD_FIRST_GROUP      0x42
#define BT_MCS_CMD_LAST_GROUP       0x43
#define BT_MCS_CMD_GOTO_GROUP       0x44


/* MCP Control Point Opcodes Supported */
#define BT_MCS_CMD_PLAY_SUPPORTED		0x00000001
#define BT_MCS_CMD_PAUSE_SUPPORTED		0x00000002
#define BT_MCS_CMD_FAST_REWIND_SUPPORTED	0x00000004
#define BT_MCS_CMD_FAST_FORWARD_SUPPORTED	0x00000008
#define BT_MCS_CMD_STOP_SUPPORTED		0x00000010
#define BT_MCS_CMD_MOVE_RELATIVE_SUPPORTED	0x00000020
#define BT_MCS_CMD_PREV_SEGMENT_SUPPORTED	0x00000040
#define BT_MCS_CMD_NEXT_SEGMENT_SUPPORTED	0x00000080
#define BT_MCS_CMD_FIRST_SEGMENT_SUPPORTED	0x00000100
#define BT_MCS_CMD_LAST_SEGMENT_SUPPORTED	0x00000200
#define BT_MCS_CMD_GOTO_SEGMENT_SUPPORTED	0x00000400
#define BT_MCS_CMD_PREV_TRACK_SUPPORTED		0x00000800
#define BT_MCS_CMD_NEXT_TRACK_SUPPORTED		0x00001000
#define BT_MCS_CMD_FIRST_TRACK_SUPPORTED	0x00002000
#define BT_MCS_CMD_LAST_TRACK_SUPPORTED		0x00004000
#define BT_MCS_CMD_GOTO_TRACK_SUPPORTED		0x00008000
#define BT_MCS_CMD_PREV_GROUP_SUPPORTED		0x00010000
#define BT_MCS_CMD_NEXT_GROUP_SUPPORTED		0x00020000
#define BT_MCS_CMD_FIRST_GROUP_SUPPORTED	0x00040000
#define BT_MCS_CMD_LAST_GROUP_SUPPORTED		0x00080000
#define BT_MCS_CMD_GOTO_GROUP_SUPPORTED		0x00100000
