/*
 * This file is open source software, licensed to you under the terms
 * of the Apache License, Version 2.0 (the "License").  See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership.  You may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/*
 * Copyright (C) 2016 ScyllaDB.
 */
#pragma once
#ifndef SEASTAR_MODULE
#include <stdlib.h>
#include <memory>
#include <seastar/util/modules.hh>
#endif

namespace seastar {

namespace internal {
void* allocate_aligned_buffer_impl(size_t size, size_t align);
}

SEASTAR_MODULE_EXPORT_BEGIN

struct free_deleter {
    void operator()(void* p) { ::free(p); }
};

template <typename CharType>
inline
std::unique_ptr<CharType[], free_deleter> allocate_aligned_buffer(size_t size, size_t align) {
    static_assert(sizeof(CharType) == 1, "must allocate byte type");
    void* ret = internal::allocate_aligned_buffer_impl(size, align);
    return std::unique_ptr<CharType[], free_deleter>(reinterpret_cast<CharType *>(ret));
}

SEASTAR_MODULE_EXPORT_END

}
