#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "barrier", "enabled"
        ):
            return
        if not self.env["runtime"]["ScreenManager"].is_delta(ignoreSpace=True):
            return
        self.env["runtime"]["BarrierManager"].handle_line_barrier(
            self.env["screen"]["new_content_text"].split("\n"),
            self.env["screen"]["new_cursor"]["x"],
            self.env["screen"]["new_cursor"]["y"],
        )

    def set_callback(self, callback):
        pass
