{%MainUnit codepagescommon.pas}

{
 *****************************************************************************
  This file is part of LazUtils.

  See the file COPYING.modifiedLGPL.txt, included in this distribution,
  for details about the license.
 *****************************************************************************

  Common Unicode Conversion Tables
}

type
  TCharToUTF8Table = array[char] of PChar;

const
  ArrayISO_8859_1ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #194#161,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #194#164,           // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #194#170,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #194#175,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #194#184,           // #184
    #194#185,           // #185
    #194#186,           // #186
    #194#187,           // #187
    #194#188,           // #188
    #194#189,           // #189
    #194#190,           // #190
    #194#191,           // #191
    #195#128,           // #192
    #195#129,           // #193
    #195#130,           // #194
    #195#131,           // #195
    #195#132,           // #196
    #195#133,           // #197
    #195#134,           // #198
    #195#135,           // #199
    #195#136,           // #200
    #195#137,           // #201
    #195#138,           // #202
    #195#139,           // #203
    #195#140,           // #204
    #195#141,           // #205
    #195#142,           // #206
    #195#143,           // #207
    #195#144,           // #208
    #195#145,           // #209
    #195#146,           // #210
    #195#147,           // #211
    #195#148,           // #212
    #195#149,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #195#152,           // #216
    #195#153,           // #217
    #195#154,           // #218
    #195#155,           // #219
    #195#156,           // #220
    #195#157,           // #221
    #195#158,           // #222
    #195#159,           // #223
    #195#160,           // #224
    #195#161,           // #225
    #195#162,           // #226
    #195#163,           // #227
    #195#164,           // #228
    #195#165,           // #229
    #195#166,           // #230
    #195#167,           // #231
    #195#168,           // #232
    #195#169,           // #233
    #195#170,           // #234
    #195#171,           // #235
    #195#172,           // #236
    #195#173,           // #237
    #195#174,           // #238
    #195#175,           // #239
    #195#176,           // #240
    #195#177,           // #241
    #195#178,           // #242
    #195#179,           // #243
    #195#180,           // #244
    #195#181,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #195#184,           // #248
    #195#185,           // #249
    #195#186,           // #250
    #195#187,           // #251
    #195#188,           // #252
    #195#189,           // #253
    #195#190,           // #254
    #195#191            // #255
  );

  ArrayISO_8859_9ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #194#161,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #194#164,           // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #194#170,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #194#175,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #194#184,           // #184
    #194#185,           // #185
    #194#186,           // #186
    #194#187,           // #187
    #194#188,           // #188
    #194#189,           // #189
    #194#190,           // #190
    #194#191,           // #191
    #195#128,           // #192
    #195#129,           // #193
    #195#130,           // #194
    #195#131,           // #195
    #195#132,           // #196
    #195#133,           // #197
    #195#134,           // #198
    #195#135,           // #199
    #195#136,           // #200
    #195#137,           // #201
    #195#138,           // #202
    #195#139,           // #203
    #195#140,           // #204
    #195#141,           // #205
    #195#142,           // #206
    #195#143,           // #207
    #$C4#$9E,           // #208 // changed since ISO-8859-1
    #195#145,           // #209
    #195#146,           // #210
    #195#147,           // #211
    #195#148,           // #212
    #195#149,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #195#152,           // #216
    #195#153,           // #217
    #195#154,           // #218
    #195#155,           // #219
    #195#156,           // #220
    #$C4#$B0,           // #221 // changed since ISO-8859-1
    #$C5#$9E,           // #222 // changed since ISO-8859-1
    #195#159,           // #223
    #195#160,           // #224
    #195#161,           // #225
    #195#162,           // #226
    #195#163,           // #227
    #195#164,           // #228
    #195#165,           // #229
    #195#166,           // #230
    #195#167,           // #231
    #195#168,           // #232
    #195#169,           // #233
    #195#170,           // #234
    #195#171,           // #235
    #195#172,           // #236
    #195#173,           // #237
    #195#174,           // #238
    #195#175,           // #239
    #$C4#$9F,           // #240 // changed since ISO-8859-1
    #195#177,           // #241
    #195#178,           // #242
    #195#179,           // #243
    #195#180,           // #244
    #195#181,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #195#184,           // #248
    #195#185,           // #249
    #195#186,           // #250
    #195#187,           // #251
    #195#188,           // #252
    #$C4#$B1,           // #253 // changed since ISO-8859-1
    #$C5#$9F,           // #254 // changed since ISO-8859-1
    #195#191            // #255
  );

  ArrayISO_8859_10ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #$C2#$A0, // $A0
    #$C4#$84, // $A1
    #$C4#$92, // $A2
    #$C4#$A2, // $A3
    #$C4#$AA, // $A4
    #$C4#$A8, // $A5
    #$C4#$B6, // $A6
    #$C2#$A7, // $A7
    #$C4#$BB, // $A8
    #$C4#$90, // $A9
    #$C5#$A0, // $AA
    #$C5#$A6, // $AB
    #$C5#$BD, // $AC
    #$C2#$AD, // $AD
    #$C5#$AA, // $AE
    #$C5#$8A, // $AF
    #$C2#$B0, // $B0
    #$C4#$85, // $B1
    #$C4#$93, // $B2
    #$C4#$A3, // $B3
    #$C4#$AB, // $B4
    #$C4#$A9, // $B5
    #$C4#$B7, // $B6
    #$C2#$B7, // $B7
    #$C4#$BC, // $B8
    #$C4#$91, // $B9
    #$C5#$A1, // $BA
    #$C5#$A7, // $BB
    #$C5#$BE, // $BC
    #$E2#$80#$95, // $BD
    #$C5#$AB, // $BE
    #$C5#$8B, // $BF
    #$C4#$80, // $C0
    #$C3#$81, // $C1
    #$C3#$82, // $C2
    #$C3#$83, // $C3
    #$C3#$84, // $C4
    #$C3#$85, // $C5
    #$C3#$86, // $C6
    #$C4#$AE, // $C7
    #$C4#$8C, // $C8
    #$C3#$89, // $C9
    #$C4#$98, // $CA
    #$C3#$8B, // $CB
    #$C4#$96, // $CC
    #$C3#$8D, // $CD
    #$C3#$8E, // $CE
    #$C3#$8F, // $CF
    #$C3#$90, // $D0
    #$C5#$85, // $D1
    #$C5#$8C, // $D2
    #$C3#$93, // $D3
    #$C3#$94, // $D4
    #$C3#$95, // $D5
    #$C3#$96, // $D6
    #$C5#$A8, // $D7
    #$C3#$98, // $D8
    #$C5#$B2, // $D9
    #$C3#$9A, // $DA
    #$C3#$9B, // $DB
    #$C3#$9C, // $DC
    #$C3#$9D, // $DD
    #$C3#$9E, // $DE
    #$C3#$9F, // $DF
    #$C4#$81, // $E0
    #$C3#$A1, // $E1
    #$C3#$A2, // $E2
    #$C3#$A3, // $E3
    #$C3#$A4, // $E4
    #$C3#$A5, // $E5
    #$C3#$A6, // $E6
    #$C4#$AF, // $E7
    #$C4#$8D, // $E8
    #$C3#$A9, // $E9
    #$C4#$99, // $EA
    #$C3#$AB, // $EB
    #$C4#$97, // $EC
    #$C3#$AD, // $ED
    #$C3#$AE, // $EE
    #$C3#$AF, // $EF
    #$C3#$B0, // $F0
    #$C5#$86, // $F1
    #$C5#$8D, // $F2
    #$C3#$B3, // $F3
    #$C3#$B4, // $F4
    #$C3#$B5, // $F5
    #$C3#$B6, // $F6
    #$C5#$A9, // $F7
    #$C3#$B8, // $F8
    #$C5#$B3, // $F9
    #$C3#$BA, // $FA
    #$C3#$BB, // $FB
    #$C3#$BC, // $FC
    #$C3#$BD, // $FD
    #$C3#$BE, // $FE
    #$C4#$B8 // $FF
  );

  ArrayISO_8859_13ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #$C2#$A0, // $A0
    #$E2#$80#$9D, // $A1
    #$C2#$A2, // $A2
    #$C2#$A3, // $A3
    #$C2#$A4, // $A4
    #$E2#$80#$9E, // $A5
    #$C2#$A6, // $A6
    #$C2#$A7, // $A7
    #$C3#$98, // $A8
    #$C2#$A9, // $A9
    #$C5#$96, // $AA
    #$C2#$AB, // $AB
    #$C2#$AC, // $AC
    #$C2#$AD, // $AD
    #$C2#$AE, // $AE
    #$C3#$86, // $AF
    #$C2#$B0, // $B0
    #$C2#$B1, // $B1
    #$C2#$B2, // $B2
    #$C2#$B3, // $B3
    #$E2#$80#$9C, // $B4
    #$C2#$B5, // $B5
    #$C2#$B6, // $B6
    #$C2#$B7, // $B7
    #$C3#$B8, // $B8
    #$C2#$B9, // $B9
    #$C5#$97, // $BA
    #$C2#$BB, // $BB
    #$C2#$BC, // $BC
    #$C2#$BD, // $BD
    #$C2#$BE, // $BE
    #$C3#$A6, // $BF
    #$C4#$84, // $C0
    #$C4#$AE, // $C1
    #$C4#$80, // $C2
    #$C4#$86, // $C3
    #$C3#$84, // $C4
    #$C3#$85, // $C5
    #$C4#$98, // $C6
    #$C4#$92, // $C7
    #$C4#$8C, // $C8
    #$C3#$89, // $C9
    #$C5#$B9, // $CA
    #$C4#$96, // $CB
    #$C4#$A2, // $CC
    #$C4#$B6, // $CD
    #$C4#$AA, // $CE
    #$C4#$BB, // $CF
    #$C5#$A0, // $D0
    #$C5#$83, // $D1
    #$C5#$85, // $D2
    #$C3#$93, // $D3
    #$C5#$8C, // $D4
    #$C3#$95, // $D5
    #$C3#$96, // $D6
    #$C3#$97, // $D7
    #$C5#$B2, // $D8
    #$C5#$81, // $D9
    #$C5#$9A, // $DA
    #$C5#$AA, // $DB
    #$C3#$9C, // $DC
    #$C5#$BB, // $DD
    #$C5#$BD, // $DE
    #$C3#$9F, // $DF
    #$C4#$85, // $E0
    #$C4#$AF, // $E1
    #$C4#$81, // $E2
    #$C4#$87, // $E3
    #$C3#$A4, // $E4
    #$C3#$A5, // $E5
    #$C4#$99, // $E6
    #$C4#$93, // $E7
    #$C4#$8D, // $E8
    #$C3#$A9, // $E9
    #$C5#$BA, // $EA
    #$C4#$97, // $EB
    #$C4#$A3, // $EC
    #$C4#$B7, // $ED
    #$C4#$AB, // $EE
    #$C4#$BC, // $EF
    #$C5#$A1, // $F0
    #$C5#$84, // $F1
    #$C5#$86, // $F2
    #$C3#$B3, // $F3
    #$C5#$8D, // $F4
    #$C3#$B5, // $F5
    #$C3#$B6, // $F6
    #$C3#$B7, // $F7
    #$C5#$B3, // $F8
    #$C5#$82, // $F9
    #$C5#$9B, // $FA
    #$C5#$AB, // $FB
    #$C3#$BC, // $FC
    #$C5#$BC, // $FD
    #$C5#$BE, // $FE
    #$E2#$80#$99 // $FF
  );

  ArrayISO_8859_14ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #$C2#$80,           // #128
    #$C2#$81,           // #129
    #$C2#$82,           // #130
    #$C2#$83,           // #131
    #$C2#$84,           // #132
    #$C2#$85,           // #133
    #$C2#$86,           // #134
    #$C2#$87,           // #135
    #$C2#$88,           // #136
    #$C2#$89,           // #137
    #$C2#$8A,           // #138
    #$C2#$8B,           // #139
    #$C2#$8C,           // #140
    #$C2#$8D,           // #141
    #$C2#$8E,           // #142
    #$C2#$8F,           // #143
    #$C2#$90,           // #144
    #$C2#$91,           // #145
    #$C2#$92,           // #146
    #$C2#$93,           // #147
    #$C2#$94,           // #148
    #$C2#$95,           // #149
    #$C2#$96,           // #150
    #$C2#$97,           // #151
    #$C2#$98,           // #152
    #$C2#$99,           // #153
    #$C2#$9A,           // #154
    #$C2#$9B,           // #155
    #$C2#$9C,           // #156
    #$C2#$9D,           // #157
    #$C2#$9E,           // #158
    #$C2#$9F,           // #159
    #$C2#$A0,           // #160
    #$E1#$B8#$82,       // #161
    #$E1#$B8#$83,       // #162
    #$C2#$A3,           // #163
    #$C4#$8A,           // #164
    #$C4#$8B,           // #165
    #$E1#$B8#$8A,       // #166
    #$C2#$A7,           // #167
    #$E1#$BA#$80,       // #168
    #$C2#$A9,           // #169
    #$E1#$BA#$82,       // #170
    #$E1#$B8#$8B,       // #171
    #$E1#$BB#$B2,       // #172
    #$C2#$AD,           // #173
    #$C2#$AE,           // #174
    #$C5#$B8,           // #175
    #$E1#$B8#$9E,       // #176
    #$E1#$B8#$9F,       // #177
    #$C4#$A0,           // #178
    #$C4#$A1,           // #179
    #$E1#$B9#$80,       // #180
    #$E1#$B9#$81,       // #181
    #$C2#$B6,           // #182
    #$E1#$B9#$96,       // #183
    #$E1#$BA#$81,       // #184
    #$E1#$B9#$97,       // #185
    #$E1#$BA#$83,       // #186
    #$E1#$B9#$A0,       // #187
    #$E1#$BB#$B3,       // #188
    #$E1#$BA#$84,       // #189
    #$E1#$BA#$85,       // #190
    #$E1#$B9#$A1,       // #191
    #$C3#$80,           // #192
    #$C3#$81,           // #193
    #$C3#$82,           // #194
    #$C3#$83,           // #195
    #$C3#$84,           // #196
    #$C3#$85,           // #197
    #$C3#$86,           // #198
    #$C3#$87,           // #199
    #$C3#$88,           // #200
    #$C3#$89,           // #201
    #$C3#$8A,           // #202
    #$C3#$8B,           // #203
    #$C3#$8C,           // #204
    #$C3#$8D,           // #205
    #$C3#$8E,           // #206
    #$C3#$8F,           // #207
    #$C5#$B4,           // #208
    #$C3#$91,           // #209
    #$C3#$92,           // #210
    #$C3#$93,           // #211
    #$C3#$94,           // #212
    #$C3#$95,           // #213
    #$C3#$96,           // #214
    #$E1#$B9#$AA,       // #215
    #$C3#$98,           // #216
    #$C3#$99,           // #217
    #$C3#$9A,           // #218
    #$C3#$9B,           // #219
    #$C3#$9C,           // #220
    #$C3#$9D,           // #221
    #$C5#$B6,           // #222
    #$C3#$9F,           // #223
    #$C3#$A0,           // #224
    #$C3#$A1,           // #225
    #$C3#$A2,           // #226
    #$C3#$A3,           // #227
    #$C3#$A4,           // #228
    #$C3#$A5,           // #229
    #$C3#$A6,           // #230
    #$C3#$A7,           // #231
    #$C3#$A8,           // #232
    #$C3#$A9,           // #233
    #$C3#$AA,           // #234
    #$C3#$AB,           // #235
    #$C3#$AC,           // #236
    #$C3#$AD,           // #237
    #$C3#$AE,           // #238
    #$C3#$AF,           // #239
    #$C5#$B5,           // #240
    #$C3#$B1,           // #241
    #$C3#$B2,           // #242
    #$C3#$B3,           // #243
    #$C3#$B4,           // #244
    #$C3#$B5,           // #245
    #$C3#$B6,           // #246
    #$E1#$B9#$AB,       // #247
    #$C3#$B8,           // #248
    #$C3#$B9,           // #249
    #$C3#$BA,           // #250
    #$C3#$BB,           // #251
    #$C3#$BC,           // #252
    #$C3#$BD,           // #253
    #$C5#$B7,           // #254
    #$C3#$BF            // #255
  );

  ArrayISO_8859_15ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #194#161,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #226#130#172,       // #164
    #194#165,           // #165
    #197#160,           // #166
    #194#167,           // #167
    #197#161,           // #168
    #194#169,           // #169
    #194#170,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #194#175,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #197#189,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #197#190,           // #184
    #194#185,           // #185
    #194#186,           // #186
    #194#187,           // #187
    #197#146,           // #188
    #197#147,           // #189
    #197#184,           // #190
    #194#191,           // #191
    #195#128,           // #192
    #195#129,           // #193
    #195#130,           // #194
    #195#131,           // #195
    #195#132,           // #196
    #195#133,           // #197
    #195#134,           // #198
    #195#135,           // #199
    #195#136,           // #200
    #195#137,           // #201
    #195#138,           // #202
    #195#139,           // #203
    #195#140,           // #204
    #195#141,           // #205
    #195#142,           // #206
    #195#143,           // #207
    #195#144,           // #208
    #195#145,           // #209
    #195#146,           // #210
    #195#147,           // #211
    #195#148,           // #212
    #195#149,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #195#152,           // #216
    #195#153,           // #217
    #195#154,           // #218
    #195#155,           // #219
    #195#156,           // #220
    #195#157,           // #221
    #195#158,           // #222
    #195#159,           // #223
    #195#160,           // #224
    #195#161,           // #225
    #195#162,           // #226
    #195#163,           // #227
    #195#164,           // #228
    #195#165,           // #229
    #195#166,           // #230
    #195#167,           // #231
    #195#168,           // #232
    #195#169,           // #233
    #195#170,           // #234
    #195#171,           // #235
    #195#172,           // #236
    #195#173,           // #237
    #195#174,           // #238
    #195#175,           // #239
    #195#176,           // #240
    #195#177,           // #241
    #195#178,           // #242
    #195#179,           // #243
    #195#180,           // #244
    #195#181,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #195#184,           // #248
    #195#185,           // #249
    #195#186,           // #250
    #195#187,           // #251
    #195#188,           // #252
    #195#189,           // #253
    #195#190,           // #254
    #195#191            // #255
  );

  ArrayISO_8859_16ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #$C4#$84,           // #$A1
    #$C4#$85,           // #$A2
    #$C5#$81,           // #$A3
    #$E2#$82#$AC,       // #$A4
    #$E2#$80#$9E,       // #$A5
    #$C5#$A0,           // #$A6
    #$C2#$A7,           // #$A7
    #$C5#$A1,           // #$A8
    #$C2#$A9,           // #$A9
    #$C8#$98,           // #$AA
    #$C2#$AB,           // #$AB
    #$C5#$B9,           // #$AC
    #$C2#$AD,           // #$AD
    #$C5#$BA,           // #$AE
    #$C5#$BB,           // #$AF
    #$C2#$B0,           // #$B0
    #$C2#$B1,           // #$B1
    #$C4#$8C,           // #$B2
    #$C5#$82,           // #$B3
    #$C5#$BD,           // #$B4
    #$E2#$80#$9D,       // #$B5
    #$C2#$B6,           // #$B6
    #$C2#$B7,           // #$B7
    #$C5#$BE,           // #$B8
    #$C4#$8D,           // #$B9
    #$C8#$99,           // #$BA
    #$C2#$BB,           // #$BB
    #$C5#$92,           // #$BC
    #$C5#$93,           // #$BD
    #$C5#$B8,           // #$BE
    #$C5#$BC,           // #$BF
    #$C3#$80,           // #$C0
    #$C3#$81,           // #$C1
    #$C3#$82,           // #$C2
    #$C4#$82,           // #$C3
    #$C3#$84,           // #$C4
    #$C4#$86,           // #$C5
    #$C3#$86,           // #$C6
    #$C3#$87,           // #$C7
    #$C3#$88,           // #$C8
    #$C3#$89,           // #$C9
    #$C3#$8A,           // #$CA
    #$C3#$8B,           // #$CB
    #$C3#$8C,           // #$CC
    #$C3#$8D,           // #$CD
    #$C3#$8E,           // #$CE
    #$C3#$8F,           // #$CF
    #$C4#$90,           // #$D0
    #$C5#$83,           // #$D1
    #$C3#$92,           // #$D2
    #$C3#$93,           // #$D3
    #$C3#$94,           // #$D4
    #$C5#$90,           // #$D5
    #$C3#$96,           // #$D6
    #$C5#$9A,           // #$D7
    #$C5#$B0,           // #$D8
    #$C3#$99,           // #$D9
    #$C3#$9A,           // #$DA
    #$C3#$9B,           // #$DB
    #$C3#$9C,           // #$DC
    #$C4#$98,           // #$DD
    #$C8#$9A,           // #$DE
    #$C3#$9F,           // #$DF
    #$C3#$A0,           // #$E0
    #$C3#$A1,           // #$E1
    #$C3#$A2,           // #$E2
    #$C4#$83,           // #$E3
    #$C3#$A4,           // #$E4
    #$C4#$87,           // #$E5
    #$C3#$A6,           // #$E6
    #$C3#$A7,           // #$E7
    #$C3#$A8,           // #$E8
    #$C3#$A9,           // #$E9
    #$C3#$AA,           // #$EA
    #$C3#$AB,           // #$EB
    #$C3#$AC,           // #$EC
    #$C3#$AD,           // #$ED
    #$C3#$AE,           // #$EE
    #$C3#$AF,           // #$EF
    #$C4#$91,           // #$F0
    #$C5#$84,           // #$F1
    #$C3#$B2,           // #$F2
    #$C3#$B3,           // #$F3
    #$C3#$B4,           // #$F4
    #$C5#$91,           // #$F5
    #$C3#$B6,           // #$F6
    #$C5#$9B,           // #$F7
    #$C5#$B1,           // #$F8
    #$C3#$B9,           // #$F9
    #$C3#$BA,           // #$FA
    #$C3#$BB,           // #$FB
    #$C3#$BC,           // #$FC
    #$C4#$99,           // #$FD
    #$C8#$9B,           // #$FE
    #$C3#$BF            // #$FF
    );

  ArrayISO_8859_2ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #196#132,           // #161
    #203#152,           // #162
    #197#129,           // #163
    #194#164,           // #164
    #196#189,           // #165
    #197#154,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #197#160,           // #169
    #197#158,           // #170
    #197#164,           // #171
    #197#185,           // #172
    #194#173,           // #173
    #197#189,           // #174
    #197#187,           // #175
    #194#176,           // #176
    #196#133,           // #177
    #203#155,           // #178
    #197#130,           // #179
    #194#180,           // #180
    #196#190,           // #181
    #197#155,           // #182
    #203#135,           // #183
    #194#184,           // #184
    #197#161,           // #185
    #197#159,           // #186
    #197#165,           // #187
    #197#186,           // #188
    #203#157,           // #189
    #197#190,           // #190
    #197#188,           // #191
    #197#148,           // #192
    #195#129,           // #193
    #195#130,           // #194
    #196#130,           // #195
    #195#132,           // #196
    #196#185,           // #197
    #196#134,           // #198
    #195#135,           // #199
    #196#140,           // #200
    #195#137,           // #201
    #196#152,           // #202
    #195#139,           // #203
    #196#154,           // #204
    #195#141,           // #205
    #195#142,           // #206
    #196#142,           // #207
    #196#144,           // #208
    #197#131,           // #209
    #197#135,           // #210
    #195#147,           // #211
    #195#148,           // #212
    #197#144,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #197#152,           // #216
    #197#174,           // #217
    #195#154,           // #218
    #197#176,           // #219
    #195#156,           // #220
    #195#157,           // #221
    #197#162,           // #222
    #195#159,           // #223
    #197#149,           // #224
    #195#161,           // #225
    #195#162,           // #226
    #196#131,           // #227
    #195#164,           // #228
    #196#186,           // #229
    #196#135,           // #230
    #195#167,           // #231
    #196#141,           // #232
    #195#169,           // #233
    #196#153,           // #234
    #195#171,           // #235
    #196#155,           // #236
    #195#173,           // #237
    #195#174,           // #238
    #196#143,           // #239
    #196#145,           // #240
    #197#132,           // #241
    #197#136,           // #242
    #195#179,           // #243
    #195#180,           // #244
    #197#145,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #197#153,           // #248
    #197#175,           // #249
    #195#186,           // #250
    #197#177,           // #251
    #195#188,           // #252
    #195#189,           // #253
    #197#163,           // #254
    #203#153            // #255
  );

  ArrayISO_8859_3ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #$C2#$A0, // $A0
    #$C4#$A6, // $A1
    #$CB#$98, // $A2
    #$C2#$A3, // $A3
    #$C2#$A4, // $A4
    #$C2#$A5, // $A5
    #$C4#$A4, // $A6
    #$C2#$A7, // $A7
    #$C2#$A8, // $A8
    #$C4#$B0, // $A9
    #$C5#$9E, // $AA
    #$C4#$9E, // $AB
    #$C4#$B4, // $AC
    #$C2#$AD, // $AD
    #$C2#$AE, // $AE
    #$C5#$BB, // $AF
    #$C2#$B0, // $B0
    #$C4#$A7, // $B1
    #$C2#$B2, // $B2
    #$C2#$B3, // $B3
    #$C2#$B4, // $B4
    #$C2#$B5, // $B5
    #$C4#$A5, // $B6
    #$C2#$B7, // $B7
    #$C2#$B8, // $B8
    #$C4#$B1, // $B9
    #$C5#$9F, // $BA
    #$C4#$9F, // $BB
    #$C4#$B5, // $BC
    #$C2#$BD, // $BD
    #$C2#$BE, // $BE
    #$C5#$BC, // $BF
    #$C3#$80, // $C0
    #$C3#$81, // $C1
    #$C3#$82, // $C2
    #$C3#$83, // $C3
    #$C3#$84, // $C4
    #$C4#$8A, // $C5
    #$C4#$88, // $C6
    #$C3#$87, // $C7
    #$C3#$88, // $C8
    #$C3#$89, // $C9
    #$C3#$8A, // $CA
    #$C3#$8B, // $CB
    #$C3#$8C, // $CC
    #$C3#$8D, // $CD
    #$C3#$8E, // $CE
    #$C3#$8F, // $CF
    #$C3#$90, // $D0
    #$C3#$91, // $D1
    #$C3#$92, // $D2
    #$C3#$93, // $D3
    #$C3#$94, // $D4
    #$C4#$A0, // $D5
    #$C3#$96, // $D6
    #$C3#$97, // $D7
    #$C4#$9C, // $D8
    #$C3#$99, // $D9
    #$C3#$9A, // $DA
    #$C3#$9B, // $DB
    #$C3#$9C, // $DC
    #$C5#$AC, // $DD
    #$C5#$9C, // $DE
    #$C3#$9F, // $DF
    #$C3#$A0, // $E0
    #$C3#$A1, // $E1
    #$C3#$A2, // $E2
    #$C3#$A3, // $E3
    #$C3#$A4, // $E4
    #$C4#$8B, // $E5
    #$C4#$89, // $E6
    #$C3#$A7, // $E7
    #$C3#$A8, // $E8
    #$C3#$A9, // $E9
    #$C3#$AA, // $EA
    #$C3#$AB, // $EB
    #$C3#$AC, // $EC
    #$C3#$AD, // $ED
    #$C3#$AE, // $EE
    #$C3#$AF, // $EF
    #$C3#$B0, // $F0
    #$C3#$B1, // $F1
    #$C3#$B2, // $F2
    #$C3#$B3, // $F3
    #$C3#$B4, // $F4
    #$C4#$A1, // $F5
    #$C3#$B6, // $F6
    #$C3#$B7, // $F7
    #$C4#$9D, // $F8
    #$C3#$B9, // $F9
    #$C3#$BA, // $FA
    #$C3#$BB, // $FB
    #$C3#$BC, // $FC
    #$C5#$AD, // $FD
    #$C5#$9D, // $FE
    #$CB#$99 // $FF
  );

  ArrayISO_8859_4ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #$C2#$A0, // $A0
    #$C4#$84, // $A1
    #$C4#$B8, // $A2
    #$C5#$96, // $A3
    #$C2#$A4, // $A4
    #$C4#$A8, // $A5
    #$C4#$BB, // $A6
    #$C2#$A7, // $A7
    #$C2#$A8, // $A8
    #$C5#$A0, // $A9
    #$C4#$92, // $AA
    #$C4#$A2, // $AB
    #$C5#$A6, // $AC
    #$C2#$AD, // $AD
    #$C5#$BD, // $AE
    #$C2#$AF, // $AF
    #$C2#$B0, // $B0
    #$C4#$85, // $B1
    #$CB#$9B, // $B2
    #$C5#$97, // $B3
    #$C2#$B4, // $B4
    #$C4#$A9, // $B5
    #$C4#$BC, // $B6
    #$CB#$87, // $B7
    #$C2#$B8, // $B8
    #$C5#$A1, // $B9
    #$C4#$93, // $BA
    #$C4#$A3, // $BB
    #$C5#$A7, // $BC
    #$C5#$8A, // $BD
    #$C5#$BE, // $BE
    #$C5#$8B, // $BF
    #$C4#$80, // $C0
    #$C3#$81, // $C1
    #$C3#$82, // $C2
    #$C3#$83, // $C3
    #$C3#$84, // $C4
    #$C3#$85, // $C5
    #$C3#$86, // $C6
    #$C4#$AE, // $C7
    #$C4#$8C, // $C8
    #$C3#$89, // $C9
    #$C4#$98, // $CA
    #$C3#$8B, // $CB
    #$C4#$96, // $CC
    #$C3#$8D, // $CD
    #$C3#$8E, // $CE
    #$C4#$AA, // $CF
    #$C4#$90, // $D0
    #$C5#$85, // $D1
    #$C5#$8C, // $D2
    #$C4#$B6, // $D3
    #$C3#$94, // $D4
    #$C3#$95, // $D5
    #$C3#$96, // $D6
    #$C3#$97, // $D7
    #$C3#$98, // $D8
    #$C5#$B2, // $D9
    #$C3#$9A, // $DA
    #$C3#$9B, // $DB
    #$C3#$9C, // $DC
    #$C5#$A8, // $DD
    #$C5#$AA, // $DE
    #$C3#$9F, // $DF
    #$C4#$81, // $E0
    #$C3#$A1, // $E1
    #$C3#$A2, // $E2
    #$C3#$A3, // $E3
    #$C3#$A4, // $E4
    #$C3#$A5, // $E5
    #$C3#$A6, // $E6
    #$C4#$AF, // $E7
    #$C4#$8D, // $E8
    #$C3#$A9, // $E9
    #$C4#$99, // $EA
    #$C3#$AB, // $EB
    #$C4#$97, // $EC
    #$C3#$AD, // $ED
    #$C3#$AE, // $EE
    #$C4#$AB, // $EF
    #$C4#$91, // $F0
    #$C5#$86, // $F1
    #$C5#$8D, // $F2
    #$C4#$B7, // $F3
    #$C3#$B4, // $F4
    #$C3#$B5, // $F5
    #$C3#$B6, // $F6
    #$C3#$B7, // $F7
    #$C3#$B8, // $F8
    #$C5#$B3, // $F9
    #$C3#$BA, // $FA
    #$C3#$BB, // $FB
    #$C3#$BC, // $FC
    #$C5#$A9, // $FD
    #$C5#$AB, // $FE
    #$CB#$99 // $FF
  );

  ArrayISO_8859_5ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #$C2#$A0,           // $A0
    #$D0#$81,           // $A1
    #$D0#$82,           // $A2
    #$D0#$83,           // $A3
    #$D0#$84,           // $A4
    #$D0#$85,           // $A5
    #$D0#$86,           // $A6
    #$D0#$87,           // $A7
    #$D0#$88,           // $A8
    #$D0#$89,           // $A9
    #$D0#$8A,           // $AA
    #$D0#$8B,           // $AB
    #$D0#$8C,           // $AC
    #$C2#$AD,           // $AD
    #$D0#$8E,           // $AE
    #$D0#$8F,           // $AF
    #$D0#$90,           // $B0
    #$D0#$91,           // $B1
    #$D0#$92,           // $B2
    #$D0#$93,           // $B3
    #$D0#$94,           // $B4
    #$D0#$95,           // $B5
    #$D0#$96,           // $B6
    #$D0#$97,           // $B7
    #$D0#$98,           // $B8
    #$D0#$99,           // $B9
    #$D0#$9A,           // $BA
    #$D0#$9B,           // $BB
    #$D0#$9C,           // $BC
    #$D0#$9D,           // $BD
    #$D0#$9E,           // $BE
    #$D0#$9F,           // $BF
    #$D0#$A0,           // $C0
    #$D0#$A1,           // $C1
    #$D0#$A2,           // $C2
    #$D0#$A3,           // $C3
    #$D0#$A4,           // $C4
    #$D0#$A5,           // $C5
    #$D0#$A6,           // $C6
    #$D0#$A7,           // $C7
    #$D0#$A8,           // $C8
    #$D0#$A9,           // $C9
    #$D0#$AA,           // $CA
    #$D0#$AB,           // $CB
    #$D0#$AC,           // $CC
    #$D0#$AD,           // $CD
    #$D0#$AE,           // $CE
    #$D0#$AF,           // $CF
    #$D0#$B0,           // $D0
    #$D0#$B1,           // $D1
    #$D0#$B2,           // $D2
    #$D0#$B3,           // $D3
    #$D0#$B4,           // $D4
    #$D0#$B5,           // $D5
    #$D0#$B6,           // $D6
    #$D0#$B7,           // $D7
    #$D0#$B8,           // $D8
    #$D0#$B9,           // $D9
    #$D0#$BA,           // $DA
    #$D0#$BB,           // $DB
    #$D0#$BC,           // $DC
    #$D0#$BD,           // $DD
    #$D0#$BE,           // $DE
    #$D0#$BF,           // $DF
    #$D1#$80,           // $E0
    #$D1#$81,           // $E1
    #$D1#$82,           // $E2
    #$D1#$83,           // $E3
    #$D1#$84,           // $E4
    #$D1#$85,           // $E5
    #$D1#$86,           // $E6
    #$D1#$87,           // $E7
    #$D1#$88,           // $E8
    #$D1#$89,           // $E9
    #$D1#$8A,           // $EA
    #$D1#$8B,           // $EB
    #$D1#$8C,           // $EC
    #$D1#$8D,           // $ED
    #$D1#$8E,           // $EE
    #$D1#$8F,           // $EF
    #$E2#$84#$96,       // $F0
    #$D1#$91,           // $F1
    #$D1#$92,           // $F2
    #$D1#$93,           // $F3
    #$D1#$94,           // $F4
    #$D1#$95,           // $F5
    #$D1#$96,           // $F6
    #$D1#$97,           // $F7
    #$D1#$98,           // $F8
    #$D1#$99,           // $F9
    #$D1#$9A,           // $FA
    #$D1#$9B,           // $FB
    #$D1#$9C,           // $FC
    #$C2#$A7,           // $FD
    #$D1#$9E,           // $FE
    #$D1#$9F            // $FF
    );

  ArrayISO_8859_7ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #194#128,           // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #194#133,           // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #194#145,           // #145
    #194#146,           // #146
    #194#147,           // #147
    #194#148,           // #148
    #194#149,           // #149
    #194#150,           // #150
    #194#151,           // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #$C2#$A0, // $A0
    #$CA#$BD, // $A1
    #$CA#$BC, // $A2
    #$C2#$A3, // $A3
    #$E2#$82#$AC, // $A4
    #$E2#$82#$AF, // $A5
    #$C2#$A6, // $A6
    #$C2#$A7, // $A7
    #$C2#$A8, // $A8
    #$C2#$A9, // $A9
    #$CD#$BA, // $AA
    #$C2#$AB, // $AB
    #$C2#$AC, // $AC
    #$C2#$AD, // $AD
    #$C2#$AE, // $AE
    #$E2#$80#$95, // $AF
    #$C2#$B0, // $B0
    #$C2#$B1, // $B1
    #$C2#$B2, // $B2
    #$C2#$B3, // $B3
    #$CE#$84, // $B4
    #$CE#$85, // $B5
    #$CE#$86, // $B6
    #$C2#$B7, // $B7
    #$CE#$88, // $B8
    #$CE#$89, // $B9
    #$CE#$8A, // $BA
    #$C2#$BB, // $BB
    #$CE#$8C, // $BC
    #$C2#$BD, // $BD
    #$CE#$8E, // $BE
    #$CE#$8F, // $BF
    #$CE#$90, // $C0
    #$CE#$91, // $C1
    #$CE#$92, // $C2
    #$CE#$93, // $C3
    #$CE#$94, // $C4
    #$CE#$95, // $C5
    #$CE#$96, // $C6
    #$CE#$97, // $C7
    #$CE#$98, // $C8
    #$CE#$99, // $C9
    #$CE#$9A, // $CA
    #$CE#$9B, // $CB
    #$CE#$9C, // $CC
    #$CE#$9D, // $CD
    #$CE#$9E, // $CE
    #$CE#$9F, // $CF
    #$CE#$A0, // $D0
    #$CE#$A1, // $D1
    #$C3#$92, // $D2
    #$CE#$A3, // $D3
    #$CE#$A4, // $D4
    #$CE#$A5, // $D5
    #$CE#$A6, // $D6
    #$CE#$A7, // $D7
    #$CE#$A8, // $D8
    #$CE#$A9, // $D9
    #$CE#$AA, // $DA
    #$CE#$AB, // $DB
    #$CE#$AC, // $DC
    #$CE#$AD, // $DD
    #$CE#$AE, // $DE
    #$CE#$AF, // $DF
    #$CE#$B0, // $E0
    #$CE#$B1, // $E1
    #$CE#$B2, // $E2
    #$CE#$B3, // $E3
    #$CE#$B4, // $E4
    #$CE#$B5, // $E5
    #$CE#$B6, // $E6
    #$CE#$B7, // $E7
    #$CE#$B8, // $E8
    #$CE#$B9, // $E9
    #$CE#$BA, // $EA
    #$CE#$BB, // $EB
    #$CE#$BC, // $EC
    #$CE#$BD, // $ED
    #$CE#$BE, // $EE
    #$CE#$BF, // $EF
    #$CF#$80, // $F0
    #$CF#$81, // $F1
    #$CF#$82, // $F2
    #$CF#$83, // $F3
    #$CF#$84, // $F4
    #$CF#$85, // $F5
    #$CF#$86, // $F6
    #$CF#$87, // $F7
    #$CF#$88, // $F8
    #$CF#$89, // $F9
    #$CF#$8A, // $FA
    #$CF#$8B, // $FB
    #$CF#$8C, // $FC
    #$CF#$8D, // $FD
    #$CF#$8E, // $FE
    #$C3#$BF // $FF
  );

  ArrayCP1250ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #194#129,           // #129
    #226#128#154,       // #130
    #194#131,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #194#136,           // #136
    #226#128#176,       // #137
    #197#160,           // #138
    #226#128#185,       // #139
    #197#154,           // #140
    #197#164,           // #141
    #197#189,           // #142
    #197#185,           // #143
    #194#144,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #194#152,           // #152
    #226#132#162,       // #153
    #197#161,           // #154
    #226#128#186,       // #155
    #197#155,           // #156
    #197#165,           // #157
    #197#190,           // #158
    #197#186,           // #159
    #194#160,           // #160
    #203#135,           // #161
    #203#152,           // #162
    #197#129,           // #163
    #194#164,           // #164
    #196#132,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #197#158,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #197#187,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #203#155,           // #178
    #197#130,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #194#184,           // #184
    #196#133,           // #185
    #197#159,           // #186
    #194#187,           // #187
    #196#189,           // #188
    #203#157,           // #189
    #196#190,           // #190
    #197#188,           // #191
    #197#148,           // #192
    #195#129,           // #193
    #195#130,           // #194
    #196#130,           // #195
    #195#132,           // #196
    #196#185,           // #197
    #196#134,           // #198
    #195#135,           // #199
    #196#140,           // #200
    #195#137,           // #201
    #196#152,           // #202
    #195#139,           // #203
    #196#154,           // #204
    #195#141,           // #205
    #195#142,           // #206
    #196#142,           // #207
    #196#144,           // #208
    #197#131,           // #209
    #197#135,           // #210
    #195#147,           // #211
    #195#148,           // #212
    #197#144,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #197#152,           // #216
    #197#174,           // #217
    #195#154,           // #218
    #197#176,           // #219
    #195#156,           // #220
    #195#157,           // #221
    #197#162,           // #222
    #195#159,           // #223
    #197#149,           // #224
    #195#161,           // #225
    #195#162,           // #226
    #196#131,           // #227
    #195#164,           // #228
    #196#186,           // #229
    #196#135,           // #230
    #195#167,           // #231
    #196#141,           // #232
    #195#169,           // #233
    #196#153,           // #234
    #195#171,           // #235
    #196#155,           // #236
    #195#173,           // #237
    #195#174,           // #238
    #196#143,           // #239
    #196#145,           // #240
    #197#132,           // #241
    #197#136,           // #242
    #195#179,           // #243
    #195#180,           // #244
    #197#145,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #197#153,           // #248
    #197#175,           // #249
    #195#186,           // #250
    #197#177,           // #251
    #195#188,           // #252
    #195#189,           // #253
    #197#163,           // #254
    #203#153            // #255
  );

  ArrayCP1251ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #208#130,           // #128
    #208#131,           // #129
    #226#128#154,       // #130
    #209#147,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #226#130#172,       // #136
    #226#128#176,       // #137
    #208#137,           // #138
    #226#128#185,       // #139
    #208#138,           // #140
    #208#140,           // #141
    #208#139,           // #142
    #208#143,           // #143
    #209#146,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #194#152,           // #152
    #226#132#162,       // #153
    #209#153,           // #154
    #226#128#186,       // #155
    #209#154,           // #156
    #209#156,           // #157
    #209#155,           // #158
    #209#159,           // #159
    #194#160,           // #160
    #208#142,           // #161
    #209#158,           // #162
    #208#136,           // #163
    #194#164,           // #164
    #210#144,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #208#129,           // #168
    #194#169,           // #169
    #208#132,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #208#135,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #208#134,           // #178
    #209#150,           // #179
    #210#145,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #209#145,           // #184
    #226#132#150,       // #185
    #209#148,           // #186
    #194#187,           // #187
    #209#152,           // #188
    #208#133,           // #189
    #209#149,           // #190
    #209#151,           // #191
    #208#144,           // #192
    #208#145,           // #193
    #208#146,           // #194
    #208#147,           // #195
    #208#148,           // #196
    #208#149,           // #197
    #208#150,           // #198
    #208#151,           // #199
    #208#152,           // #200
    #208#153,           // #201
    #208#154,           // #202
    #208#155,           // #203
    #208#156,           // #204
    #208#157,           // #205
    #208#158,           // #206
    #208#159,           // #207
    #208#160,           // #208
    #208#161,           // #209
    #208#162,           // #210
    #208#163,           // #211
    #208#164,           // #212
    #208#165,           // #213
    #208#166,           // #214
    #208#167,           // #215
    #208#168,           // #216
    #208#169,           // #217
    #208#170,           // #218
    #208#171,           // #219
    #208#172,           // #220
    #208#173,           // #221
    #208#174,           // #222
    #208#175,           // #223
    #208#176,           // #224
    #208#177,           // #225
    #208#178,           // #226
    #208#179,           // #227
    #208#180,           // #228
    #208#181,           // #229
    #208#182,           // #230
    #208#183,           // #231
    #208#184,           // #232
    #208#185,           // #233
    #208#186,           // #234
    #208#187,           // #235
    #208#188,           // #236
    #208#189,           // #237
    #208#190,           // #238
    #208#191,           // #239
    #209#128,           // #240
    #209#129,           // #241
    #209#130,           // #242
    #209#131,           // #243
    #209#132,           // #244
    #209#133,           // #245
    #209#134,           // #246
    #209#135,           // #247
    #209#136,           // #248
    #209#137,           // #249
    #209#138,           // #250
    #209#139,           // #251
    #209#140,           // #252
    #209#141,           // #253
    #209#142,           // #254
    #209#143            // #255
  );

  ArrayCP1252ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #194#129,           // #129
    #226#128#154,       // #130
    #198#146,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #203#134,           // #136
    #226#128#176,       // #137
    #197#160,           // #138
    #226#128#185,       // #139
    #197#146,           // #140
    #194#141,           // #141
    #197#189,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #203#156,           // #152
    #226#132#162,       // #153
    #197#161,           // #154
    #226#128#186,       // #155
    #197#147,           // #156
    #194#157,           // #157
    #197#190,           // #158
    #197#184,           // #159
    #194#160,           // #160
    #194#161,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #194#164,           // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #194#170,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #194#175,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #194#184,           // #184
    #194#185,           // #185
    #194#186,           // #186
    #194#187,           // #187
    #194#188,           // #188
    #194#189,           // #189
    #194#190,           // #190
    #194#191,           // #191
    #195#128,           // #192
    #195#129,           // #193
    #195#130,           // #194
    #195#131,           // #195
    #195#132,           // #196
    #195#133,           // #197
    #195#134,           // #198
    #195#135,           // #199
    #195#136,           // #200
    #195#137,           // #201
    #195#138,           // #202
    #195#139,           // #203
    #195#140,           // #204
    #195#141,           // #205
    #195#142,           // #206
    #195#143,           // #207
    #195#144,           // #208
    #195#145,           // #209
    #195#146,           // #210
    #195#147,           // #211
    #195#148,           // #212
    #195#149,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #195#152,           // #216
    #195#153,           // #217
    #195#154,           // #218
    #195#155,           // #219
    #195#156,           // #220
    #195#157,           // #221
    #195#158,           // #222
    #195#159,           // #223
    #195#160,           // #224
    #195#161,           // #225
    #195#162,           // #226
    #195#163,           // #227
    #195#164,           // #228
    #195#165,           // #229
    #195#166,           // #230
    #195#167,           // #231
    #195#168,           // #232
    #195#169,           // #233
    #195#170,           // #234
    #195#171,           // #235
    #195#172,           // #236
    #195#173,           // #237
    #195#174,           // #238
    #195#175,           // #239
    #195#176,           // #240
    #195#177,           // #241
    #195#178,           // #242
    #195#179,           // #243
    #195#180,           // #244
    #195#181,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #195#184,           // #248
    #195#185,           // #249
    #195#186,           // #250
    #195#187,           // #251
    #195#188,           // #252
    #195#189,           // #253
    #195#190,           // #254
    #195#191            // #255
  );

  ArrayCP1253ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #194#129,           // #129
    #226#128#154,       // #130
    #198#146,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #194#136,           // #136
    #226#128#176,       // #137
    #194#138,           // #138
    #226#128#185,       // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #194#152,            // #152
    #226#132#162,       // #153
    #194#154,           // #154
    #226#128#186,       // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #206#133,           // #161
    #206#134,           // #162
    #194#163,           // #163
    #194#164,           // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #194#170,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #226#128#149,       // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #206#132,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #206#136,           // #184
    #206#137,           // #185
    #206#138,           // #186
    #194#187,           // #187
    #206#140,           // #188
    #194#189,           // #189
    #206#142,           // #190
    #206#143,           // #191
    #206#144,           // #192
    #206#145,           // #193
    #206#146,           // #194
    #206#147,           // #195
    #206#148,           // #196
    #206#149,           // #197
    #206#150,           // #198
    #206#151,           // #199
    #206#152,           // #200
    #206#153,           // #201
    #206#154,           // #202
    #206#155,           // #203
    #206#156,           // #204
    #206#157,           // #205
    #206#158,           // #206
    #206#159,           // #207
    #206#160,           // #208
    #206#161,           // #209
    #206#162,           // #210
    #206#163,           // #211
    #206#164,           // #212
    #206#165,           // #213
    #206#166,           // #214
    #206#167,           // #215
    #206#168,           // #216
    #206#169,           // #217
    #206#170,           // #218
    #206#171,           // #219
    #206#172,           // #220
    #206#173,           // #221
    #206#174,           // #222
    #206#175,           // #223
    #206#176,           // #224
    #206#177,           // #225
    #206#178,           // #226
    #206#179,           // #227
    #206#180,           // #228
    #206#181,           // #229
    #206#182,           // #230
    #206#183,           // #231
    #206#184,           // #232
    #206#185,           // #233
    #206#186,           // #234
    #206#187,           // #235
    #206#188,           // #236
    #206#189,           // #237
    #206#190,           // #238
    #206#191,           // #239
    #207#128,           // #240
    #207#129,           // #241
    #207#130,           // #242
    #207#131,           // #243
    #207#132,           // #244
    #207#133,           // #245
    #207#134,           // #246
    #207#135,           // #247
    #207#136,           // #248
    #207#137,           // #249
    #207#138,           // #250
    #207#139,           // #251
    #207#140,           // #252
    #207#141,           // #253
    #207#142,           // #254
    #207#143            // #255
  );

  ArrayCP1254ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #194#129,           // #129
    #226#128#154,       // #130
    #198#146,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #203#134,           // #136
    #226#128#176,       // #137
    #197#160,           // #138
    #226#128#185,       // #139
    #197#146,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #203#156,           // #152
    #226#132#162,       // #153
    #197#161,           // #154
    #226#128#186,       // #155
    #197#147,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #197#184,           // #159
    #194#160,           // #160
    #194#161,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #194#164,           // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #194#170,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #194#175,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #194#184,           // #184
    #194#185,           // #185
    #194#186,           // #186
    #194#187,           // #187
    #194#188,           // #188
    #194#189,           // #189
    #194#190,           // #190
    #194#191,           // #191
    #195#128,           // #192
    #195#129,           // #193
    #195#130,           // #194
    #195#131,           // #195
    #195#132,           // #196
    #195#133,           // #197
    #195#134,           // #198
    #195#135,           // #199
    #195#136,           // #200
    #195#137,           // #201
    #195#138,           // #202
    #195#139,           // #203
    #195#140,           // #204
    #195#141,           // #205
    #195#142,           // #206
    #195#143,           // #207
    #196#158,           // #208
    #195#145,           // #209
    #195#146,           // #210
    #195#147,           // #211
    #195#148,           // #212
    #195#149,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #195#152,           // #216
    #195#153,           // #217
    #195#154,           // #218
    #195#155,           // #219
    #195#156,           // #220
    #196#176,           // #221
    #197#158,           // #222
    #195#159,           // #223
    #195#160,           // #224
    #195#161,           // #225
    #195#162,           // #226
    #195#163,           // #227
    #195#164,           // #228
    #195#165,           // #229
    #195#166,           // #230
    #195#167,           // #231
    #195#168,           // #232
    #195#169,           // #233
    #195#170,           // #234
    #195#171,           // #235
    #195#172,           // #236
    #195#173,           // #237
    #195#174,           // #238
    #195#175,           // #239
    #196#159,           // #240
    #195#177,           // #241
    #195#178,           // #242
    #195#179,           // #243
    #195#180,           // #244
    #195#181,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #195#184,           // #248
    #195#185,           // #249
    #195#186,           // #250
    #195#187,           // #251
    #195#188,           // #252
    #196#177,           // #253
    #197#159,           // #254
    #195#191            // #255
  );

  ArrayCP1255ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #194#129,           // #129
    #226#128#154,       // #130
    #198#146,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #203#134,           // #136
    #226#128#176,       // #137
    #194#138,           // #138
    #226#128#185,       // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #203#156,           // #152
    #226#132#162,       // #153
    #194#154,           // #154
    #226#128#186,       // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #194#161,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #226#130#170,       // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #195#151,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #194#175,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #194#184,           // #184
    #194#185,           // #185
    #195#183,           // #186
    #194#187,           // #187
    #194#188,           // #188
    #194#189,           // #189
    #194#190,           // #190
    #194#191,           // #191
    #214#176,           // #192
    #214#177,           // #193
    #214#178,           // #194
    #214#179,           // #195
    #214#180,           // #196
    #214#181,           // #197
    #214#182,           // #198
    #214#183,           // #199
    #214#184,           // #200
    #214#185,           // #201
    #214#186,           // #202
    #214#187,           // #203
    #214#188,           // #204
    #214#189,           // #205
    #214#190,           // #206
    #214#191,           // #207
    #215#128,           // #208
    #215#129,           // #209
    #215#130,           // #210
    #215#131,           // #211
    #215#176,           // #212
    #215#177,           // #213
    #215#178,           // #214
    #215#179,           // #215
    #215#180,           // #216
    #215#181,           // #217
    #215#182,           // #218
    #215#183,           // #219
    #215#184,           // #220
    #215#185,           // #221
    #215#186,           // #222
    #215#187,           // #223
    #215#144,           // #224
    #215#145,           // #225
    #215#146,           // #226
    #215#147,           // #227
    #215#148,           // #228
    #215#149,           // #229
    #215#150,           // #230
    #215#151,           // #231
    #215#152,           // #232
    #215#153,           // #233
    #215#154,           // #234
    #215#155,           // #235
    #215#156,           // #236
    #215#157,           // #237
    #215#158,           // #238
    #215#159,           // #239
    #215#160,           // #240
    #215#161,           // #241
    #215#162,           // #242
    #215#163,           // #243
    #215#164,           // #244
    #215#165,           // #245
    #215#166,           // #246
    #215#167,           // #247
    #215#168,           // #248
    #215#169,           // #249
    #215#170,           // #250
    #215#171,           // #251
    #215#172,           // #252
    #226#128#142,       // #253
    #226#128#143,       // #254
    #215#173            // #255
  );

  ArrayCP1256ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #217#190,           // #129
    #226#128#154,       // #130
    #198#146,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #203#134,           // #136
    #226#128#176,       // #137
    #217#185,           // #138
    #226#128#185,       // #139
    #197#146,           // #140
    #218#134,           // #141
    #218#152,           // #142
    #218#136,           // #143
    #218#175,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #218#169,           // #152
    #226#132#162,       // #153
    #218#145,           // #154
    #226#128#186,       // #155
    #197#147,           // #156
    #226#128#140,       // #157
    #226#128#141,       // #158
    #218#186,           // #159
    #194#160,           // #160
    #216#140,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #194#164,           // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #194#168,           // #168
    #194#169,           // #169
    #218#190,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #194#175,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #194#184,           // #184
    #194#185,           // #185
    #216#155,           // #186
    #194#187,           // #187
    #194#188,           // #188
    #194#189,           // #189
    #194#190,           // #190
    #216#159,           // #191
    #219#129,           // #192
    #216#161,           // #193
    #216#162,           // #194
    #216#163,           // #195
    #216#164,           // #196
    #216#165,           // #197
    #216#166,           // #198
    #216#167,           // #199
    #216#168,           // #200
    #216#169,           // #201
    #216#170,           // #202
    #216#171,           // #203
    #216#172,           // #204
    #216#173,           // #205
    #216#174,           // #206
    #216#175,           // #207
    #216#176,           // #208
    #216#177,           // #209
    #216#178,           // #210
    #216#179,           // #211
    #216#180,           // #212
    #216#181,           // #213
    #216#182,           // #214
    #195#151,           // #215
    #216#183,           // #216
    #216#184,           // #217
    #216#185,           // #218
    #216#186,           // #219
    #217#128,           // #220
    #217#129,           // #221
    #217#130,           // #222
    #217#131,           // #223
    #195#160,           // #224
    #217#132,           // #225
    #195#162,           // #226
    #217#133,           // #227
    #217#134,           // #228
    #217#135,           // #229
    #217#136,           // #230
    #195#167,           // #231
    #195#168,           // #232
    #195#169,           // #233
    #195#170,           // #234
    #195#171,           // #235
    #217#137,           // #236
    #217#138,           // #237
    #195#174,           // #238
    #195#175,           // #239
    #217#139,           // #240
    #217#140,           // #241
    #217#141,           // #242
    #217#142,           // #243
    #195#180,           // #244
    #217#143,           // #245
    #217#144,           // #246
    #195#183,           // #247
    #217#145,           // #248
    #195#185,           // #249
    #217#146,           // #250
    #195#187,           // #251
    #195#188,           // #252
    #226#128#142,       // #253
    #226#128#143,       // #254
    #219#146            // #255
  );

  ArrayCP1257ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #194#129,           // #129
    #226#128#154,       // #130
    #194#131,           // #131
    #226#128#158,       // #132
    #226#128#166,       // #133
    #226#128#160,       // #134
    #226#128#161,       // #135
    #194#136,           // #136
    #226#128#176,       // #137
    #194#138,           // #138
    #226#128#185,       // #139
    #194#140,           // #140
    #194#168,           // #141
    #203#135,           // #142
    #194#184,           // #143
    #194#144,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #194#152,           // #152
    #226#132#162,       // #153
    #194#154,           // #154
    #226#128#186,       // #155
    #194#156,           // #156
    #194#175,           // #157
    #203#155,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #194#161,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #194#164,           // #164
    #194#165,           // #165
    #194#166,           // #166
    #194#167,           // #167
    #195#152,           // #168
    #194#169,           // #169
    #197#150,           // #170
    #194#171,           // #171
    #194#172,           // #172
    #194#173,           // #173
    #194#174,           // #174
    #195#134,           // #175
    #194#176,           // #176
    #194#177,           // #177
    #194#178,           // #178
    #194#179,           // #179
    #194#180,           // #180
    #194#181,           // #181
    #194#182,           // #182
    #194#183,           // #183
    #195#184,           // #184
    #194#185,           // #185
    #197#151,           // #186
    #194#187,           // #187
    #194#188,           // #188
    #194#189,           // #189
    #194#190,           // #190
    #195#166,           // #191
    #196#132,           // #192
    #196#174,           // #193
    #196#128,           // #194
    #196#134,           // #195
    #195#132,           // #196
    #195#133,           // #197
    #196#152,           // #198
    #196#146,           // #199
    #196#140,           // #200
    #195#137,           // #201
    #197#185,           // #202
    #196#150,           // #203
    #196#162,           // #204
    #196#182,           // #205
    #196#170,           // #206
    #196#187,           // #207
    #197#160,           // #208
    #197#131,           // #209
    #197#133,           // #210
    #195#147,           // #211
    #197#140,           // #212
    #195#149,           // #213
    #195#150,           // #214
    #195#151,           // #215
    #197#178,           // #216
    #197#129,           // #217
    #197#154,           // #218
    #197#170,           // #219
    #195#156,           // #220
    #197#187,           // #221
    #197#189,           // #222
    #195#159,           // #223
    #196#133,           // #224
    #196#175,           // #225
    #196#129,           // #226
    #196#135,           // #227
    #195#164,           // #228
    #195#165,           // #229
    #196#153,           // #230
    #196#147,           // #231
    #196#141,           // #232
    #195#169,           // #233
    #197#186,           // #234
    #196#151,           // #235
    #196#163,           // #236
    #196#183,           // #237
    #196#171,           // #238
    #196#188,           // #239
    #197#161,           // #240
    #197#132,           // #241
    #197#134,           // #242
    #195#179,           // #243
    #197#141,           // #244
    #195#181,           // #245
    #195#182,           // #246
    #195#183,           // #247
    #197#179,           // #248
    #197#130,           // #249
    #197#155,           // #250
    #197#171,           // #251
    #195#188,           // #252
    #197#188,           // #253
    #197#190,           // #254
    #203#153            // #255
  );

  ArrayCP1258ToUTF8: TCharToUTF8Table = (
  #0,                 // #0
  #1,                 // #1
  #2,                 // #2
  #3,                 // #3
  #4,                 // #4
  #5,                 // #5
  #6,                 // #6
  #7,                 // #7
  #8,                 // #8
  #9,                 // #9
  #10,                // #10
  #11,                // #11
  #12,                // #12
  #13,                // #13
  #14,                // #14
  #15,                // #15
  #16,                // #16
  #17,                // #17
  #18,                // #18
  #19,                // #19
  #20,                // #20
  #21,                // #21
  #22,                // #22
  #23,                // #23
  #24,                // #24
  #25,                // #25
  #26,                // #26
  #27,                // #27
  #28,                // #28
  #29,                // #29
  #30,                // #30
  #31,                // #31
  ' ',                // ' '
  '!',                // '!'
  '"',                // '"'
  '#',                // '#'
  '$',                // '$'
  '%',                // '%'
  '&',                // '&'
  '''',               // ''''
  '(',                // '('
  ')',                // ')'
  '*',                // '*'
  '+',                // '+'
  ',',                // ','
  '-',                // '-'
  '.',                // '.'
  '/',                // '/'
  '0',                // '0'
  '1',                // '1'
  '2',                // '2'
  '3',                // '3'
  '4',                // '4'
  '5',                // '5'
  '6',                // '6'
  '7',                // '7'
  '8',                // '8'
  '9',                // '9'
  ':',                // ':'
  ';',                // ';'
  '<',                // '<'
  '=',                // '='
  '>',                // '>'
  '?',                // '?'
  '@',                // '@'
  'A',                // 'A'
  'B',                // 'B'
  'C',                // 'C'
  'D',                // 'D'
  'E',                // 'E'
  'F',                // 'F'
  'G',                // 'G'
  'H',                // 'H'
  'I',                // 'I'
  'J',                // 'J'
  'K',                // 'K'
  'L',                // 'L'
  'M',                // 'M'
  'N',                // 'N'
  'O',                // 'O'
  'P',                // 'P'
  'Q',                // 'Q'
  'R',                // 'R'
  'S',                // 'S'
  'T',                // 'T'
  'U',                // 'U'
  'V',                // 'V'
  'W',                // 'W'
  'X',                // 'X'
  'Y',                // 'Y'
  'Z',                // 'Z'
  '[',                // '['
  '\',                // '\'
  ']',                // ']'
  '^',                // '^'
  '_',                // '_'
  '`',                // '`'
  'a',                // 'a'
  'b',                // 'b'
  'c',                // 'c'
  'd',                // 'd'
  'e',                // 'e'
  'f',                // 'f'
  'g',                // 'g'
  'h',                // 'h'
  'i',                // 'i'
  'j',                // 'j'
  'k',                // 'k'
  'l',                // 'l'
  'm',                // 'm'
  'n',                // 'n'
  'o',                // 'o'
  'p',                // 'p'
  'q',                // 'q'
  'r',                // 'r'
  's',                // 's'
  't',                // 't'
  'u',                // 'u'
  'v',                // 'v'
  'w',                // 'w'
  'x',                // 'x'
  'y',                // 'y'
  'z',                // 'z'
  '{',                // '{'
  '|',                // '|'
  '}',                // '}'
  '~',                // '~'
  #127,               // #127
  #226#130#172,       // #128
  #194#129,           // #129
  #226#128#154,       // #130
  #198#146,           // #131
  #226#128#158,       // #132
  #226#128#166,       // #133
  #226#128#160,       // #134
  #226#128#161,       // #135
  #203#134,           // #136
  #226#128#176,       // #137
  #194#138,           // #138
  #226#128#185,       // #139
  #197#146,           // #140
  #194#141,           // #141
  #194#142,           // #142
  #194#143,           // #143
  #194#144,           // #144
  #226#128#152,       // #145
  #226#128#153,       // #146
  #226#128#156,       // #147
  #226#128#157,       // #148
  #226#128#162,       // #149
  #226#128#147,       // #150
  #226#128#148,       // #151
  #203#156,           // #152
  #226#132#162,       // #153
  #194#154,           // #154
  #226#128#186,       // #155
  #197#147,           // #156
  #194#157,           // #157
  #194#158,           // #158
  #197#184,           // #159
  #194#160,           // #160
  #194#161,           // #161
  #194#162,           // #162
  #194#163,           // #163
  #194#164,           // #164
  #194#165,           // #165
  #194#166,           // #166
  #194#167,           // #167
  #194#168,           // #168
  #194#169,           // #169
  #194#170,           // #170
  #194#171,           // #171
  #194#172,           // #172
  #194#173,           // #173
  #194#174,           // #174
  #194#175,           // #175
  #194#176,           // #176
  #194#177,           // #177
  #194#178,           // #178
  #194#179,           // #179
  #194#180,           // #180
  #194#181,           // #181
  #194#182,           // #182
  #194#183,           // #183
  #194#184,           // #184
  #194#185,           // #185
  #194#186,           // #186
  #194#187,           // #187
  #194#188,           // #188
  #194#189,           // #189
  #194#190,           // #190
  #194#191,           // #191
  #195#128,           // #192
  #195#129,           // #193
  #195#130,           // #194
  #196#130,           // #195
  #195#132,           // #196
  #195#133,           // #197
  #195#134,           // #198
  #195#135,           // #199
  #195#136,           // #200
  #195#137,           // #201
  #195#138,           // #202
  #195#139,           // #203
  #204#128,           // #204
  #195#141,           // #205
  #195#142,           // #206
  #195#143,           // #207
  #196#144,           // #208
  #195#145,           // #209
  #204#137,           // #210
  #195#147,           // #211
  #195#148,           // #212
  #198#160,           // #213
  #195#150,           // #214
  #195#151,           // #215
  #195#152,           // #216
  #195#153,           // #217
  #195#154,           // #218
  #195#155,           // #219
  #195#156,           // #220
  #198#175,           // #221
  #204#131,           // #222
  #195#159,           // #223
  #195#160,           // #224
  #195#161,           // #225
  #195#162,           // #226
  #196#131,           // #227
  #195#164,           // #228
  #195#165,           // #229
  #195#166,           // #230
  #195#167,           // #231
  #195#168,           // #232
  #195#169,           // #233
  #195#170,           // #234
  #195#171,           // #235
  #204#129,           // #236
  #195#173,           // #237
  #195#174,           // #238
  #195#175,           // #239
  #196#145,           // #240
  #195#177,           // #241
  #204#163,           // #242
  #195#179,           // #243
  #195#180,           // #244
  #198#161,           // #245
  #195#182,           // #246
  #195#183,           // #247
  #195#184,           // #248
  #195#185,           // #249
  #195#186,           // #250
  #195#187,           // #251
  #195#188,           // #252
  #198#176,           // #253
  #226#130#171,       // #254
  #195#191            // #255
  );

  ArrayCP437ToUTF8 : TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #195#135,           // #128
    #195#188,           // #129
    #195#169,           // #130
    #195#162,           // #131
    #195#164,           // #132
    #195#160,           // #133
    #195#165,           // #134
    #195#167,           // #135
    #195#170,           // #136
    #195#171,           // #137
    #195#168,           // #138
    #195#175,           // #139
    #195#174,           // #140
    #195#172,           // #141
    #195#132,           // #142
    #195#133,           // #143
    #195#137,           // #144
    #195#166,           // #145
    #195#134,           // #146
    #195#180,           // #147
    #195#182,           // #148
    #195#178,           // #149
    #195#187,           // #150
    #195#185,           // #151
    #195#191,           // #152
    #195#150,           // #153
    #195#156,           // #154
    #194#162,           // #155
    #194#163,           // #156
    #194#165,           // #157
    #226#130#167,       // #158
    #198#146,           // #159
    #195#161,           // #160
    #195#173,           // #161
    #195#179,           // #162
    #195#186,           // #163
    #195#177,           // #164
    #195#145,           // #165
    #194#170,           // #166
    #194#186,           // #167
    #194#191,           // #168
    #226#140#144,       // #169
    #194#172,           // #170
    #194#189,           // #171
    #194#188,           // #172
    #194#161,           // #173
    #194#171,           // #174
    #194#187,           // #175
    #226#150#145,       // #176
    #226#150#146,       // #177
    #226#150#147,       // #178
    #226#148#130,       // #179
    #226#148#164,       // #180
    #226#149#161,       // #181
    #226#149#162,       // #182
    #226#149#150,       // #183
    #226#149#149,       // #184
    #226#149#163,       // #185
    #226#149#145,       // #186
    #226#149#151,       // #187
    #226#149#157,       // #188
    #226#149#156,       // #189
    #226#149#155,       // #190
    #226#148#144,       // #191
    #226#148#148,       // #192
    #226#148#180,       // #193
    #226#148#172,       // #194
    #226#148#156,       // #195
    #226#148#128,       // #196
    #226#148#188,       // #197
    #226#149#158,       // #198
    #226#149#159,       // #199
    #226#149#154,       // #200
    #226#149#148,       // #201
    #226#149#169,       // #202
    #226#149#166,       // #203
    #226#149#160,       // #204
    #226#149#144,       // #205
    #226#149#172,       // #206
    #226#149#167,       // #207
    #226#149#168,       // #208
    #226#149#164,       // #209
    #226#149#165,       // #210
    #226#149#153,       // #211
    #226#149#152,       // #212
    #226#149#146,       // #213
    #226#149#147,       // #214
    #226#149#171,       // #215
    #226#149#170,       // #216
    #226#148#152,       // #217
    #226#148#140,       // #218
    #226#150#136,       // #219
    #226#150#132,       // #220
    #226#150#140,       // #221
    #226#150#144,       // #222
    #226#150#128,       // #223
    #206#177,           // #224
    #195#159,           // #225
    #206#147,           // #226
    #207#128,           // #227
    #206#163,           // #228
    #207#131,           // #229
    #194#181,           // #230
    #207#132,           // #231
    #206#166,           // #232
    #206#152,           // #233
    #206#169,           // #234
    #206#180,           // #235
    #226#136#158,       // #236
    #207#134,           // #237
    #206#181,           // #238
    #226#136#169,       // #239
    #226#137#161,       // #240
    #194#177,           // #241
    #226#137#165,       // #242
    #226#137#164,       // #243
    #226#140#160,       // #244
    #226#140#161,       // #245
    #195#183,           // #246
    #226#137#136,       // #247
    #194#176,           // #248
    #226#136#153,       // #249
    #194#183,           // #250
    #226#136#154,       // #251
    #226#129#191,       // #252
    #194#178,           // #253
    #226#150#160,       // #254
    #194#160            // #255
  );

  ArrayCP850ToUTF8 : TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #195#135,           // #128
    #195#188,           // #129
    #195#169,           // #130
    #195#162,           // #131
    #195#164,           // #132
    #195#160,           // #133
    #195#165,           // #134
    #195#167,           // #135
    #195#170,           // #136
    #195#171,           // #137
    #195#168,           // #138
    #195#175,           // #139
    #195#174,           // #140
    #195#172,           // #141
    #195#132,           // #142
    #195#133,           // #143
    #195#137,           // #144
    #195#166,           // #145
    #195#134,           // #146
    #195#180,           // #147
    #195#182,           // #148
    #195#178,           // #149
    #195#187,           // #150
    #195#185,           // #151
    #195#191,           // #152
    #195#150,           // #153
    #195#156,           // #154
    #195#184,           // #155
    #194#163,           // #156
    #195#152,           // #157
    #195#151,           // #158
    #198#146,           // #159
    #195#161,           // #160
    #195#173,           // #161
    #195#179,           // #162
    #195#186,           // #163
    #195#177,           // #164
    #195#145,           // #165
    #194#170,           // #166
    #194#186,           // #167
    #194#191,           // #168
    #194#174,           // #169
    #194#172,           // #170
    #194#189,           // #171
    #194#188,           // #172
    #194#161,           // #173
    #194#171,           // #174
    #194#187,           // #175
    #226#150#145,       // #176
    #226#150#146,       // #177
    #226#150#147,       // #178
    #226#148#130,       // #179
    #226#148#164,       // #180
    #195#129,           // #181
    #195#130,           // #182
    #195#128,           // #183
    #194#169,           // #184
    #226#149#163,       // #185
    #226#149#145,       // #186
    #226#149#151,       // #187
    #226#149#157,       // #188
    #194#162,           // #189
    #194#165,           // #190
    #226#148#144,       // #191
    #226#148#148,       // #192
    #226#148#180,       // #193
    #226#148#172,       // #194
    #226#148#156,       // #195
    #226#148#128,       // #196
    #226#148#188,       // #197
    #195#163,           // #198
    #195#131,           // #199
    #226#149#154,       // #200
    #226#149#148,       // #201
    #226#149#169,       // #202
    #226#149#166,       // #203
    #226#149#160,       // #204
    #226#149#144,       // #205
    #226#149#172,       // #206
    #194#164,           // #207
    #195#176,           // #208
    #195#144,           // #209
    #195#138,           // #210
    #195#139,           // #211
    #195#136,           // #212
    #196#177,           // #213
    #195#141,           // #214
    #195#142,           // #215
    #195#143,           // #216
    #226#148#152,       // #217
    #226#148#140,       // #218
    #226#150#136,       // #219
    #226#150#132,       // #220
    #194#166,           // #221
    #195#140,           // #222
    #226#150#128,       // #223
    #195#147,           // #224
    #195#159,           // #225
    #195#148,           // #226
    #195#146,           // #227
    #195#181,           // #228
    #195#149,           // #229
    #194#181,           // #230
    #195#190,           // #231
    #195#158,           // #232
    #195#154,           // #233
    #195#155,           // #234
    #195#153,           // #235
    #195#189,           // #236
    #195#157,           // #237
    #194#175,           // #238
    #194#180,           // #239
    #194#173,           // #240
    #194#177,           // #241
    #226#128#151,       // #242
    #194#190,           // #243
    #194#182,           // #244
    #194#167,           // #245
    #195#183,           // #246
    #194#184,           // #247
    #194#176,           // #248
    #194#168,           // #249
    #194#183,           // #250
    #194#185,           // #251
    #194#179,           // #252
    #194#178,           // #253
    #226#150#160,       // #254
    #194#160            // #255
  );

  // ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/PC/CP852.TXT
  ArrayCP852ToUTF8 : TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #195#135,           // #128
    #195#188,           // #129
    #195#169,           // #130
    #195#162,           // #131
    #195#164,           // #132
    #197#175,           // #133
    #196#135,           // #134
    #195#167,           // #135
    #197#130,           // #136
    #195#171,           // #137
    #197#144,           // #138
    #197#145,           // #139
    #195#174,           // #140
    #197#185,           // #141
    #195#132,           // #142
    #196#134,           // #143
    #195#137,           // #144
    #196#185,           // #145
    #196#186,           // #146
    #195#180,           // #147
    #195#182,           // #148
    #196#189,           // #149
    #196#190,           // #150
    #197#154,           // #151
    #197#155,           // #152
    #195#150,           // #153
    #195#156,           // #154
    #197#164,           // #155
    #197#165,           // #156
    #197#129,           // #157
    #195#151,           // #158
    #196#141,           // #159
    #195#161,           // #160
    #195#173,           // #161
    #195#179,           // #162
    #195#186,           // #163
    #196#132,           // #164
    #196#133,           // #165
    #197#189,           // #166
    #197#190,           // #167
    #196#152,           // #168
    #196#153,           // #169
    #194#172,           // #170
    #197#186,           // #171
    #196#140,           // #172
    #197#159,           // #173
    #194#171,           // #174
    #194#187,           // #175
    #226#150#145,       // #176
    #226#150#146,       // #177
    #226#150#147,       // #178
    #226#148#130,       // #179
    #226#148#164,       // #180
    #195#129,           // #181
    #195#130,           // #182
    #196#154,           // #183
    #197#158,           // #184
    #226#149#163,       // #185
    #226#149#145,       // #186
    #226#149#151,       // #187
    #226#149#157,       // #188
    #197#187,           // #189
    #197#188,           // #190
    #226#148#144,       // #191
    #226#148#148,       // #192
    #226#148#180,       // #193
    #226#148#172,       // #194
    #226#148#156,       // #195
    #226#148#128,       // #196
    #226#148#188,       // #197
    #196#130,           // #198
    #196#131,           // #199
    #226#149#154,       // #200
    #226#149#148,       // #201
    #226#149#169,       // #202
    #226#149#166,       // #203
    #226#149#160,       // #204
    #226#149#144,       // #205
    #226#149#172,       // #206
    #194#164,           // #207
    #196#145,           // #208
    #196#144,           // #209
    #196#142,           // #210
    #195#139,           // #211
    #196#143,           // #212
    #197#135,           // #213
    #195#141,           // #214
    #195#142,           // #215
    #196#155,           // #216
    #226#148#152,       // #217
    #226#148#140,       // #218
    #226#150#136,       // #219
    #226#150#132,       // #220
    #197#162,           // #221
    #197#174,           // #222
    #226#150#128,       // #223
    #195#147,           // #224
    #195#159,           // #225
    #195#148,           // #226
    #197#131,           // #227
    #197#132,           // #228
    #197#136,           // #229
    #197#160,           // #230
    #197#161,           // #231
    #197#148,           // #232
    #195#154,           // #233
    #197#149,           // #234
    #197#176,           // #235
    #195#189,           // #236
    #195#157,           // #237
    #197#163,           // #238
    #194#180,           // #239
    #194#173,           // #240
    #203#157,           // #241
    #203#155,           // #242
    #203#135,           // #243
    #203#152,           // #244
    #194#167,           // #245
    #195#183,           // #246
    #194#184,           // #247
    #194#176,           // #248
    #194#168,           // #249
    #203#153,           // #250
    #197#177,           // #251
    #197#152,           // #252
    #197#153,           // #253
    #226#150#160,       // #254
    #194#160            // #255
  );

  ArrayCP865ToUTF8 : TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #195#135,           // #128
    #195#188,           // #129
    #195#169,           // #130
    #195#162,           // #131
    #195#164,           // #132
    #195#160,           // #133
    #195#165,           // #134
    #195#167,           // #135
    #195#170,           // #136
    #195#171,           // #137
    #195#168,           // #138
    #195#175,           // #139
    #195#174,           // #140
    #195#172,           // #141
    #195#132,           // #142
    #195#133,           // #143
    #195#137,           // #144
    #195#166,           // #145
    #195#134,           // #146
    #195#180,           // #147
    #195#182,           // #148
    #195#178,           // #149
    #195#187,           // #150
    #195#185,           // #151
    #195#191,           // #152
    #195#150,           // #153
    #195#156,           // #154
    #$C3#$B8,           // #155 (diff from cp437)
    #194#163,           // #156
    #$C3#$98,           // #157 (diff from cp437)
    #226#130#167,       // #158
    #198#146,           // #159
    #195#161,           // #160
    #195#173,           // #161
    #195#179,           // #162
    #195#186,           // #163
    #195#177,           // #164
    #195#145,           // #165
    #194#170,           // #166
    #194#186,           // #167
    #194#191,           // #168
    #226#140#144,       // #169
    #194#172,           // #170
    #194#189,           // #171
    #194#188,           // #172
    #194#161,           // #173
    #194#171,           // #174
    #$C2#$A4,           // #175 (diff from cp437)
    #226#150#145,       // #176
    #226#150#146,       // #177
    #226#150#147,       // #178
    #226#148#130,       // #179
    #226#148#164,       // #180
    #226#149#161,       // #181
    #226#149#162,       // #182
    #226#149#150,       // #183
    #226#149#149,       // #184
    #226#149#163,       // #185
    #226#149#145,       // #186
    #226#149#151,       // #187
    #226#149#157,       // #188
    #226#149#156,       // #189
    #226#149#155,       // #190
    #226#148#144,       // #191
    #226#148#148,       // #192
    #226#148#180,       // #193
    #226#148#172,       // #194
    #226#148#156,       // #195
    #226#148#128,       // #196
    #226#148#188,       // #197
    #226#149#158,       // #198
    #226#149#159,       // #199
    #226#149#154,       // #200
    #226#149#148,       // #201
    #226#149#169,       // #202
    #226#149#166,       // #203
    #226#149#160,       // #204
    #226#149#144,       // #205
    #226#149#172,       // #206
    #226#149#167,       // #207
    #226#149#168,       // #208
    #226#149#164,       // #209
    #226#149#165,       // #210
    #226#149#153,       // #211
    #226#149#152,       // #212
    #226#149#146,       // #213
    #226#149#147,       // #214
    #226#149#171,       // #215
    #226#149#170,       // #216
    #226#148#152,       // #217
    #226#148#140,       // #218
    #226#150#136,       // #219
    #226#150#132,       // #220
    #226#150#140,       // #221
    #226#150#144,       // #222
    #226#150#128,       // #223
    #206#177,           // #224
    #195#159,           // #225
    #206#147,           // #226
    #207#128,           // #227
    #206#163,           // #228
    #207#131,           // #229
    #194#181,           // #230
    #207#132,           // #231
    #206#166,           // #232
    #206#152,           // #233
    #206#169,           // #234
    #206#180,           // #235
    #226#136#158,       // #236
    #207#134,           // #237
    #206#181,           // #238
    #226#136#169,       // #239
    #226#137#161,       // #240
    #194#177,           // #241
    #226#137#165,       // #242
    #226#137#164,       // #243
    #226#140#160,       // #244
    #226#140#161,       // #245
    #195#183,           // #246
    #226#137#136,       // #247
    #194#176,           // #248
    #226#136#153,       // #249
    #194#183,           // #250
    #226#136#154,       // #251
    #226#129#191,       // #252
    #194#178,           // #253
    #226#150#160,       // #254
    #194#160            // #255
  );

  ArrayCP866ToUTF8 : TCharToUTF8Table = (
    #0,                 //#0
    #1,                 //#1
    #2,                 //#2
    #3,                 //#3
    #4,                 //#4
    #5,                 //#5
    #6,                 //#6
    #7,                 //#7
    #8,                 //#8
    #9,                 //#9
    #10,                //#10
    #11,                //#11
    #12,                //#12
    #13,                //#13
    #14,                //#14
    #15,                //#15
    #16,                //#16
    #17,                //#17
    #18,                //#18
    #19,                //#19
    #20,                //#20
    #21,                //#21
    #22,                //#22
    #23,                //#23
    #24,                //#24
    #25,                //#25
    #26,                //#26
    #27,                //#27
    #28,                //#28
    #29,                //#29
    #30,                //#30
    #31,                //#31
    #32,                //#32
    #33,                //#33
    #34,                //#34
    #35,                //#35
    #36,                //#36
    #37,                //#37
    #38,                //#38
    #39,                //#39
    #40,                //#40
    #41,                //#41
    #42,                //#42
    #43,                //#43
    #44,                //#44
    #45,                //#45
    #46,                //#46
    #47,                //#47
    #48,                //#48
    #49,                //#49
    #50,                //#50
    #51,                //#51
    #52,                //#52
    #53,                //#53
    #54,                //#54
    #55,                //#55
    #56,                //#56
    #57,                //#57
    #58,                //#58
    #59,                //#59
    #60,                //#60
    #61,                //#61
    #62,                //#62
    #63,                //#63
    #64,                //#64
    #65,                //#65
    #66,                //#66
    #67,                //#67
    #68,                //#68
    #69,                //#69
    #70,                //#70
    #71,                //#71
    #72,                //#72
    #73,                //#73
    #74,                //#74
    #75,                //#75
    #76,                //#76
    #77,                //#77
    #78,                //#78
    #79,                //#79
    #80,                //#80
    #81,                //#81
    #82,                //#82
    #83,                //#83
    #84,                //#84
    #85,                //#85
    #86,                //#86
    #87,                //#87
    #88,                //#88
    #89,                //#89
    #90,                //#90
    #91,                //#91
    #92,                //#92
    #93,                //#93
    #94,                //#94
    #95,                //#95
    #96,                //#96
    #97,                //#97
    #98,                //#98
    #99,                //#99
    #100,               //#100
    #101,               //#101
    #102,               //#102
    #103,               //#103
    #104,               //#104
    #105,               //#105
    #106,               //#106
    #107,               //#107
    #108,               //#108
    #109,               //#109
    #110,               //#110
    #111,               //#111
    #112,               //#112
    #113,               //#113
    #114,               //#114
    #115,               //#115
    #116,               //#116
    #117,               //#117
    #118,               //#118
    #119,               //#119
    #120,               //#120
    #121,               //#121
    #122,               //#122
    #123,               //#123
    #124,               //#124
    #125,               //#125
    #126,               //#126
    #127,               //#127
    #208#144,           //#128
    #208#145,           //#129
    #208#146,           //#130
    #208#147,           //#131
    #208#148,           //#132
    #208#149,           //#133
    #208#150,           //#134
    #208#151,           //#135
    #208#152,           //#136
    #208#153,           //#137
    #208#154,           //#138
    #208#155,           //#139
    #208#156,           //#140
    #208#157,           //#141
    #208#158,           //#142
    #208#159,           //#143
    #208#160,           //#144
    #208#161,           //#145
    #208#162,           //#146
    #208#163,           //#147
    #208#164,           //#148
    #208#165,           //#149
    #208#166,           //#150
    #208#167,           //#151
    #208#168,           //#152
    #208#169,           //#153
    #208#170,           //#154
    #208#171,           //#155
    #208#172,           //#156
    #208#173,           //#157
    #208#174,           //#158
    #208#175,           //#159
    #208#176,           //#160
    #208#177,           //#161
    #208#178,           //#162
    #208#179,           //#163
    #208#180,           //#164
    #208#181,           //#165
    #208#182,           //#166
    #208#183,           //#167
    #208#184,           //#168
    #208#185,           //#169
    #208#186,           //#170
    #208#187,           //#171
    #208#188,           //#172
    #208#189,           //#173
    #208#190,           //#174
    #208#191,           //#175
    #226#150#145,       //#176
    #226#150#146,       //#177
    #226#150#147,       //#178
    #226#148#130,       //#179
    #226#148#164,       //#180
    #226#149#161,       //#181
    #226#149#162,       //#182
    #226#149#150,       //#183
    #226#149#149,       //#184
    #226#149#163,       //#185
    #226#149#145,       //#186
    #226#149#151,       //#187
    #226#149#157,       //#188
    #226#149#156,       //#189
    #226#149#155,       //#190
    #226#148#144,       //#191
    #226#148#148,       //#192
    #226#148#180,       //#193
    #226#148#172,       //#194
    #226#148#156,       //#195
    #226#148#128,       //#196
    #226#148#188,       //#197
    #226#149#158,       //#198
    #226#149#159,       //#199
    #226#149#154,       //#200
    #226#149#148,       //#201
    #226#149#169,       //#202
    #226#149#166,       //#203
    #226#149#160,       //#204
    #226#149#144,       //#205
    #226#149#172,       //#206
    #226#149#167,       //#207
    #226#149#168,       //#208
    #226#149#164,       //#209
    #226#149#165,       //#210
    #226#149#153,       //#211
    #226#149#152,       //#212
    #226#149#146,       //#213
    #226#149#147,       //#214
    #226#149#171,       //#215
    #226#149#170,       //#216
    #226#148#152,       //#217
    #226#148#140,       //#218
    #226#150#136,       //#219
    #226#150#132,       //#220
    #226#150#140,       //#221
    #226#150#144,       //#222
    #226#150#128,       //#223
    #209#128,           //#224
    #209#129,           //#225
    #209#130,           //#226
    #209#131,           //#227
    #209#132,           //#228
    #209#133,           //#229
    #209#134,           //#230
    #209#135,           //#231
    #209#136,           //#232
    #209#137,           //#233
    #209#138,           //#234
    #209#139,           //#235
    #209#140,           //#236
    #209#141,           //#237
    #209#142,           //#238
    #209#143,           //#239
    #208#129,           //#240
    #209#145,           //#241
    #208#132,           //#242
    #209#148,           //#243
    #208#135,           //#244
    #209#151,           //#245
    #208#142,           //#246
    #209#158,           //#247
    #194#176,           //#248
    #226#136#153,       //#249
    #194#183,           //#250
    #226#136#154,       //#251
    #226#132#150,       //#252
    #194#164,           //#253
    #226#150#160,       //#254
    #194#160            //#255
  );

  ArrayCP874ToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #226#130#172,       // #128
    #194#129,           // #129
    #194#130,           // #130
    #194#131,           // #131
    #194#132,           // #132
    #226#128#166,       // #133
    #194#134,           // #134
    #194#135,           // #135
    #194#136,           // #136
    #194#137,           // #137
    #194#138,           // #138
    #194#139,           // #139
    #194#140,           // #140
    #194#141,           // #141
    #194#142,           // #142
    #194#143,           // #143
    #194#144,           // #144
    #226#128#152,       // #145
    #226#128#153,       // #146
    #226#128#156,       // #147
    #226#128#157,       // #148
    #226#128#162,       // #149
    #226#128#147,       // #150
    #226#128#148,       // #151
    #194#152,           // #152
    #194#153,           // #153
    #194#154,           // #154
    #194#155,           // #155
    #194#156,           // #156
    #194#157,           // #157
    #194#158,           // #158
    #194#159,           // #159
    #194#160,           // #160
    #224#184#129,       // #161
    #224#184#130,       // #162
    #224#184#131,       // #163
    #224#184#132,       // #164
    #224#184#133,       // #165
    #224#184#134,       // #166
    #224#184#135,       // #167
    #224#184#136,       // #168
    #224#184#137,       // #169
    #224#184#138,       // #170
    #224#184#139,       // #171
    #224#184#140,       // #172
    #224#184#141,       // #173
    #224#184#142,       // #174
    #224#184#143,       // #175
    #224#184#144,       // #176
    #224#184#145,       // #177
    #224#184#146,       // #178
    #224#184#147,       // #179
    #224#184#148,       // #180
    #224#184#149,       // #181
    #224#184#150,       // #182
    #224#184#151,       // #183
    #224#184#152,       // #184
    #224#184#153,       // #185
    #224#184#154,       // #186
    #224#184#155,       // #187
    #224#184#156,       // #188
    #224#184#157,       // #189
    #224#184#158,       // #190
    #224#184#159,       // #191
    #224#184#160,       // #192
    #224#184#161,       // #193
    #224#184#162,       // #194
    #224#184#163,       // #195
    #224#184#164,       // #196
    #224#184#165,       // #197
    #224#184#166,       // #198
    #224#184#167,       // #199
    #224#184#168,       // #200
    #224#184#169,       // #201
    #224#184#170,       // #202
    #224#184#171,       // #203
    #224#184#172,       // #204
    #224#184#173,       // #205
    #224#184#174,       // #206
    #224#184#175,       // #207
    #224#184#176,       // #208
    #224#184#177,       // #209
    #224#184#178,       // #210
    #224#184#179,       // #211
    #224#184#180,       // #212
    #224#184#181,       // #213
    #224#184#182,       // #214
    #224#184#183,       // #215
    #224#184#184,       // #216
    #224#184#185,       // #217
    #224#184#186,       // #218
    #195#155,           // #219
    #195#156,           // #220
    #195#157,           // #221
    #195#158,           // #222
    #224#184#191,       // #223
    #224#185#128,       // #224
    #224#185#129,       // #225
    #224#185#130,       // #226
    #224#185#131,       // #227
    #224#185#132,       // #228
    #224#185#133,       // #229
    #224#185#134,       // #230
    #224#185#135,       // #231
    #224#185#136,       // #232
    #224#185#137,       // #233
    #224#185#138,       // #234
    #224#185#139,       // #235
    #224#185#140,       // #236
    #224#185#141,       // #237
    #224#185#142,       // #238
    #224#185#143,       // #239
    #224#185#144,       // #240
    #224#185#145,       // #241
    #224#185#146,       // #242
    #224#185#147,       // #243
    #224#185#148,       // #244
    #224#185#149,       // #245
    #224#185#150,       // #246
    #224#185#151,       // #247
    #224#185#152,       // #248
    #224#185#153,       // #249
    #224#185#154,       // #250
    #224#185#155,       // #251
    #195#188,           // #252
    #195#189,           // #253
    #195#190,           // #254
    #195#191            // #255
  );

  ArrayKOI8RToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    // RFC 1489  https://tools.ietf.org/html/rfc1489
    #226#148#128,       // #128
    #226#148#130,       // #129
    #226#148#140,       // #130
    #226#148#144,       // #131
    #226#148#148,       // #132
    #226#148#152,       // #133
    #226#148#156,       // #134
    #226#148#164,       // #135
    #226#148#172,       // #136
    #226#148#180,       // #137
    #226#148#188,       // #138
    #226#150#128,       // #139
    #226#150#132,       // #140
    #226#150#136,       // #141
    #226#150#140,       // #142
    #226#150#144,       // #143
    #226#150#145,       // #144
    #226#150#146,       // #145
    #226#150#147,       // #146
    #226#140#160,       // #147
    #226#150#160,       // #148
    #226#136#153,       // #149
    #226#136#154,       // #150
    #226#137#136,       // #151
    #226#137#164,       // #152
    #226#137#165,       // #153
    #194#160,           // #154
    #226#140#161,       // #155
    #194#176,           // #156
    #194#178,           // #157
    #194#183,           // #158
    #195#183,           // #159
    #226#149#144,       // #160
    #226#149#145,       // #161
    #226#149#146,       // #162
    #209#145,           // #163
    #226#149#147,       // #164
    #226#149#148,       // #165
    #226#149#149,       // #166
    #226#149#150,       // #167
    #226#149#151,       // #168
    #226#149#152,       // #169
    #226#149#153,       // #170
    #226#149#154,       // #171
    #226#149#155,       // #172
    #226#149#156,       // #173
    #226#149#157,       // #174
    #226#149#158,       // #175
    #226#149#159,       // #176
    #226#149#160,       // #177
    #226#149#161,       // #178
    #208#129,           // #179
    #226#149#162,       // #180
    #226#149#163,       // #181
    #226#149#164,       // #182
    #226#149#165,       // #183
    #226#149#166,       // #184
    #226#149#167,       // #185
    #226#149#168,       // #186
    #226#149#169,       // #187
    #226#149#170,       // #188
    #226#149#171,       // #189
    #226#149#172,       // #190
    #194#169,           // #191
    #209#142,           // #192
    #208#176,           // #193
    #208#177,           // #194
    #209#134,           // #195
    #208#180,           // #196
    #208#181,           // #197
    #209#132,           // #198
    #208#179,           // #199
    #209#133,           // #200
    #208#184,           // #201
    #208#185,           // #202
    #208#186,           // #203
    #208#187,           // #204
    #208#188,           // #205
    #208#189,           // #206
    #208#190,           // #207
    #208#191,           // #208
    #209#143,           // #209
    #209#128,           // #210
    #209#129,           // #211
    #209#130,           // #212
    #209#131,           // #213
    #208#182,           // #214
    #208#178,           // #215
    #209#140,           // #216
    #209#139,           // #217
    #208#183,           // #218
    #209#136,           // #219
    #209#141,           // #220
    #209#137,           // #221
    #209#135,           // #222
    #209#138,           // #223
    #208#174,           // #224
    #208#144,           // #225
    #208#145,           // #226
    #208#166,           // #227
    #208#148,           // #228
    #208#149,           // #229
    #208#164,           // #230
    #208#147,           // #231
    #208#165,           // #232
    #208#152,           // #233
    #208#153,           // #234
    #208#154,           // #235
    #208#155,           // #236
    #208#156,           // #237
    #208#157,           // #238
    #208#158,           // #239
    #208#159,           // #240
    #208#175,           // #241
    #208#160,           // #242
    #208#161,           // #243
    #208#162,           // #244
    #208#163,           // #245
    #208#150,           // #246
    #208#146,           // #247
    #208#172,           // #248
    #208#171,           // #249
    #208#151,           // #250
    #208#168,           // #251
    #208#173,           // #252
    #208#169,           // #253
    #208#167,           // #254
    #208#170            // #255
  );

  ArrayKOI8UToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    // RFC 2319  https://tools.ietf.org/html/rfc2319
    #226#148#128,       // #128
    #226#148#130,       // #129
    #226#148#140,       // #130
    #226#148#144,       // #131
    #226#148#148,       // #132
    #226#148#152,       // #133
    #226#148#156,       // #134
    #226#148#164,       // #135
    #226#148#172,       // #136
    #226#148#180,       // #137
    #226#148#188,       // #138
    #226#150#128,       // #139
    #226#150#132,       // #140
    #226#150#136,       // #141
    #226#150#140,       // #142
    #226#150#144,       // #143
    #226#150#145,       // #144
    #226#150#146,       // #145
    #226#150#147,       // #146
    #226#140#160,       // #147
    #226#150#160,       // #148
    #226#136#153,       // #149
    #226#136#154,       // #150
    #226#137#136,       // #151
    #226#137#164,       // #152
    #226#137#165,       // #153
    #194#160,           // #154
    #226#140#161,       // #155
    #194#176,           // #156
    #194#178,           // #157
    #194#183,           // #158
    #195#183,           // #159
    #226#149#144,       // #160
    #226#149#145,       // #161
    #226#149#146,       // #162
    #209#145,           // #163
    #209#148,           // #164
    #226#149#148,       // #165
    #209#150,           // #166
    #209#151,           // #167
    #226#149#151,       // #168
    #226#149#152,       // #169
    #226#149#153,       // #170
    #226#149#154,       // #171
    #226#149#155,       // #172
    #210#145,           // #173
    #226#149#157,       // #174
    #226#149#158,       // #175
    #226#149#159,       // #176
    #226#149#160,       // #177
    #226#149#161,       // #178
    #208#129,           // #179
    #208#132,           // #180
    #226#149#163,       // #181
    #208#134,           // #182
    #208#135,           // #183
    #226#149#166,       // #184
    #226#149#167,       // #185
    #226#149#168,       // #186
    #226#149#169,       // #187
    #226#149#170,       // #188
    #210#144,           // #189
    #226#149#172,       // #190
    #194#169,           // #191
    #209#142,           // #192
    #208#176,           // #193
    #208#177,           // #194
    #209#134,           // #195
    #208#180,           // #196
    #208#181,           // #197
    #209#132,           // #198
    #208#179,           // #199
    #209#133,           // #200
    #208#184,           // #201
    #208#185,           // #202
    #208#186,           // #203
    #208#187,           // #204
    #208#188,           // #205
    #208#189,           // #206
    #208#190,           // #207
    #208#191,           // #208
    #209#143,           // #209
    #209#128,           // #210
    #209#129,           // #211
    #209#130,           // #212
    #209#131,           // #213
    #208#182,           // #214
    #208#178,           // #215
    #209#140,           // #216
    #209#139,           // #217
    #208#183,           // #218
    #209#136,           // #219
    #209#141,           // #220
    #209#137,           // #221
    #209#135,           // #222
    #209#138,           // #223
    #208#174,           // #224
    #208#144,           // #225
    #208#145,           // #226
    #208#166,           // #227
    #208#148,           // #228
    #208#149,           // #229
    #208#164,           // #230
    #208#147,           // #231
    #208#165,           // #232
    #208#152,           // #233
    #208#153,           // #234
    #208#154,           // #235
    #208#155,           // #236
    #208#156,           // #237
    #208#157,           // #238
    #208#158,           // #239
    #208#159,           // #240
    #208#175,           // #241
    #208#160,           // #242
    #208#161,           // #243
    #208#162,           // #244
    #208#163,           // #245
    #208#150,           // #246
    #208#146,           // #247
    #208#172,           // #248
    #208#171,           // #249
    #208#151,           // #250
    #208#168,           // #251
    #208#173,           // #252
    #208#169,           // #253
    #208#167,           // #254
    #208#170            // #255
  );

  ArrayKOI8RUToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    // http://sofia.nmsu.edu/~mleisher/Software/csets/KOI8RU.TXT
    #226#148#128,       // #128
    #226#148#130,       // #129
    #226#148#140,       // #130
    #226#148#144,       // #131
    #226#148#148,       // #132
    #226#148#152,       // #133
    #226#148#156,       // #134
    #226#148#164,       // #135
    #226#148#172,       // #136
    #226#148#180,       // #137
    #226#148#188,       // #138
    #226#150#128,       // #139
    #226#150#132,       // #140
    #226#150#136,       // #141
    #226#150#140,       // #142
    #226#150#144,       // #143
    #226#150#145,       // #144
    #226#150#146,       // #145
    #226#150#147,       // #146
    #226#128#156,       // #147
    #226#150#160,       // #148
    #226#136#153,       // #149
    #226#128#157,       // #150
    #226#128#148,       // #151
    #226#132#150,       // #152
    #226#132#162,       // #153
    #194#160,           // #154
    #194#187,           // #155
    #194#174,           // #156
    #194#171,           // #157
    #194#183,           // #158
    #194#164,           // #159
    #226#149#144,       // #160
    #226#149#145,       // #161
    #226#149#146,       // #162
    #209#145,           // #163
    #209#148,           // #164
    #226#149#148,       // #165
    #209#150,           // #166
    #209#151,           // #167
    #226#149#151,       // #168
    #226#149#152,       // #169
    #226#149#153,       // #170
    #226#149#154,       // #171
    #226#149#155,       // #172
    #210#145,           // #173
    #209#158,           // #174
    #226#149#158,       // #175
    #226#149#159,       // #176
    #226#149#160,       // #177
    #226#149#161,       // #178
    #208#129,           // #179
    #208#132,           // #180
    #226#149#163,       // #181
    #208#134,           // #182
    #208#135,           // #183
    #226#149#166,       // #184
    #226#149#167,       // #185
    #226#149#168,       // #186
    #226#149#169,       // #187
    #226#149#170,       // #188
    #210#144,           // #189
    #208#142,           // #190
    #194#169,           // #191
    #209#142,           // #192
    #208#176,           // #193
    #208#177,           // #194
    #209#134,           // #195
    #208#180,           // #196
    #208#181,           // #197
    #209#132,           // #198
    #208#179,           // #199
    #209#133,           // #200
    #208#184,           // #201
    #208#185,           // #202
    #208#186,           // #203
    #208#187,           // #204
    #208#188,           // #205
    #208#189,           // #206
    #208#190,           // #207
    #208#191,           // #208
    #209#143,           // #209
    #209#128,           // #210
    #209#129,           // #211
    #209#130,           // #212
    #209#131,           // #213
    #208#182,           // #214
    #208#178,           // #215
    #209#140,           // #216
    #209#139,           // #217
    #208#183,           // #218
    #209#136,           // #219
    #209#141,           // #220
    #209#137,           // #221
    #209#135,           // #222
    #209#138,           // #223
    #208#174,           // #224
    #208#144,           // #225
    #208#145,           // #226
    #208#166,           // #227
    #208#148,           // #228
    #208#149,           // #229
    #208#164,           // #230
    #208#147,           // #231
    #208#165,           // #232
    #208#152,           // #233
    #208#153,           // #234
    #208#154,           // #235
    #208#155,           // #236
    #208#156,           // #237
    #208#157,           // #238
    #208#158,           // #239
    #208#159,           // #240
    #208#175,           // #241
    #208#160,           // #242
    #208#161,           // #243
    #208#162,           // #244
    #208#163,           // #245
    #208#150,           // #246
    #208#146,           // #247
    #208#172,           // #248
    #208#171,           // #249
    #208#151,           // #250
    #208#168,           // #251
    #208#173,           // #252
    #208#169,           // #253
    #208#167,           // #254
    #208#170            // #255
  );

  ArrayMacintoshToUTF8: TCharToUTF8Table = (
    #0,                 // #0
    #1,                 // #1
    #2,                 // #2
    #3,                 // #3
    #4,                 // #4
    #5,                 // #5
    #6,                 // #6
    #7,                 // #7
    #8,                 // #8
    #9,                 // #9
    #10,                // #10
    #11,                // #11
    #12,                // #12
    #13,                // #13
    #14,                // #14
    #15,                // #15
    #16,                // #16
    #17,                // #17
    #18,                // #18
    #19,                // #19
    #20,                // #20
    #21,                // #21
    #22,                // #22
    #23,                // #23
    #24,                // #24
    #25,                // #25
    #26,                // #26
    #27,                // #27
    #28,                // #28
    #29,                // #29
    #30,                // #30
    #31,                // #31
    ' ',                // ' '
    '!',                // '!'
    '"',                // '"'
    '#',                // '#'
    '$',                // '$'
    '%',                // '%'
    '&',                // '&'
    '''',               // ''''
    '(',                // '('
    ')',                // ')'
    '*',                // '*'
    '+',                // '+'
    ',',                // ','
    '-',                // '-'
    '.',                // '.'
    '/',                // '/'
    '0',                // '0'
    '1',                // '1'
    '2',                // '2'
    '3',                // '3'
    '4',                // '4'
    '5',                // '5'
    '6',                // '6'
    '7',                // '7'
    '8',                // '8'
    '9',                // '9'
    ':',                // ':'
    ';',                // ';'
    '<',                // '<'
    '=',                // '='
    '>',                // '>'
    '?',                // '?'
    '@',                // '@'
    'A',                // 'A'
    'B',                // 'B'
    'C',                // 'C'
    'D',                // 'D'
    'E',                // 'E'
    'F',                // 'F'
    'G',                // 'G'
    'H',                // 'H'
    'I',                // 'I'
    'J',                // 'J'
    'K',                // 'K'
    'L',                // 'L'
    'M',                // 'M'
    'N',                // 'N'
    'O',                // 'O'
    'P',                // 'P'
    'Q',                // 'Q'
    'R',                // 'R'
    'S',                // 'S'
    'T',                // 'T'
    'U',                // 'U'
    'V',                // 'V'
    'W',                // 'W'
    'X',                // 'X'
    'Y',                // 'Y'
    'Z',                // 'Z'
    '[',                // '['
    '\',                // '\'
    ']',                // ']'
    '^',                // '^'
    '_',                // '_'
    '`',                // '`'
    'a',                // 'a'
    'b',                // 'b'
    'c',                // 'c'
    'd',                // 'd'
    'e',                // 'e'
    'f',                // 'f'
    'g',                // 'g'
    'h',                // 'h'
    'i',                // 'i'
    'j',                // 'j'
    'k',                // 'k'
    'l',                // 'l'
    'm',                // 'm'
    'n',                // 'n'
    'o',                // 'o'
    'p',                // 'p'
    'q',                // 'q'
    'r',                // 'r'
    's',                // 's'
    't',                // 't'
    'u',                // 'u'
    'v',                // 'v'
    'w',                // 'w'
    'x',                // 'x'
    'y',                // 'y'
    'z',                // 'z'
    '{',                // '{'
    '|',                // '|'
    '}',                // '}'
    '~',                // '~'
    #127,               // #127
    #195#132,           // #128
    #195#133,           // #129
    #195#135,           // #130
    #195#137,           // #131
    #195#145,           // #132
    #195#150,           // #133
    #195#156,           // #134
    #195#161,           // #135
    #195#160,           // #136
    #195#162,           // #137
    #195#164,           // #138
    #195#163,           // #139
    #195#165,           // #140
    #195#167,           // #141
    #195#169,           // #142
    #195#168,           // #143
    #195#170,           // #144
    #195#171,           // #145
    #195#173,           // #146
    #195#172,           // #147
    #195#174,           // #148
    #195#175,           // #149
    #195#177,           // #150
    #195#179,           // #151
    #195#178,           // #152
    #195#180,           // #153
    #195#182,           // #154
    #195#181,           // #155
    #195#186,           // #156
    #195#185,           // #157
    #195#187,           // #158
    #195#188,           // #159
    #226#128#160,       // #160
    #194#176,           // #161
    #194#162,           // #162
    #194#163,           // #163
    #194#167,           // #164
    #226#128#162,       // #165
    #194#182,           // #166
    #195#159,           // #167
    #194#174,           // #168
    #194#169,           // #169
    #226#132#162,       // #170
    #194#180,           // #171
    #194#168,           // #172
    #226#137#160,       // #173
    #195#134,           // #174
    #195#152,           // #175
    #226#136#158,       // #176
    #194#177,           // #177
    #226#137#164,       // #178
    #226#137#165,       // #179
    #194#165,           // #180
    #194#181,           // #181
    #226#136#130,       // #182
    #226#136#145,       // #183
    #226#136#143,       // #184
    #207#128,           // #185
    #226#136#171,       // #186
    #194#170,           // #187
    #194#186,           // #188
    #206#169,           // #189
    #195#166,           // #190
    #195#184,           // #191
    #194#191,           // #192
    #194#161,           // #193
    #194#172,           // #194
    #226#136#154,       // #195
    #198#146,           // #196
    #226#137#136,       // #197
    #206#148,           // #198
    #194#171,           // #199
    #194#187,           // #200
    #226#128#166,       // #201
    #194#160,           // #202
    #195#128,           // #203
    #195#131,           // #204
    #195#149,           // #205
    #197#146,           // #206
    #197#147,           // #207
    #226#128#147,       // #208
    #226#128#148,       // #209
    #226#128#156,       // #210
    #226#128#157,       // #211
    #226#128#152,       // #212
    #226#128#153,       // #213
    #195#183,           // #214
    #226#151#138,       // #215
    #195#191,           // #216
    #197#184,           // #217
    #226#129#132,       // #218
    #226#130#172,       // #219
    #226#128#185,       // #220
    #226#128#186,       // #221
    #239#172#129,       // #222
    #239#172#130,       // #223
    #226#128#161,       // #224
    #194#183,           // #225
    #226#128#154,       // #226
    #226#128#158,       // #227
    #226#128#176,       // #228
    #195#130,           // #229
    #195#138,           // #230
    #195#129,           // #231
    #195#139,           // #232
    #195#136,           // #233
    #195#141,           // #234
    #195#142,           // #235
    #195#143,           // #236
    #195#140,           // #237
    #195#147,           // #238
    #195#148,           // #239
    #238#128#158,       // #240
    #195#146,           // #241
    #195#154,           // #242
    #195#155,           // #243
    #195#153,           // #244
    #196#177,           // #245
    #203#134,           // #246
    #203#156,           // #247
    #194#175,           // #248
    #203#152,           // #249
    #203#153,           // #250
    #203#154,           // #251
    #194#184,           // #252
    #203#157,           // #253
    #203#155,           // #254
    #203#135            // #255
  );

