<?php declare(strict_types=1);

/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PHPUnit\TestFixture;

use PHPUnit\Framework\Attributes\DataProvider;
use PHPUnit\Framework\Attributes\RunInSeparateProcess;
use PHPUnit\Framework\TestCase;

final class TestProcessIsolationWithDataProvider extends TestCase
{
    public static function greetDataProvider(): iterable
    {
        yield ['Hello world!'];
    }

    #[RunInSeparateProcess]
    #[DataProvider('greetDataProvider')]
    public function testInIsolationWithProvider(string $expected): void
    {
        $this->assertSame($expected, 'Hello world!');
    }
}
