% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaps.R
\name{tidy.regsubsets}
\alias{tidy.regsubsets}
\alias{leaps_tidiers}
\title{Tidy a(n) regsubsets object}
\usage{
\method{tidy}{regsubsets}(x, ...)
}
\arguments{
\item{x}{A \code{regsubsets} object created by \code{\link[leaps:regsubsets]{leaps::regsubsets()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed("leaps")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(leaps)

# fit model
all_fits <- regsubsets(hp ~ ., mtcars)

# summarize model fit with tidiers
tidy(all_fits)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[leaps:regsubsets]{leaps::regsubsets()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{r.squared}{R squared statistic, or the percent of variation explained by the model.}
  \item{adj.r.squared}{Adjusted R squared statistic}
  \item{BIC}{Bayesian information criterion for the component.}
  \item{mallows_cp}{Mallow's Cp statistic.}

}
